/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.properties;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTBuildUtils;

public class RebuildOnNameChecksChangeDialog {
    public static final int CHANGED_NONE = 0;
    public static final int CHANGED_PATH = 1;
    private static final Object fSyncInstance = new Object();
    private static volatile RebuildOnNameChecksChangeDialog fInstance;
    private int fPageChanged = 0;
    private IProject fProject;
    private SendNotificationJob fNotificationJob = new SendNotificationJob();
    private static final Object FAMILY_PROPERTIES;

    static {
        FAMILY_PROPERTIES = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RebuildOnNameChecksChangeDialog getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new RebuildOnNameChecksChangeDialog();
            }
        }
        return fInstance;
    }

    public void setChanged(int changedType, IProject project) {
        this.fPageChanged |= changedType;
        this.fProject = project;
    }

    public void sendNotification() {
        this.fNotificationJob.schedule(150L);
    }

    class SendNotificationJob
    extends Job {
        public SendNotificationJob() {
            super("Properties Change Notification");
            this.setUser(false);
            this.setPriority(10);
        }

        public boolean belongsTo(Object family) {
            return family == FAMILY_PROPERTIES;
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                if (RebuildOnNameChecksChangeDialog.this.fPageChanged == 0) {
                    return Status.OK_STATUS;
                }
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Naming conventions changed!", null, "You changed the naming conventions of the project [" + ((SendNotificationJob)SendNotificationJob.this).RebuildOnNameChecksChangeDialog.this.fProject.getName() + "]. " + "\n" + "It is recommended to rebuild to refresh warnings.", 4, new String[]{"Rebuild Now", "Later"}, 0);
                        if (dialog.open() == 0) {
                            DVTBuildUtils.runInternalBuilder(((SendNotificationJob)SendNotificationJob.this).RebuildOnNameChecksChangeDialog.this.fProject);
                        }
                        ((SendNotificationJob)SendNotificationJob.this).RebuildOnNameChecksChangeDialog.this.fProject = null;
                        ((SendNotificationJob)SendNotificationJob.this).RebuildOnNameChecksChangeDialog.this.fPageChanged = 0;
                    }
                });
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            return Status.OK_STATUS;
        }
    }
}

