/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.refactor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.UndoEdit;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.precompiled.PrecompiledDBUtils;
import ro.amiq.dvt.ui.refactor.DVTTextFileChangeCommon;
import ro.amiq.dvt.utils.DVTFileUtils;

public class DVTTextFileChange
extends DVTTextFileChangeCommon {
    public DVTTextFileChange(String name, IFile file) {
        super(name, file);
    }

    protected UndoEdit performEdits(IDocument document) throws BadLocationException, MalformedTreeException {
        UndoEdit performEdits = super.performEdits(document);
        this.performEdits();
        return performEdits;
    }

    public void addEdit(TextEdit edit) throws MalformedTreeException {
        super.addEdit(edit);
    }

    public RefactoringStatus isValid(IProgressMonitor monitor) throws CoreException {
        RefactoringStatus result = super.isValid(monitor);
        ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)this.getFile());
        if (parserPath == null) {
            return result;
        }
        IProject project = this.getFile().getProject();
        if (project == null) {
            return result;
        }
        if (PrecompiledDBUtils.isManualPrecompiledFile(project, parserPath)) {
            result.addFatalError("File " + parserPath.path + " is precompiled.");
        }
        return result;
    }
}

