/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.refactor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public abstract class DVTTextFileChangeCommon
extends TextFileChange {
    protected Map<TextEdit, Map<String, List<IRegion>>> tracked = new HashMap<TextEdit, Map<String, List<IRegion>>>();

    protected DVTTextFileChangeCommon(String name, IFile file) {
        super(name, file);
    }

    protected void performEdits() throws MalformedTreeException {
        for (Map.Entry<TextEdit, Map<String, List<IRegion>>> entry : this.tracked.entrySet()) {
            TextEdit te = entry.getKey();
            Map<String, List<IRegion>> relativeRegionsByCategory = entry.getValue();
            LinkedHashMap absoluteRegionsByCategory = new LinkedHashMap();
            for (Map.Entry<String, List<IRegion>> entry2 : relativeRegionsByCategory.entrySet()) {
                String relativeRegionCategory = entry2.getKey();
                ArrayList<Region> absoluteRegions = new ArrayList<Region>();
                List<IRegion> categoryRelativeRegions = entry2.getValue();
                for (IRegion relativeRegion : categoryRelativeRegions) {
                    Region absoluteRegion = new Region(te.getOffset() + relativeRegion.getOffset(), relativeRegion.getLength());
                    absoluteRegions.add(absoluteRegion);
                }
                if (!absoluteRegionsByCategory.containsKey(relativeRegionCategory)) {
                    absoluteRegionsByCategory.put(relativeRegionCategory, new ArrayList());
                }
                ((List)absoluteRegionsByCategory.get(relativeRegionCategory)).addAll(absoluteRegions);
            }
            this.tracked.put(te, absoluteRegionsByCategory);
        }
    }

    public void addEdit(TextEdit edit, IRegion track) throws MalformedTreeException {
        if (track != null) {
            LinkedHashMap tracksByCategory = new LinkedHashMap();
            ArrayList<IRegion> tracks = new ArrayList<IRegion>(1);
            tracks.add(track);
            tracksByCategory.put("", tracks);
            this.tracked.put(edit, tracksByCategory);
        }
        this.addEdit(edit);
    }

    public void addEdit(TextEdit edit, Map<String, List<IRegion>> tracksByCategory) throws MalformedTreeException {
        this.tracked.put(edit, tracksByCategory);
        this.addEdit(edit);
    }

    public Collection<IRegion> getAbsoluteRegions() {
        ArrayList<IRegion> result = new ArrayList<IRegion>();
        for (Map<String, List<IRegion>> trackedRegionsByCategory : this.tracked.values()) {
            if (trackedRegionsByCategory == null || trackedRegionsByCategory.isEmpty()) continue;
            for (List<IRegion> trackedRegions : trackedRegionsByCategory.values()) {
                if (trackedRegions == null || trackedRegions.isEmpty()) continue;
                result.addAll(trackedRegions);
            }
        }
        return result;
    }

    public Collection<IRegion> getAbsoluteRegionsByCategory(String category) {
        ArrayList<IRegion> result = new ArrayList<IRegion>();
        for (Map<String, List<IRegion>> trackedRegionsByCategory : this.tracked.values()) {
            List<IRegion> trackedRegions;
            if (trackedRegionsByCategory == null || trackedRegionsByCategory.isEmpty() || !trackedRegionsByCategory.containsKey(category) || (trackedRegions = trackedRegionsByCategory.get(category)) == null || trackedRegions.isEmpty()) continue;
            result.addAll(trackedRegions);
        }
        return result;
    }

    public void clearAbsoluteRegions() {
        this.tracked.clear();
    }
}

