/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.refactor.connect;

import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.refactor.connect.ConnectUiUtils;
import ro.amiq.dvt.ui.views.IDVTJob;
import ro.amiq.dvt.ui.views.refactoring.RefactoringConnectView;

public class ConnectInstancesTextPreviewJob
extends WorkspaceJob
implements IDVTJob {
    private RefactoringConnectView refactoringConnectView;

    public ConnectInstancesTextPreviewJob(RefactoringConnectView refactoringConnectView) {
        super("Text Preview...");
        this.refactoringConnectView = refactoringConnectView;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) {
        if (TestHelper.isTestMode()) {
            this.testApplyChanges();
            return Status.OK_STATUS;
        }
        Utils.safeRunAsynchInUIThread(() -> {
            RefactoringProcessor refactoringProcessor = this.getProcessor();
            ProcessorBasedRefactoring processorBasedRefactoring = new ProcessorBasedRefactoring(refactoringProcessor);
            RefactoringWizard wizard = this.getWizard(processorBasedRefactoring);
            ConnectUiUtils op = new ConnectUiUtils(wizard);
            int runStatus = -1;
            try {
                runStatus = op.run(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "");
            }
            catch (InterruptedException interruptedException) {}
            if (runStatus == 0) {
                this.refactoringConnectView.resetView();
                this.refactoringConnectView.closeDiagramAndView();
            }
        });
        return Status.CANCEL_STATUS;
    }

    private RefactoringWizard getWizard(ProcessorBasedRefactoring processorBasedRefactoring) {
        return new RefactoringWizard((Refactoring)processorBasedRefactoring, 12){

            protected void addUserInputPages() {
            }
        };
    }

    private RefactoringProcessor getProcessor() {
        return new RefactoringProcessor(){

            public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
                return null;
            }

            public boolean isApplicable() throws CoreException {
                return false;
            }

            public String getProcessorName() {
                return "Test Preview Processor";
            }

            public String getIdentifier() {
                return null;
            }

            public Object[] getElements() {
                return null;
            }

            public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
                return ConnectInstancesTextPreviewJob.this.refactoringConnectView.getChangeResult();
            }

            public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
                return null;
            }

            public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
                return null;
            }
        };
    }

    private void testApplyChanges() {
        RefactoringProcessor processor = this.getProcessor();
        ProcessorBasedRefactoring refactoring = new ProcessorBasedRefactoring(processor);
        RefactoringWizard wizard = this.getWizard(refactoring);
        ConnectUiUtils op = new ConnectUiUtils(wizard);
        Runnable r = () -> {
            try {
                op.run(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Refactor Connect Instances");
            }
            catch (InterruptedException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        };
        TestHelper.runRefactoringThread(wizard, r, "Connect", null);
    }

    @Override
    public boolean isCanceled() {
        return false;
    }
}

