/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.refactor.connect;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.refactor.connect.AssociatedElements;
import ro.amiq.dvt.ui.refactor.connect.DVTNode;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IDVTJob;
import ro.amiq.dvt.ui.views.ViewsUtils;

public class DVTDesignHierarchyHook {
    private static final int INITIAL_CAPACITY = 4;
    private static long next;
    public static final HashMap<IRfInstanceElement, AssociatedElements> relations;
    public static boolean gatherAndDisplayTestInfo;
    public static IDVTElementWrapper elementWrapperRoot;

    static {
        relations = new HashMap();
        gatherAndDisplayTestInfo = false;
    }

    public static DVTNode getNodeById(DVTNode root, long id) {
        if (root == null) {
            return null;
        }
        if (root.wrapperID == id) {
            return root;
        }
        if (root.fChildren != null) {
            for (DVTNode child : root.fChildren) {
                DVTNode res = DVTDesignHierarchyHook.getNodeById(child, id);
                if (res == null) continue;
                return res;
            }
        }
        return null;
    }

    public static DVTNode processInstanceTreeBegin(IDVTElementWrapper t, IDVTJob connectJob) {
        if (ViewsUtils.isCanceled(connectJob)) {
            return null;
        }
        elementWrapperRoot = t;
        DVTNode root = new DVTNode();
        root.wrapperID = t.getUniqueID();
        root.fChildren = new ArrayList(4);
        relations.clear();
        DVTDesignHierarchyHook.processInstanceTree(root, t, connectJob);
        DVTDesignHierarchyHook.filterBlocks(root, connectJob);
        if (ViewsUtils.isCanceled(connectJob)) {
            return null;
        }
        return root;
    }

    private static void processInstanceTree(DVTNode node, IDVTElementWrapper tree, IDVTJob connectJob) {
        List children;
        if (ViewsUtils.isCanceled(connectJob)) {
            return;
        }
        if (tree == null) {
            return;
        }
        Object obj = tree.getRfElement();
        if (!(obj instanceof IRfNamedElement)) {
            return;
        }
        node.element = (IRfNamedElement)obj;
        node.wrapperID = tree.getUniqueID();
        node.instanceType = tree.getInstanceType();
        AssociatedElements trio = new AssociatedElements();
        trio.fConnectComponent = tree.getConnectComponent();
        trio.fConnectDesign = node.instanceType;
        if (node.element instanceof IRfInstanceElement) {
            relations.put((IRfInstanceElement)node.element, trio);
        }
        if ((children = tree.getChildren()) == null) {
            return;
        }
        try {
            for (IDVTElementWrapper elem : children) {
                if (ViewsUtils.isCanceled(connectJob)) {
                    return;
                }
                DVTNode child = new DVTNode();
                DVTDesignHierarchyHook.processInstanceTree(child, elem, connectJob);
                if (node.fChildren == null) {
                    node.fChildren = new ArrayList(4);
                }
                node.fChildren.add(child);
                child.fParent = node;
                if (!DVTDesignHierarchyHook.isFilterable(node)) continue;
                child.insideGenBlock = true;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private static boolean isFilterable(DVTNode node) {
        IRfBlockElement be;
        return node.element instanceof IRfBlockElement && ((be = (IRfBlockElement)node.element).getKind() == IRfNamedElement.ElementKind.VHDL_BLOCK || be.getKind() == IRfNamedElement.ElementKind.VLOG_GENERATE);
    }

    private static void filterBlocks(DVTNode node, IDVTJob connectJob) {
        if (ViewsUtils.isCanceled(connectJob)) {
            return;
        }
        boolean filter = DVTDesignHierarchyHook.isFilterable(node);
        if (filter) {
            node.fParent.fChildren.remove(node);
        }
        ArrayList<Object> children = node.fChildren != null ? new ArrayList<DVTNode>(node.fChildren) : new ArrayList(4);
        for (DVTNode dVTNode : children) {
            if (ViewsUtils.isCanceled(connectJob)) {
                return;
            }
            if (filter) {
                node.fParent.fChildren.add(dVTNode);
            }
            DVTDesignHierarchyHook.filterBlocks(dVTNode, connectJob);
        }
    }

    public static long getNext() {
        return next;
    }

    public static long setNext(long next) {
        DVTDesignHierarchyHook.next = next;
        return next;
    }

    public static void remove() {
        if (relations != null) {
            relations.clear();
        }
        elementWrapperRoot = null;
    }
}

