/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.refactor.connect;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.DVTRefactorConnectWizardInput;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.refactor.DVTRefactoringProcessor;
import ro.amiq.dvt.ui.refactor.connect.ConnectContributors;
import ro.amiq.dvt.ui.refactor.connect.IRefactorConnectAlgorithm;
import ro.amiq.dvt.ui.refactor.connect.RefactorInputWrapper;
import ro.amiq.dvt.ui.refactor.connect.TextChange;
import ro.amiq.dvt.ui.refactor.rename.DVTCompositeChange;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.refactoring.RefactoringConnectView;

public class DVTRefactorConnectProcessor
extends DVTRefactoringProcessor {
    DVTRefactorConnectWizardInput refactorInput;

    public DVTRefactorConnectProcessor(DVTRefactorConnectWizardInput refactorInput) {
        this.refactorInput = refactorInput;
    }

    public Object[] getElements() {
        return new Object[0];
    }

    public String getIdentifier() {
        return "DVTRefactorConnectProcessor";
    }

    public String getProcessorName() {
        return "Refactor Connect";
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return null;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        IProject proj = DVTPlugin.getSelectionManager().getLastSelectedProject();
        List<IRefactorConnectAlgorithm> algs = ConnectContributors.getAll();
        for (IRefactorConnectAlgorithm alg : algs) {
            alg.setProject(proj);
            if (!alg.isSupportedProject()) continue;
            alg.setRefactorInput(this.refactorInput);
            RefactoringConnectView view = (RefactoringConnectView)ViewsUtils.getViewById("ro.amiq.dvt.ui.views.RefactoringConnectView", true);
            if (view == null) {
                return null;
            }
            String fail = alg.validateWrappers(view.getSrcPath(), view.getSrcPort(), view.getDstPath(), view.getDstPort(), proj, this.refactorInput, (IProgressMonitor)new NullProgressMonitor());
            if (fail == null) continue;
            return RefactoringStatus.createFatalErrorStatus((String)fail);
        }
        return null;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        try {
            IProject proj = DVTPlugin.getSelectionManager().getLastSelectedProject();
            DVTCompositeChange allChanges = new DVTCompositeChange("all changes");
            List<IRefactorConnectAlgorithm> algs = ConnectContributors.getAll();
            for (IRefactorConnectAlgorithm alg : algs) {
                alg.setProject(proj);
                if (!alg.isSupportedProject()) continue;
                alg.setRefactorInput(this.refactorInput);
                RefactoringConnectView view = (RefactoringConnectView)ViewsUtils.getViewById("ro.amiq.dvt.ui.views.RefactoringConnectView", true);
                if (view == null) {
                    return null;
                }
                Set<RefactorInputWrapper> treeChgs = alg.computeChangeWrappers(view.getSrcPath(), view.getSrcPort(), view.getDstPath(), view.getDstPort(), proj, (IProgressMonitor)new NullProgressMonitor());
                if (treeChgs == null) continue;
                Set<TextChange> textChgs = alg.computeChangesFromWrappers(treeChgs, pm);
                HashMap<IFile, ArrayList<TextChange>> textChgsByFile = new HashMap<IFile, ArrayList<TextChange>>();
                for (TextChange textChange : textChgs) {
                    IFile key = textChange.file;
                    ArrayList<TextChange> listChgs = (ArrayList<TextChange>)textChgsByFile.get(key);
                    if (listChgs == null) {
                        listChgs = new ArrayList<TextChange>();
                        textChgsByFile.put(key, listChgs);
                    }
                    listChgs.add(textChange);
                }
                for (Map.Entry entry : textChgsByFile.entrySet()) {
                    IFile file = (IFile)entry.getKey();
                    TextFileChange txc = alg.getPreviewHDLColoring(file);
                    txc.setEdit((TextEdit)new MultiTextEdit());
                    for (TextChange textChg : (List)entry.getValue()) {
                        if (textChg.offset < 0) continue;
                        txc.getEdit().addChild((TextEdit)new ReplaceEdit(textChg.offset, textChg.length, textChg.text));
                    }
                    allChanges.add((Change)txc);
                }
            }
            return allChanges;
        }
        catch (OperationCanceledException operationCanceledException) {
            return null;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }
}

