/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.refactor.designelement;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.DummyInstance;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfPredefinedGate;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.PortConnectionUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTCharacterScanner;
import ro.amiq.dvt.ui.refactor.connect.DVTNode;
import ro.amiq.dvt.utils.DVTDocumentUtils;

public class DVTRefactorDesignElementUtils {
    public static final String DEFAULT_VLOG_OUTPUT_PORT_NAME = "out_port";
    public static final String DEFAULT_VLOG_INPUT_PORT_NAME = "in_port";
    public static final String DEFAULT_VLOG_PARENT_SIGNAL = "connect_root";
    public static final String DEFAULT_VLOG_SIGNAL_TYPE = "wire";
    public static final String DEFAULT_VLOG_SIGNAL_WIDTH = "";
    public static final String DEFAULT_VHDL_OUTPUT_PORT_NAME = "out_port";
    public static final String DEFAULT_VHDL_INPUT_PORT_NAME = "in_port";
    public static final String DEFAULT_VHDL_PARENT_SIGNAL = "connect_root";
    public static final String DEFAULT_VHDL_SIGNAL_TYPE = "std_logic";
    public static final String DEFAULT_VHDL_SIGNAL_WIDTH = "";
    public static final String DEFAULT_NEW_PORT_NAME = "new_port";
    public static final String DEFAULT_NEW_PARAMETER_NAME = "new_parameter";
    public static final String DEFAULT_NEW_GENERIC_NAME = "new_generic";

    public static DVTNode getParentNodeIgnoringBlocks(DVTNode node) {
        if (node == null) {
            return null;
        }
        if (node.element instanceof IRfBlockElement && (((IRfBlockElement)node.element).getKind() == IRfNamedElement.ElementKind.VHDL_BLOCK || ((IRfBlockElement)node.element).getKind() == IRfNamedElement.ElementKind.VLOG_GENERATE)) {
            return DVTRefactorDesignElementUtils.getParentNodeIgnoringBlocks(node.fParent);
        }
        return node;
    }

    public static String[] getParentNodeIgnoringBlocks(String[] node, IProject project) {
        if (node == null) {
            return null;
        }
        IRfNamedElement elementFromSegments = DVTRefactorDesignElementUtils.getElementFromSegments(node, project);
        if (elementFromSegments instanceof DummyInstance) {
            elementFromSegments = ((DummyInstance)elementFromSegments).design;
        }
        if (elementFromSegments instanceof IRfBlockElement && (((IRfBlockElement)elementFromSegments).getKind() == IRfNamedElement.ElementKind.VHDL_BLOCK || ((IRfBlockElement)elementFromSegments).getKind() == IRfNamedElement.ElementKind.VLOG_GENERATE)) {
            return DVTRefactorDesignElementUtils.getParentNodeIgnoringBlocks(DVTRefactorDesignElementUtils.subList(node), project);
        }
        return node;
    }

    public static IRfNamedElement getElementFromSegments(String[] node, IProject project) {
        ELManager elManager = RfMixedLangManager.getInstance().getELManager(project);
        if (elManager == null) {
            return null;
        }
        ELInstance instanceFor = elManager.getMemory().instanceFor(ElementPath.create(node).toElaborationForm());
        if (instanceFor == null) {
            return null;
        }
        return instanceFor.getDescription();
    }

    public static DVTNode computeCommonAncestor(DVTNode src, DVTNode dst) {
        DVTNode p = src;
        while (p != null) {
            DVTNode q = dst;
            while (q != null) {
                if (p == q) {
                    return p;
                }
                q = q.fParent;
            }
            p = p.fParent;
        }
        throw new RuntimeException("Source and Destination are not on the same tree!");
    }

    public static String[] computeCommonAncestor(String[] src, String[] dst) {
        Object[] p = src;
        while (p != null) {
            Object[] q = dst;
            while (q != null) {
                if (Arrays.equals(p, q)) {
                    return p;
                }
                q = DVTRefactorDesignElementUtils.subList((String[])q);
            }
            p = DVTRefactorDesignElementUtils.subList((String[])p);
        }
        throw new RuntimeException("Source and Destination are not on the same tree!");
    }

    public static String[] computeCommonAncestorChild(String[] ancestor, String[] src, String[] dst) {
        String[] p;
        if (Arrays.equals(ancestor, src)) {
            p = dst;
            while (p != null) {
                if (Arrays.equals(DVTRefactorDesignElementUtils.subList(p), ancestor)) {
                    return p;
                }
                p = DVTRefactorDesignElementUtils.subList(p);
            }
        }
        if (Arrays.equals(ancestor, dst)) {
            p = src;
            while (p != null) {
                if (Arrays.equals(DVTRefactorDesignElementUtils.subList(p), ancestor)) {
                    return p;
                }
                p = DVTRefactorDesignElementUtils.subList(p);
            }
        }
        p = src;
        while (p != null) {
            if (Arrays.equals(DVTRefactorDesignElementUtils.subList(p), ancestor)) {
                return p;
            }
            p = DVTRefactorDesignElementUtils.subList(p);
        }
        throw new RuntimeException("Source and Destination are not on the same tree!");
    }

    public static String[] subList(String[] str) {
        if (str == null || str.length <= 1) {
            return null;
        }
        return Arrays.copyOf(str, str.length - 1);
    }

    public static <T> T getFirstSupportedScopeT(IRfScopeElement elem, Class<T> type) {
        IRfScopeElement scope = elem;
        int i = 0;
        while (i < 1000) {
            if ((scope = scope.getEnclosingScope()) == null) {
                return null;
            }
            if (type.isInstance(scope)) {
                return (T)scope;
            }
            ++i;
        }
        return null;
    }

    public static List<IRfInstanceElement> getAllDirectConnectedInstances(DVTNode rootNode, DVTNode srcNode, DVTNode dstNode) {
        ArrayList<IRfInstanceElement> result = new ArrayList<IRfInstanceElement>();
        int dir = 0;
        while (dir < 2) {
            DVTNode fromNode;
            DVTNode p = fromNode = dir == 0 ? srcNode : dstNode;
            while (p != rootNode) {
                if (p.element instanceof IRfInstanceElement) {
                    result.add((IRfInstanceElement)p.element);
                }
                p = p.fParent;
            }
            ++dir;
        }
        return result;
    }

    public static List<IRfInstanceElement> getAllDirectConnectedInstances(String[] rootNode, String[] srcNode, String[] dstNode, IProject project, IProgressMonitor monitor) {
        ArrayList<IRfInstanceElement> result = new ArrayList<IRfInstanceElement>();
        int dir = 0;
        while (dir < 2) {
            Object[] fromNode;
            Object[] p = fromNode = dir == 0 ? srcNode : dstNode;
            while (!Arrays.equals(p, rootNode)) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IRfNamedElement elementFromSegments = DVTRefactorDesignElementUtils.getElementFromSegments((String[])p, project);
                if (elementFromSegments instanceof IRfInstanceElement) {
                    result.add((IRfInstanceElement)elementFromSegments);
                }
                p = DVTRefactorDesignElementUtils.subList((String[])p);
            }
            ++dir;
        }
        return result;
    }

    public static String getPreviousElementIndent(IDocument document, int prevElementStartOffset, int minLimit, String partitioning) throws BadLocationException {
        int colonOffset;
        int nextChar;
        block11: {
            block10: {
                if (document != null && prevElementStartOffset >= 0 && prevElementStartOffset <= document.getLength()) break block10;
                return "";
            }
            nextChar = -1;
            colonOffset = -1;
            if ("__vlog_partitioning".equals(partitioning)) {
                colonOffset = DVTDocumentUtils.getCharOffset(',', prevElementStartOffset, false, 100, document, partitioning);
            } else if ("__vhdl_partitioning".equals(partitioning)) {
                colonOffset = DVTDocumentUtils.getCharOffset(';', prevElementStartOffset, false, 100, document, partitioning);
            }
            if (colonOffset < 0 || colonOffset < minLimit) {
                colonOffset = DVTDocumentUtils.getCharOffset('(', prevElementStartOffset, false, 100, document, partitioning);
            }
            if (colonOffset >= 0 && colonOffset >= minLimit) break block11;
            return "";
        }
        try {
            String indent = "";
            DVTCharacterScanner cs = new DVTCharacterScanner(100, document, colonOffset, true);
            while ((nextChar = cs.read()) != -1) {
                String contentType = ((IDocumentExtension3)document).getContentType(partitioning, cs.getOffset(), false);
                if (contentType.equals("__vhdl_ml_comment") || contentType.equals("__vhdl_sl_comment") || contentType.equals("__vlog_ml_comment") || contentType.equals("__vlog_sl_comment")) continue;
                if ((char)nextChar == '\r' || (char)nextChar == '\n') {
                    indent = String.valueOf(indent) + (char)nextChar;
                    continue;
                }
                if (!Character.isWhitespace(nextChar)) break;
                indent = String.valueOf(indent) + (char)nextChar;
            }
            return indent;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return "";
        }
    }

    public static String wrapInBrackets(String width, String openBracket, String closedBracket) {
        if (width == null) {
            return "";
        }
        if ((width = width.trim()).isEmpty()) {
            return "";
        }
        if (!width.startsWith(openBracket)) {
            width = String.valueOf(openBracket) + width;
        }
        if (!width.endsWith(closedBracket)) {
            width = String.valueOf(width) + closedBracket;
        }
        return width;
    }

    public static String getBracketIndent(int offset, IDocument document) {
        String indent = "";
        if (document == null || offset < 0 || offset > document.getLength()) {
            return "";
        }
        DVTCharacterScanner cs = new DVTCharacterScanner(500, document, offset, false);
        int nextChar = -1;
        while ((nextChar = cs.read()) != -1) {
            if (!Character.isWhitespace(nextChar) && (char)nextChar != '\r' && (char)nextChar != '\n') break;
            indent = String.valueOf((char)nextChar) + indent;
        }
        return indent;
    }

    public static boolean isOutput(String[] p, String[] srcNode, String[] dstNode) {
        if (Arrays.equals(p, srcNode)) {
            return true;
        }
        if (Arrays.equals(p, dstNode)) {
            return false;
        }
        Object[] temp = srcNode;
        while (temp != null) {
            if (Arrays.equals(temp, p)) {
                return true;
            }
            temp = DVTRefactorDesignElementUtils.subList((String[])temp);
        }
        temp = dstNode;
        while (temp != null) {
            if (Arrays.equals(temp, p)) {
                return false;
            }
            temp = DVTRefactorDesignElementUtils.subList((String[])temp);
        }
        return true;
    }

    public static boolean isSideEffect(String[] p, String[] srcPath, String[] dstPath) {
        Object[] temp = srcPath;
        while (temp != null) {
            if (Arrays.equals(temp, p)) {
                return false;
            }
            temp = DVTRefactorDesignElementUtils.subList((String[])temp);
        }
        temp = dstPath;
        while (temp != null) {
            if (Arrays.equals(temp, p)) {
                return false;
            }
            temp = DVTRefactorDesignElementUtils.subList((String[])temp);
        }
        return true;
    }

    public static boolean isSamePartialPath(String[] rootPath, String[] copyOfRange) {
        if (rootPath == null || rootPath.length == 0 || copyOfRange == null || copyOfRange.length == 0) {
            return true;
        }
        if (rootPath.length > copyOfRange.length) {
            return true;
        }
        int i = 0;
        while (i < rootPath.length) {
            String root = rootPath[i];
            String copy = copyOfRange[i];
            if (!root.equals(copy)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isGenerate(IRfNamedElement elementFromSegments) {
        return elementFromSegments instanceof IRfBlockElement && (((IRfBlockElement)elementFromSegments).getKind() == IRfNamedElement.ElementKind.VLOG_GENERATE || ((IRfBlockElement)elementFromSegments).getKind() == IRfNamedElement.ElementKind.VHDL_BLOCK);
    }

    public static boolean isPredefinedGateInstance(IRfNamedElement namedElement, IProject project) {
        if (!(namedElement instanceof IRfInstanceElement)) {
            return false;
        }
        IELMemory memory = RfMixedLangManager.getInstance().getELMemory(project);
        if (memory == null) {
            return false;
        }
        List<ELInstance> instancesFor = memory.getInstancesFor((IRfInstanceElement)namedElement, 1);
        if (instancesFor == null || instancesFor.isEmpty()) {
            return false;
        }
        ELInstance instance = instancesFor.get(0);
        if (instance == null) {
            return false;
        }
        return instance.getBinding(true) instanceof IRfPredefinedGate;
    }

    public static boolean shouldNotShowConnectActions(IRfNamedElement namedElement, IProject project) {
        return !(namedElement instanceof IRfDesignElement) && !(namedElement instanceof IRfInstanceElement) && !(namedElement instanceof IRfPortElement) || DVTRefactorDesignElementUtils.isGenerate(namedElement) || DVTRefactorDesignElementUtils.isPredefinedGateInstance(namedElement, project);
    }

    public static boolean shouldNotShowConnectInEditorActions(IRfNamedElement namedElement, IProject project) {
        if (DVTRefactorDesignElementUtils.shouldNotShowConnectActions(namedElement, project)) {
            return true;
        }
        return namedElement instanceof IRfPortElement && namedElement.getEnclosingScope() instanceof IRfNamedElement && DVTRefactorDesignElementUtils.shouldNotShowConnectActions((IRfNamedElement)namedElement.getEnclosingScope(), project);
    }

    public static Boolean[] isPortConnected(final IRfPortElement port, IRfInstanceElement instance) {
        final Boolean[] isPortConnected = new Boolean[]{false};
        instance.visitHidObject(null, new IHidVisitor<HidOperator>(){

            @Override
            public boolean visit(HidOperator hidObject) {
                IHidObject lHValue = hidObject.getLHValue();
                if (!(lHValue instanceof Hid)) {
                    return true;
                }
                IRfNamedElement element = ((Hid)lHValue).getElement();
                if (port.equals(element) && !PortConnectionUtils.isUnconnected(hidObject)) {
                    isPortConnected[0] = true;
                }
                return true;
            }

            @Override
            public Class<HidOperator> getType() {
                return HidOperator.class;
            }
        });
        return isPortConnected;
    }
}

