/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.refactor.linkedpositions;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.ui.IWorkbenchPart;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTExitPolicyConfig;
import ro.amiq.dvt.utils.DVTDocumentUtils;

public class DVTExitPolicyProvider
implements LinkedModeUI.IExitPolicy {
    DVTExitPolicyConfig configuration;
    private final char CLOSING_BRACKET = (char)41;
    private final char OPENING_BRACKET = (char)40;
    private final char SEMI_COLON = (char)59;

    private DVTExitPolicyProvider(DVTExitPolicyConfig config) {
        this.configuration = config;
    }

    public static LinkedModeUI.IExitPolicy createExitPolicy(DVTExitPolicyConfig config) {
        return new DVTExitPolicyProvider(config);
    }

    public LinkedModeUI.ExitFlags doExit(LinkedModeModel model, VerifyEvent event, int offset, int length) {
        IDocument document;
        DVTEditor triggerEditor;
        DVTEditor targetEditor;
        block15: {
            block14: {
                if (event.character == '\r') break block14;
                return null;
            }
            targetEditor = this.configuration.getTargetEditor();
            LinkedModeModel linkedModel = this.configuration.getLinkedModeModel();
            triggerEditor = this.configuration.getTriggerEditor();
            document = targetEditor.getDocument();
            int cursorOffset = targetEditor.getCursor();
            if (linkedModel.anyPositionContains(cursorOffset)) break block15;
            return null;
        }
        try {
            if (!targetEditor.isDirty()) {
                targetEditor.doSave(null);
            }
            DVTUiUtils.getActivePage().activate((IWorkbenchPart)triggerEditor);
            int exitPosition = -1;
            int configOffset = this.configuration.getOffset();
            String partitioning = this.configuration.getPartitioning();
            if (this.configuration.isSearch()) {
                if (this.configuration.getCharacter() == ')') {
                    int openingBracketOffset = DVTDocumentUtils.getCharOffset('(', configOffset, true, 1000, document, partitioning);
                    exitPosition = DVTDocumentUtils.getMatchingRightBracketOffset(openingBracketOffset, targetEditor, document);
                } else if (this.configuration.getCharacter() == ';') {
                    exitPosition = DVTDocumentUtils.getCharOffset(this.configuration.getCharacter(), configOffset, true, 1000, document, partitioning) + 1;
                }
            } else if (this.configuration.isReturnToLine()) {
                exitPosition = document.getLineOffset(this.configuration.getLine());
            } else if (this.configuration.isReturnToOffset()) {
                exitPosition = configOffset;
            }
            if (exitPosition != -1) {
                triggerEditor.selectAndReveal(exitPosition, 0);
            }
        }
        catch (BadLocationException | BadPartitioningException e) {
            DVTLogger.INSTANCE.logError(e);
        }
        return null;
    }
}

