/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.refactor.linkedpositions;

import java.util.Collection;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.InclusivePositionUpdater;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.dvt.ui.refactor.DVTTextFileChange;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTExitPolicyConfig;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTExitPolicyProvider;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTLinkedPositionProviderCommon;

public class DVTLinkedPositionProvider
implements DVTLinkedPositionProviderCommon {
    private InclusivePositionUpdater fUpdater;
    private LinkedModeModel fLinkedProposalModel;
    private String fCategory;
    private boolean fHasPositions;
    private DVTEditor fTriggerEditor;
    private DVTEditor fTargetEditor;
    private LinkedModeUI.IExitPolicy fExitPolicy;
    private boolean fLinkedPositionOnTarget;

    public DVTLinkedPositionProvider(DVTEditor editor, LinkedModeModel linkedProposalModel, String category, boolean hasPositions) {
        this.fLinkedProposalModel = linkedProposalModel;
        this.fCategory = category;
        this.setHasPositions(hasPositions);
        this.fTriggerEditor = this.fTargetEditor = editor;
        this.fHasPositions = hasPositions;
    }

    public DVTLinkedPositionProvider(DVTEditor editor, LinkedModeModel linkedProposalModel, String category, boolean hasPositions, DVTTextFileChange textFileChange) {
        this(editor, linkedProposalModel, category, hasPositions);
    }

    public DVTLinkedPositionProvider(DVTEditor triggerEditor, DVTEditor targetEditor, LinkedModeModel linkedProposalModel, String category, boolean hasPositions, boolean linkedPositionOnTarget, DVTTextFileChange textFileChange) {
        this(triggerEditor, targetEditor, linkedProposalModel, category, hasPositions, linkedPositionOnTarget);
    }

    public DVTLinkedPositionProvider(DVTEditor triggerEditor, DVTEditor targetEditor, LinkedModeModel linkedProposalModel, String category, boolean hasPositions, boolean linkedPositionOnTarget) {
        this.fLinkedProposalModel = linkedProposalModel;
        this.fCategory = category;
        this.setHasPositions(hasPositions);
        this.fTriggerEditor = triggerEditor;
        this.fTargetEditor = targetEditor;
        this.fHasPositions = hasPositions;
        this.fLinkedPositionOnTarget = linkedPositionOnTarget;
    }

    public void addMultipleLinkedPosition(Collection<IRegion> regionsCollection, IDocument document, int masterOffset) throws Exception {
        LinkedPositionGroup multiplePositionsGroup = new LinkedPositionGroup();
        List<IRegion> absoluteRegions = this.addMultipleLinkedPosition(regionsCollection, masterOffset);
        for (IRegion absoluteRegion : absoluteRegions) {
            this.ensurePositionCategoryInstalled(document);
            document.addPosition(this.fCategory, (Position)new DVTPosition(absoluteRegion.getOffset(), absoluteRegion.getLength()));
            multiplePositionsGroup.addPosition(new LinkedPosition(document, absoluteRegion.getOffset(), absoluteRegion.getLength()));
        }
        this.fLinkedProposalModel.addGroup(multiplePositionsGroup);
    }

    public void addSingleLinkedPosition(int offset, int length, IDocument document) throws BadLocationException, BadPositionCategoryException {
        if (offset < 0 || offset + length > document.getLength()) {
            return;
        }
        LinkedPositionGroup singlePositionGroup = new LinkedPositionGroup();
        this.ensurePositionCategoryInstalled(document);
        document.addPosition(this.fCategory, (Position)new DVTPosition(offset, length));
        singlePositionGroup.addPosition(new LinkedPosition(document, offset, length));
        this.fLinkedProposalModel.addGroup(singlePositionGroup);
    }

    private void ensurePositionCategoryInstalled(final IDocument document) {
        if (!document.containsPositionCategory(this.fCategory)) {
            document.addPositionCategory(this.fCategory);
            this.fUpdater = new InclusivePositionUpdater(this.fCategory);
            document.addPositionUpdater((IPositionUpdater)this.fUpdater);
            this.fLinkedProposalModel.addLinkingListener(new ILinkedModeListener(){

                public void left(LinkedModeModel environment, int flags) {
                    DVTLinkedPositionProvider.this.ensurePositionCategoryRemoved(document);
                }

                public void suspend(LinkedModeModel environment) {
                }

                public void resume(LinkedModeModel environment, int flags) {
                }
            });
        }
    }

    private void ensurePositionCategoryRemoved(IDocument document) {
        if (document.containsPositionCategory(this.fCategory)) {
            try {
                document.removePositionCategory(this.fCategory);
            }
            catch (BadPositionCategoryException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            document.removePositionUpdater((IPositionUpdater)this.fUpdater);
        }
    }

    public void enterLinkedMode(IDocument document, DVTExitPolicyConfig config) {
        if (config != null) {
            config.setTargetEditor(this.fTargetEditor);
            config.setTriggerEditor(this.fTriggerEditor);
            config.setLinkedModeModel(this.fLinkedProposalModel);
            this.fExitPolicy = DVTExitPolicyProvider.createExitPolicy(config);
        }
        try {
            if (this.hasPositions()) {
                ITextViewer viewer = this.fTriggerEditor.getTextViewer();
                if (this.fLinkedPositionOnTarget) {
                    viewer = this.fTargetEditor.getTextViewer();
                }
                this.fLinkedProposalModel.forceInstall();
                LinkedModeUI ui = new LinkedModeUI(this.fLinkedProposalModel, viewer);
                if (this.fExitPolicy != null) {
                    ui.setExitPolicy(this.fExitPolicy);
                }
                ui.enter();
            } else {
                this.ensurePositionCategoryRemoved(document);
            }
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public boolean hasPositions() {
        return this.fHasPositions;
    }

    public void setHasPositions(boolean fHasPositions) {
        this.fHasPositions = fHasPositions;
    }
}

