/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.refactor.rename;

import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.util.RfGUIReferencesUtils;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.refactor.rename.DVTRenamePreferencesPage;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameRefactorInfo;
import ro.amiq.dvt.ui.refactor.rename.RenameAcrossHierarchyInfo;
import ro.amiq.dvt.ui.search.PortSignalEnum;
import ro.amiq.dvt.ui.utils.DVTColorUtil;

public class DVTRenameAcrossDesignHierarchyPreferencesPage
extends DVTRenamePreferencesPage {
    private static final String PREVIEW_IN_DIAGRAM1 = "<a>Preview the changes in a Schematic Diagram...</a>";
    private static final String PREVIEW_IN_DIAGRAM2 = "When done, click the |Resume| button in the Diagram Editor top bar to return to this dialog.";
    private static final String CUSTOM_MAXIMUM_LEVEL = "Maximum number of levels: ";
    private static final String OPTIONS_STRING = "More options...";
    private static final String RENAME_UP_THE_DESIGN_HIERARCHY = "Rename in parent instances";
    private static final String RENAME_DOWN_THE_DESING_HIERARCHY = "Rename in sub-instances";
    private static final String ONLY_DIGITS_FOR_DEPTH = "Depth should contain only digits!";
    private static final int DEPTH_MAX_NUMBER_OF_DIGITS = 2;
    private static final String ONE_STRING = "1";
    private static final String RENAME_ONLY_PORTS_SIGNALS_MATCHING_NAMES = "Traverse only name preserving port connections";
    private static final String HELP_ONLY_MATCHING = "By default, it will refactor across hierarchy all port connections implicated by the renamed signal. \n When checked, it will refactor across hierarchy only port connections whose ports have the same name and stops whenre their names differ.\n\n E.g .in(in)";
    private static final String HELP_MAX_LEVELS = "Skip instances situated in the design hierarchy more than the specified number of levels above or below the starting point.";
    private static final boolean USE_EXPAND_BAR = false;
    private Composite buttonsComposite;
    private Button fRenameInParentInstanceButton;
    private boolean renameInParentInstancesVal;
    private Button fRenameInSubInstancesButton;
    private boolean renameInSubInstancesVal;
    private Text fDepthText;
    private String depthTextVal;
    private Button fSelectOnlyMatchingNamesButton;
    private boolean selectOnlyMatchingNamesVal;
    private String fDepthValue;
    private Composite previewInDiagramComposite;

    public DVTRenameAcrossDesignHierarchyPreferencesPage(String name, DVTRenameRefactorInfo refactorInfo, String depthValue) {
        super(name, refactorInfo, refactorInfo.getNewName(), null);
        this.fDepthValue = depthValue;
    }

    public DVTRenameAcrossDesignHierarchyPreferencesPage(String name, DVTRenameRefactorInfo refactorInfo) {
        super(name, refactorInfo, null);
        this.fDepthValue = "";
    }

    @Override
    public void fillInWithOtherButtons(Composite parentComposite) {
        Composite upDownComposite = new Composite(parentComposite, 0);
        upDownComposite.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)upDownComposite);
        this.createRenameUpDownButtonAndLabel(upDownComposite);
        Object item = null;
        this.buttonsComposite = new Composite(parentComposite, 0);
        this.buttonsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.buttonsComposite.setLayout((Layout)new GridLayout(2, false));
        this.createDepthButtonAndLabel();
        if (item != null) {
            item.setControl((Control)this.buttonsComposite);
            item.setHeight(this.buttonsComposite.computeSize((int)-1, (int)-1).y + item.getHeaderHeight());
        }
        this.previewInDiagramComposite = new Composite(parentComposite, 0);
        this.previewInDiagramComposite.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)this.previewInDiagramComposite);
        Link previewInDiagramLink = new Link(this.previewInDiagramComposite, 2048);
        previewInDiagramLink.setText(PREVIEW_IN_DIAGRAM1);
        previewInDiagramLink.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RfGUIReferencesUtils.closeRenameAcrossWizardAndShowPreviewDiagram(DVTRenameAcrossDesignHierarchyPreferencesPage.this);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        StyledText previewInDiagramDetails = new StyledText(this.previewInDiagramComposite, 8);
        DVTColorUtil.INSTANCE.setBackground((Control)previewInDiagramDetails, DVTColorUtil.INSTANCE.getBackground((Control)previewInDiagramDetails.getParent()), true);
        int firstIndexOf = PREVIEW_IN_DIAGRAM2.indexOf("|");
        int lastIndexOf = PREVIEW_IN_DIAGRAM2.lastIndexOf("|");
        StyleRange styleRange = new StyleRange(firstIndexOf, lastIndexOf - firstIndexOf, null, null, 1);
        previewInDiagramDetails.setText(PREVIEW_IN_DIAGRAM2.replace("|", ""));
        previewInDiagramDetails.setStyleRange(styleRange);
    }

    private void createRenameUpDownButtonAndLabel(Composite parentComposite) {
        DVTRenameRefactorInfo refactorInfo = this.getRefactorInfo();
        this.fRenameInParentInstanceButton = new Button(parentComposite, 32);
        this.fRenameInParentInstanceButton.setText(RENAME_UP_THE_DESIGN_HIERARCHY);
        this.fRenameInParentInstanceButton.setSelection(PrefConst.renameInParentInstances());
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)this.fRenameInParentInstanceButton);
        this.fRenameInSubInstancesButton = new Button(parentComposite, 32);
        this.fRenameInSubInstancesButton.setText(RENAME_DOWN_THE_DESING_HIERARCHY);
        this.fRenameInSubInstancesButton.setSelection(PrefConst.renameInSubInstances());
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)this.fRenameInSubInstancesButton);
        this.fRenameInParentInstanceButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DVTRenameAcrossDesignHierarchyPreferencesPage.this.renameInParentInstancesVal = DVTRenameAcrossDesignHierarchyPreferencesPage.this.fRenameInParentInstanceButton.getSelection();
                DVTRenameAcrossDesignHierarchyPreferencesPage.this.setUserInput();
                PrefConst.setRenameInParentInstancesValue(DVTRenameAcrossDesignHierarchyPreferencesPage.this.fRenameInParentInstanceButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.renameInParentInstancesVal = this.fRenameInParentInstanceButton.getSelection();
        this.fRenameInSubInstancesButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DVTRenameAcrossDesignHierarchyPreferencesPage.this.renameInSubInstancesVal = DVTRenameAcrossDesignHierarchyPreferencesPage.this.fRenameInSubInstancesButton.getSelection();
                DVTRenameAcrossDesignHierarchyPreferencesPage.this.setUserInput();
                PrefConst.setRenameInSubInstancesValue(DVTRenameAcrossDesignHierarchyPreferencesPage.this.fRenameInSubInstancesButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.renameInSubInstancesVal = this.fRenameInSubInstancesButton.getSelection();
        this.setUserInput();
        if (refactorInfo.shouldGrayOutRenameInParentInstancesButton()) {
            this.renameInParentInstancesVal = false;
            this.setUserInput();
            this.fRenameInParentInstanceButton.setEnabled(false);
            return;
        }
        this.renameInParentInstancesVal = this.fRenameInParentInstanceButton.getSelection();
    }

    private void setUserInput() {
        DVTRenameRefactorInfo refactorInfo = this.getRefactorInfo();
        if (refactorInfo == null) {
            return;
        }
        RenameAcrossHierarchyInfo renameADHInfo = refactorInfo.getRenameADHInfo();
        if (renameADHInfo == null) {
            return;
        }
        renameADHInfo.setUserInput(this.getDepthValue(), this.selectOnlyMatchingNamesVal, this.renameInParentInstancesVal, this.renameInSubInstancesVal);
    }

    private void createDepthButtonAndLabel() {
        final Button renameDepthLabel = new Button(this.buttonsComposite, 32);
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)renameDepthLabel);
        DVTUiUtils.installQuickTooltip((Control)renameDepthLabel, (String)HELP_MAX_LEVELS);
        renameDepthLabel.setText(CUSTOM_MAXIMUM_LEVEL);
        renameDepthLabel.setSelection(!this.fDepthValue.isEmpty());
        renameDepthLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selection = renameDepthLabel.getSelection();
                if (selection) {
                    DVTRenameAcrossDesignHierarchyPreferencesPage.this.fDepthText.setText(DVTRenameAcrossDesignHierarchyPreferencesPage.ONE_STRING);
                } else {
                    DVTRenameAcrossDesignHierarchyPreferencesPage.this.fDepthText.setText("");
                }
                DVTRenameAcrossDesignHierarchyPreferencesPage.this.fDepthText.setEnabled(selection);
            }
        });
        this.fDepthText = new Text(this.buttonsComposite, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.fDepthText);
        this.fDepthText.setText(this.fDepthValue);
        this.fDepthText.setTextLimit(2);
        this.fDepthText.setEnabled(!this.fDepthValue.isEmpty());
        this.depthTextVal = this.fDepthText.getText();
        this.setUserInput();
        this.fDepthText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DVTRenameAcrossDesignHierarchyPreferencesPage.this.depthTextVal = DVTRenameAcrossDesignHierarchyPreferencesPage.this.fDepthText.getText();
                DVTRenameAcrossDesignHierarchyPreferencesPage.this.checkDepthFormat(e);
                DVTRenameAcrossDesignHierarchyPreferencesPage.this.setUserInput();
            }
        });
    }

    @Override
    public void fillInRenameStartingPointLabel(Composite mainComposite) {
        IRfNamedElement element = this.getRefactorInfo().getElement();
        if (element == null) {
            return;
        }
        String elementKind = element.getKindName();
        PortSignalEnum portOrSignalEnum = RfSearchUtils.getPortOrSignalEnum(element, this.getRefactorInfo().getProject());
        if (portOrSignalEnum == PortSignalEnum.SIGNAL_MATCH) {
            elementKind = "signal";
        }
        Label label = new Label(mainComposite, 0);
        label.setText("Rename " + elementKind + ":");
        GridDataFactory.fillDefaults().align(1, 128).grab(false, false).applyTo((Control)label);
        StyledText startPointLabel = new StyledText(mainComposite, 2056);
        DVTColorUtil.INSTANCE.setBackground((Control)startPointLabel, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.filter.backgroundColor"), true);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)startPointLabel);
        String instancePathPrefix = this.getInstancePathPrefix();
        String elementName = element.getName();
        startPointLabel.setText(String.valueOf(instancePathPrefix) + elementName);
        StyleRange styleRange = new StyleRange();
        styleRange.start = instancePathPrefix.length();
        styleRange.length = elementName.length();
        styleRange.fontStyle = 1;
        startPointLabel.setStyleRange(styleRange);
    }

    private void checkDepthFormat(ModifyEvent e) {
        String depthText = ((Text)e.widget).getText();
        char[] depthChars = new char[depthText.length()];
        depthText.getChars(0, depthChars.length, depthChars, 0);
        int i = 0;
        while (i < depthChars.length) {
            char ch = depthChars[i];
            if (i == 0 && depthChars.length == 1 && ch == '0') {
                this.incorrectDepthFormat();
                return;
            }
            if (i == 0 && depthChars.length != 1) {
                if (!this.isNonZeroDigit(ch)) {
                    this.incorrectDepthFormat();
                    return;
                }
            } else if (!this.isDigit(ch)) {
                this.incorrectDepthFormat();
                return;
            }
            ++i;
        }
        this.setPageComplete(true);
        Utils.setEnabledRecursive(this.previewInDiagramComposite, true);
        this.setMessage("");
    }

    public int getDepthValue() {
        if (this.depthTextVal == null) {
            return 0;
        }
        try {
            return Integer.valueOf(this.depthTextVal);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private void incorrectDepthFormat() {
        this.setMessage(ONLY_DIGITS_FOR_DEPTH, 3);
        Utils.setEnabledRecursive(this.previewInDiagramComposite, false);
        this.setPageComplete(false);
    }

    private boolean isNonZeroDigit(char ch) {
        return '1' <= ch && ch <= '9';
    }

    private boolean isDigit(char ch) {
        return '0' <= ch && ch <= '9';
    }

    private String getInstancePathPrefix() {
        RenameAcrossHierarchyInfo renameADHInfo = this.getRefactorInfo().getRenameADHInfo();
        if (renameADHInfo == null) {
            return "";
        }
        List<IRfNamedElement> designInstances = renameADHInfo.getDesignInstances();
        return RfSearchUtils.getDesignPath(designInstances);
    }

    private void createMatchingNamesButtonAndLabel() {
        this.fSelectOnlyMatchingNamesButton = new Button(this.buttonsComposite, 32);
        this.fSelectOnlyMatchingNamesButton.setText(RENAME_ONLY_PORTS_SIGNALS_MATCHING_NAMES);
        DVTUiUtils.installQuickTooltip((Control)this.fSelectOnlyMatchingNamesButton, (String)HELP_ONLY_MATCHING);
        GridData enableRename = new GridData(4, 1, true, false);
        enableRename.horizontalSpan = 2;
        this.fSelectOnlyMatchingNamesButton.setLayoutData((Object)enableRename);
        this.fSelectOnlyMatchingNamesButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DVTRenameAcrossDesignHierarchyPreferencesPage.this.selectOnlyMatchingNamesVal = DVTRenameAcrossDesignHierarchyPreferencesPage.this.fSelectOnlyMatchingNamesButton.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    @Override
    public boolean isRenameAcrossEnabled() {
        return true;
    }
}

