/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.refactor.rename;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.search.ui.text.Match;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.util.RfGUIReferencesUtils;
import ro.amiq.dvt.model.reflection.util.RfReferencesUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.refactor.DVTTextFileChange;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameRefactorInfo;
import ro.amiq.dvt.ui.search.BaseFileMatch;
import ro.amiq.dvt.ui.search.LeftRightHandSideOfOperatorEnum;

public abstract class DVTRenameDelegateCommon {
    protected DVTRenameRefactorInfo fRefactorInfo;
    protected static final GroupCategorySet SEMANTIC_CHANGES = new GroupCategorySet(new GroupCategory("ro.amiq.dvt.ui.refactor.rename.SEMANTIC_CHANGES", "Semantic changes", "Semantic changes"));
    protected static final GroupCategorySet POTENTIAL_MATCH = new GroupCategorySet(new GroupCategory("ro.amiq.dvt.ui.refactor.rename.POTENTIAL_MATCH", "Potential match", "Potential match"));
    protected static final GroupCategorySet SIDE_EFFECT_MATCH = new GroupCategorySet(new GroupCategory("ro.amiq.dvt.ui.refactor.rename.SIDE_EFFECT_MATCH", "Side effect match", "Side effect match"));
    protected static final GroupCategorySet CHANGES_IN_COMMENTS = new GroupCategorySet(new GroupCategory("ro.amiq.dvt.ui.refactor.rename.CHANGES_IN_COMMENTS", "Javadoc comments changes", "Javadoc comments changes"));
    protected boolean fUseScopeInfo;

    protected DVTRenameDelegateCommon(DVTRenameRefactorInfo info, boolean useScopeInfo) {
        this.fRefactorInfo = info;
        this.fUseScopeInfo = useScopeInfo;
    }

    public DVTRenameRefactorInfo getRefactorInfo() {
        return this.fRefactorInfo;
    }

    public boolean useScopeInfo() {
        return this.fUseScopeInfo;
    }

    public abstract RefactoringStatus checkInitialConditions(IProgressMonitor var1);

    protected abstract IStatus checkNewNameInternal(DVTRenameRefactorInfo var1);

    public IStatus checkNewName() {
        return this.checkNewNameInternal(this.fRefactorInfo);
    }

    protected void addToChangeGroup(DVTTextFileChange textFileChange, BaseFileMatch fileMatch, String matchString, boolean inComments, TextEdit replaceEdit, GroupCategorySet groupCategory) {
        GroupCategorySet gcs = fileMatch.isPossibleMatch() ? POTENTIAL_MATCH : (inComments ? CHANGES_IN_COMMENTS : groupCategory);
        TextEditChangeGroup textEditChangeGroup = new TextEditChangeGroup((TextChange)textFileChange, (TextEditGroup)new CategorizedTextEditGroup(matchString, replaceEdit, gcs));
        textFileChange.addTextEditChangeGroup(textEditChangeGroup);
    }

    public List<ReplaceEdit> renameDotStarImplicitInstanceConnection(DVTRenameRefactorInfo renameInfo, List<BaseFileMatch> fileMatches, DVTTextFileChange textFileChange, String matchString, IRfInstanceElement instance) {
        String queryName;
        String newName;
        IRfNamedElement namedElement;
        block19: {
            block18: {
                block17: {
                    namedElement = renameInfo.getElement();
                    if (namedElement != null) break block17;
                    return null;
                }
                newName = renameInfo.getNewName();
                if (newName != null) break block18;
                return null;
            }
            queryName = namedElement.getName();
            IRfScopeElement queryEnclosingScope = namedElement.getEnclosingScope();
            if (queryEnclosingScope instanceof IRfNamedElement) break block19;
            return null;
        }
        try {
            int i = 0;
            while (i < fileMatches.size()) {
                BaseFileMatch fileMatch = fileMatches.get(i);
                if (fileMatch.isInsideMacroCall()) {
                    IRfNamedElement fileMatchNamedElement = fileMatch.getLineElement().getNamedElement();
                    IRfNamedElement searchedElement = fileMatchNamedElement == null ? renameInfo.getElement() : fileMatchNamedElement;
                    InsertEdit insertEdit = RfReferencesUtils.createCommentForMacroHit(fileMatch, renameInfo, searchedElement);
                    RfGUIReferencesUtils.handleHitInsideMacroCall(textFileChange, insertEdit, matchString);
                } else {
                    String connectedElement = fileMatch.getConnectedElement();
                    queryName = connectedElement != null ? connectedElement : namedElement.getName();
                    if (fileMatch.isDotStarPortConnection()) {
                        if (fileMatches.size() > 2) {
                            DVTLogger.INSTANCE.logInfo("[SEARCH FOR REFERENCES] More than 2 matches found in .*/implicit port connections for instance '" + (instance == null ? "null" : instance.getFullNameLabel()) + "'");
                        }
                        if (fileMatches.size() > 1) break;
                        newConnection = null;
                        region = null;
                        String dotStarConnectionPrefix = ".*, .";
                        if (fileMatch.getLeftRightHandSideOfConnection() == LeftRightHandSideOfOperatorEnum.LEFT_HAND_MATCH) {
                            newConnection = String.valueOf(dotStarConnectionPrefix) + newName + "(" + queryName + ")";
                            region = new Region(dotStarConnectionPrefix.length(), newName.length());
                        } else {
                            newConnection = String.valueOf(dotStarConnectionPrefix) + queryName + "(" + newName + ")";
                            region = new Region(dotStarConnectionPrefix.length() + queryName.length() + 1, newName.length());
                        }
                        this.addEdit(textFileChange, fileMatch, newConnection, matchString, (IRegion)region);
                    } else if (fileMatch.isImplicitPortConnection()) {
                        newConnection = null;
                        if (fileMatches.size() > 1) {
                            this.addEdit(textFileChange, fileMatch, newName, matchString, (IRegion)new Region(0, fileMatch.getLength()));
                            break;
                        }
                        region = null;
                        if (fileMatch.getLeftRightHandSideOfConnection() == LeftRightHandSideOfOperatorEnum.LEFT_HAND_MATCH) {
                            newConnection = String.valueOf(newName) + "(" + queryName + ")";
                            region = new Region(0, newName.length());
                        } else {
                            newConnection = String.valueOf(queryName) + "(" + newName + ")";
                            region = new Region(queryName.length() + 1, newName.length());
                        }
                        this.addEdit(textFileChange, fileMatch, newConnection, matchString, (IRegion)region);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    public DVTTextFileChange createTextEdit(IFile file, CompositeChange rootChange) {
        DVTTextFileChange textFileChange = this.getTextFileChange(file);
        textFileChange.setEdit((TextEdit)new MultiTextEdit());
        rootChange.add((Change)textFileChange);
        return textFileChange;
    }

    public void createChanges(IProgressMonitor pm, CompositeChange rootChange, Map<IFile, DVTTextFileChange> textChanges) {
        HashMap<IResource, Match[]> matches = this.fRefactorInfo.getMatches();
        if (matches == null) {
            return;
        }
        boolean hasHitsInsideComments = this.fRefactorInfo.hasHitsInsideComments();
        for (Map.Entry<IResource, Match[]> entry : matches.entrySet()) {
            List<Match> matchesOutsideComments;
            IResource resource = entry.getKey();
            if (!(resource instanceof IFile)) continue;
            DVTTextFileChange textEdit = this.createTextEdit((IFile)resource, rootChange);
            textChanges.put((IFile)resource, textEdit);
            if (!hasHitsInsideComments) {
                this.createChangesFor((IFile)resource, entry.getValue(), rootChange, textEdit, false);
                continue;
            }
            Map<Boolean, List<Match>> separatedMatches = Stream.of(entry.getValue()).filter(m -> m instanceof BaseFileMatch).collect(Collectors.partitioningBy(m -> ((BaseFileMatch)m).isInsideComment()));
            List<Match> matchesInsideComments = separatedMatches.get(true);
            if (matchesInsideComments != null && !matchesInsideComments.isEmpty()) {
                this.createChangesFor((IFile)resource, matchesInsideComments.toArray(new Match[0]), rootChange, textEdit, true);
            }
            if ((matchesOutsideComments = separatedMatches.get(false)) == null || matchesOutsideComments.isEmpty()) continue;
            this.createChangesFor((IFile)resource, matchesOutsideComments.toArray(new Match[0]), rootChange, textEdit, false);
        }
    }

    protected abstract DVTTextFileChange getTextFileChange(IFile var1);

    public abstract void createChangesFor(IFile var1, Match[] var2, CompositeChange var3, DVTTextFileChange var4, boolean var5);

    public void addEdit(DVTTextFileChange textFileChange, BaseFileMatch fileMatch, String newConnection, String matchString, IRegion track) {
    }
}

