/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.refactor.rename;

import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.util.RfGUIReferencesUtils;
import ro.amiq.dvt.model.reflection.util.RfReferencesUtils;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameAcrossDesignHierarchyPreferencesPage;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameDelegate;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameProcessor;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameRefactorInfo;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameRefactoring;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameWizard;
import ro.amiq.dvt.ui.refactor.rename.RenameAcrossHierarchyInfo;

public class DVTRenamePreferencesPage
extends UserInputWizardPage {
    private DVTRenameRefactorInfo fRenameRefactorInfo;
    private Text fReplaceText;
    private Object FAMILY_RENAME;
    private RenameCheckJob fRenameCheckJob;
    private static final String SWITCH_TO_RENAME_ACROSS_HIERARCHY_BUTTON_TEXT = "Rename across the Design Hierarchy...";
    private String fTextToFillInTextBox;
    private DVTEditor fDvtEditor;

    public DVTRenamePreferencesPage(String name, DVTRenameRefactorInfo refactorInfo, String textToFillInTextBox, DVTEditor dvtEditor) {
        super(name);
        this.fRenameRefactorInfo = refactorInfo;
        this.FAMILY_RENAME = new Object();
        this.fRenameCheckJob = new RenameCheckJob();
        this.fTextToFillInTextBox = textToFillInTextBox;
        this.fDvtEditor = dvtEditor;
    }

    public DVTRenamePreferencesPage(String name, DVTRenameRefactorInfo refactorInfo, DVTEditor dvtEditor) {
        this(name, refactorInfo, null, dvtEditor);
    }

    protected IStatus checkNewName() {
        if (!RfReferencesUtils.isValidIndentifierName(this.fRenameRefactorInfo.getNewName().trim()) && this.fRenameRefactorInfo.getElement().getLanguageKind() == LanguageKind.VLOG) {
            return new Status(2, "ro.amiq.dvt", MessageFormat.format("New name{0} is not a valid identifier, prefix with '\\' to escape it.", ""));
        }
        if (!(this.getRefactoring() instanceof DVTRenameRefactoring)) {
            return new Status(4, "ro.amiq.dvt", "Unexpected error: unknown refactoring");
        }
        if (((DVTRenameRefactoring)this.getRefactoring()).getProcessor().getDelegate() == null) {
            return new Status(4, "ro.amiq.dvt", "Unexpected error: null refactoring delegate");
        }
        return ((DVTRenameRefactoring)this.getRefactoring()).getProcessor().getDelegate().checkNewName();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        Composite mainComposite = new Composite(composite, 0);
        mainComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        mainComposite.setLayout((Layout)new GridLayout(2, false));
        this.fillInRenameStartingPointLabel(mainComposite);
        Label replaceLabel = new Label(mainComposite, 0);
        replaceLabel.setText("New name: ");
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)replaceLabel);
        this.fReplaceText = new Text(mainComposite, 2048);
        this.fReplaceText.setText(this.fTextToFillInTextBox == null ? this.fRenameRefactorInfo.getOldName() : this.fTextToFillInTextBox);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.fReplaceText);
        this.fReplaceText.selectAll();
        this.fReplaceText.setFocus();
        this.fReplaceText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DVTRenamePreferencesPage.this.updateAndValidate();
            }
        });
        this.fillInWithOtherButtons(composite);
        this.setControl((Control)composite);
        this.updateAndValidate();
    }

    public void fillInRenameStartingPointLabel(Composite mainComposite) {
        Label oldNameLabel = new Label(mainComposite, 0);
        GridData oldNameLabelGD = new GridData(4, 128, true, true);
        oldNameLabelGD.horizontalSpan = 2;
        oldNameLabel.setLayoutData((Object)oldNameLabelGD);
        oldNameLabel.setText(this.getRenamedElementSignature());
    }

    protected String getRenamedElementSignature() {
        return "Rename " + this.fRenameRefactorInfo.getRefactorElementLabel();
    }

    private void setError(String error) {
        if (error == null ? this.getErrorMessage() == null : error.equals(this.getErrorMessage())) {
            return;
        }
        this.setErrorMessage(error);
        this.setPageComplete(error == null);
    }

    protected void onQuickNameCheckFail() {
    }

    protected void onJobStart() {
    }

    protected void updateAndValidate() {
        this.fRenameCheckJob.cancel();
        String what = this.fReplaceText.getText();
        this.fRenameRefactorInfo.setNewName(what.trim());
        RenameAcrossHierarchyInfo renameADHInfo = this.fRenameRefactorInfo.getRenameADHInfo();
        if (renameADHInfo != null && renameADHInfo.getDiagramPreview() != null) {
            renameADHInfo.getDiagramPreview().setNewName(what.trim());
        }
        this.setPageComplete(false);
        if (what.trim().length() == 0) {
            this.setError("You must provide a new name.");
            this.onQuickNameCheckFail();
            return;
        }
        if (!this.isRenameAcrossEnabled() && what.trim().equals(this.fRenameRefactorInfo.getOldName())) {
            this.setMessage("New name is the same as old name.", 1);
            this.setPageComplete(false);
            this.onQuickNameCheckFail();
            return;
        }
        this.fRenameCheckJob.schedule(300L);
        this.setError(null);
        this.setMessage(null);
        if (this.fRenameRefactorInfo.hasPotentialMatches()) {
            this.setMessage("Found potential matches. It is mandatory to preview the changes.", 2);
            ((RefactoringWizard)this.getWizard()).setForcePreviewReview(true);
        }
        if (this.fRenameRefactorInfo.hasElaborationMatches()) {
            this.setMessage("Found post-config matches. It is mandatory to preview the changes.", 2);
            ((RefactoringWizard)this.getWizard()).setForcePreviewReview(true);
        }
        if (this.fRenameRefactorInfo.hasHitsInsideMacroCalls()) {
            this.setMessage("Found matches inside macro calls. It is mandatory to preview the changes.", 2);
            ((RefactoringWizard)this.getWizard()).setForcePreviewReview(true);
        }
    }

    public void fillInWithOtherButtons(Composite parentComposite) {
        if (!RfSearchUtils.getPortOrSignalEnum(this.fRenameRefactorInfo.getElement(), this.fRenameRefactorInfo.getProject()).matches()) {
            return;
        }
        if (!RfSearchUtils.hasPortConnections(this.fRenameRefactorInfo.getElement(), this.fRenameRefactorInfo.getProject())) {
            return;
        }
        Link link = new Link(parentComposite, 0);
        link.setText("<a>Rename across the Design Hierarchy...</a>");
        DVTUiUtils.setPlatformLinkColor((Link)link);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DVTRenamePreferencesPage.this.switchToRenameAcrossHierarchy();
            }
        });
    }

    private void switchToRenameAcrossHierarchy() {
        String textBoxContent = this.fReplaceText.getText();
        RfGUIReferencesUtils.closeRenameWizard(this);
        if (!RfGUIReferencesUtils.checkAndCancelActiveRADHSession()) {
            return;
        }
        this.fRenameRefactorInfo.resetMatches();
        this.openRenameAcrossHierarchyWizard(textBoxContent);
    }

    private void openRenameAcrossHierarchyWizard(String newName) {
        List<IRfNamedElement> designInstances = RfGUIReferencesUtils.getDesignInstances(this.getEditor(), this.fRenameRefactorInfo.getScope(), this.fRenameRefactorInfo.getElement());
        DVTRenameRefactorInfo info = this.fRenameRefactorInfo.makeRADHInfo(designInstances);
        info.setNewName(newName);
        DVTRenameDelegate delegate = RfSearchUtils.getRenameAcrossHierarchyDelegate(info);
        if (delegate == null) {
            return;
        }
        DVTRenameProcessor processor = new DVTRenameProcessor(delegate);
        DVTRenameRefactoring refactoring = new DVTRenameRefactoring(processor);
        DVTRenameAcrossDesignHierarchyPreferencesPage preferencesPage = new DVTRenameAcrossDesignHierarchyPreferencesPage("Rename across hierarchy page", info, "");
        DVTRenameWizard wizard = new DVTRenameWizard((Refactoring)refactoring, preferencesPage);
        wizard.setWindowTitle("Rename Port Across the Design Hierarchy");
        RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
        try {
            op.run(this.getShell(), "");
        }
        catch (InterruptedException interruptedException) {}
    }

    public DVTEditor getEditor() {
        return this.fDvtEditor;
    }

    public DVTRenameRefactorInfo getRefactorInfo() {
        return this.fRenameRefactorInfo;
    }

    public boolean isRenameAcrossEnabled() {
        return false;
    }

    class RenameCheckJob
    extends Job {
        public RenameCheckJob() {
            super("RenameCheckJob");
            this.setSystem(true);
        }

        public boolean belongsTo(Object family) {
            return family == DVTRenamePreferencesPage.this.FAMILY_RENAME;
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                DVTRenamePreferencesPage.this.onJobStart();
                AtomicBoolean shouldExit = new AtomicBoolean();
                Display.getDefault().syncExec(() -> {
                    if (DVTRenamePreferencesPage.this.getErrorMessage() != null) {
                        shouldExit.set(true);
                        return;
                    }
                    if (DVTRenamePreferencesPage.this.getMessage() != null && DVTRenamePreferencesPage.this.getMessageType() == 2) {
                        DVTRenamePreferencesPage.this.setPageComplete(true);
                        shouldExit.set(true);
                        return;
                    }
                });
                if (shouldExit.get()) {
                    return Status.OK_STATUS;
                }
                IStatus newNameStatus = DVTRenamePreferencesPage.this.checkNewName();
                Display.getDefault().syncExec(() -> {
                    boolean newNameIsOk = newNameStatus.isOK();
                    if (!newNameIsOk) {
                        DVTRenamePreferencesPage.this.setMessage(String.valueOf(newNameStatus.getMessage()) + " " + "It is mandatory to preview the changes.", 2);
                    }
                    ((RefactoringWizard)DVTRenamePreferencesPage.this.getWizard()).setForcePreviewReview(!newNameIsOk);
                    DVTRenamePreferencesPage.this.setPageComplete(true);
                });
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            return Status.OK_STATUS;
        }
    }
}

