/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.refactor.rename;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import ro.amiq.dvt.ui.refactor.DVTRefactoringProcessor;
import ro.amiq.dvt.ui.refactor.DVTTextFileChange;
import ro.amiq.dvt.ui.refactor.rename.DVTCompositeChange;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameDelegate;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameRefactorInfo;

public class DVTRenameProcessor
extends DVTRefactoringProcessor {
    protected static final String CHANGES_IN_COMMENTS = "Changes in comments";
    protected Map<IFile, DVTTextFileChange> fTextChangesMap;
    protected final DVTRenameRefactorInfo fRenameInfo;
    private final DVTRenameDelegate fDelegate;

    public DVTRenameProcessor(DVTRenameDelegate delegate) {
        this.fDelegate = delegate;
        this.fRenameInfo = delegate.getRefactorInfo();
        this.fTextChangesMap = new HashMap<IFile, DVTTextFileChange>();
    }

    public Object[] getElements() {
        return this.fRenameInfo.getResources();
    }

    public String getIdentifier() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getProcessorName() {
        return "Rename Refactoring";
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) {
        return this.fDelegate.checkInitialConditions(pm);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) {
        return this.fDelegate.checkFinalConditions(pm, context);
    }

    public CompositeChange createChange(IProgressMonitor pm) {
        String rootChangeName = this.getRootChangeName();
        if (this.fRenameInfo.hasPotentialMatches()) {
            rootChangeName = String.valueOf(rootChangeName) + " [Potential Matches Found]";
        }
        DVTCompositeChange baseChange = new DVTCompositeChange(rootChangeName);
        this.fDelegate.createChanges(pm, baseChange, this.fTextChangesMap);
        return baseChange;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) {
        return new RefactoringParticipant[0];
    }

    public DVTRenameDelegate getDelegate() {
        return this.fDelegate;
    }

    private String getRootChangeName() {
        String kindName = this.fRenameInfo.getElement().getKindName();
        if (kindName == null || kindName.isEmpty()) {
            return this.getProcessorName();
        }
        String kindNameCapitalized = String.valueOf(kindName.substring(0, 1).toUpperCase()) + kindName.substring(1).toLowerCase();
        return "Rename " + kindNameCapitalized + " Changes";
    }

    protected CompositeChange createSyntethicRootChange(CompositeChange ... changes) {
        CompositeChange rootChange = new CompositeChange("");
        rootChange.markAsSynthetic();
        CompositeChange[] compositeChangeArray = changes;
        int n = changes.length;
        int n2 = 0;
        while (n2 < n) {
            CompositeChange change = compositeChangeArray[n2];
            if (change != null) {
                rootChange.add((Change)change);
            }
            ++n2;
        }
        return rootChange;
    }
}

