/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.refactor.rename;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.search.ui.text.Match;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.ui.refactor.rename.RenameAcrossHierarchyInfo;
import ro.amiq.dvt.ui.search.BaseFileMatch;

public abstract class DVTRenameRefactorInfo {
    private static final List<String> ELEMENTS_NEED_PARENS = Arrays.asList("function", "task", "procedure");
    private IProject fProject;
    private HashMap<IResource, Match[]> fMatches;
    private String fNewName;
    private boolean fTrackChanges;
    private IResource fResourceSearchScope;

    public DVTRenameRefactorInfo(IProject project) {
        this.fProject = project;
        this.fResourceSearchScope = project;
    }

    public IResource[] getResources() {
        if (this.fMatches == null) {
            return null;
        }
        return this.fMatches.keySet().toArray(new IResource[this.fMatches.keySet().size()]);
    }

    public abstract String getOldName();

    public abstract String getOldSignature();

    public String getRefactorElementLabel() {
        IRfNamedElement element = this.getElement();
        if (element == null) {
            return "";
        }
        return String.valueOf(element.getKindName()) + " " + this.getOldName() + (ELEMENTS_NEED_PARENS.contains(element.getKindName()) ? "()" : "");
    }

    public IProject getProject() {
        return this.fProject;
    }

    public void setMatches(HashMap<IResource, Match[]> matches) {
        this.fMatches = matches;
    }

    public HashMap<IResource, Match[]> getMatches() {
        return this.fMatches;
    }

    public void setNewName(String newName) {
        this.fNewName = newName;
        this.fNewName = this.fNewName.trim();
        if (!this.fNewName.isEmpty() && this.fNewName.charAt(0) == '\\') {
            this.fNewName = String.valueOf(this.fNewName) + " ";
        }
    }

    public String getNewName() {
        return this.fNewName;
    }

    public String getNewName(boolean isEscaped) {
        if (this.fNewName == null) {
            return this.getOldName();
        }
        if (this.fNewName.charAt(0) != '\\') {
            return this.fNewName.trim();
        }
        if (this.fNewName.charAt(0) == '\\' && isEscaped) {
            return this.fNewName.trim();
        }
        if (this.fNewName.charAt(0) == '\\' && !isEscaped) {
            return this.fNewName;
        }
        return this.fNewName;
    }

    public boolean isTrackChanges() {
        return this.fTrackChanges;
    }

    public void setTrackChanges(boolean trackChanges) {
        this.fTrackChanges = trackChanges;
    }

    public abstract boolean hasPotentialMatches();

    public boolean hasElaborationMatches() {
        HashMap<IResource, Match[]> matches = this.getMatches();
        if (matches == null) {
            return false;
        }
        Iterator<Match[]> iterator = matches.values().iterator();
        while (iterator.hasNext()) {
            Match[] fileMatches;
            Match[] matchArray = fileMatches = iterator.next();
            int n = fileMatches.length;
            int n2 = 0;
            while (n2 < n) {
                Match match = matchArray[n2];
                if (match instanceof BaseFileMatch && ((BaseFileMatch)match).isElaborationHit()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean hasHitsInsideMacroCalls() {
        HashMap<IResource, Match[]> allMatches = this.getMatches();
        if (allMatches == null) {
            return false;
        }
        for (Match[] fileMatches : allMatches.values()) {
            if (fileMatches == null || fileMatches.length == 0) continue;
            Match[] matchArray = fileMatches;
            int n = fileMatches.length;
            int n2 = 0;
            while (n2 < n) {
                Match match = matchArray[n2];
                if (match instanceof BaseFileMatch && ((BaseFileMatch)match).isInsideMacroCall()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean hasHitsInsideComments() {
        HashMap<IResource, Match[]> allMatches = this.getMatches();
        if (allMatches == null || allMatches.isEmpty()) {
            return false;
        }
        return allMatches.values().stream().filter(m -> m != null && ((Match[])m).length > 0).anyMatch(matches -> Stream.of(matches).filter(m -> m instanceof BaseFileMatch).anyMatch(m -> ((BaseFileMatch)m).isInsideComment()));
    }

    public abstract IRfScopeElement getScope();

    public abstract IRfNamedElement getElement();

    public IResource getResourceSearchScope() {
        return this.fResourceSearchScope;
    }

    public void setResourceSearchScope(IResource resourceSearchScope) {
        this.fResourceSearchScope = resourceSearchScope;
    }

    public void resetMatches() {
        this.fMatches = null;
    }

    public boolean shouldGrayOutRenameInParentInstancesButton() {
        return false;
    }

    public RenameAcrossHierarchyInfo getRenameADHInfo() {
        return null;
    }

    public void setRenameADHInfo(RenameAcrossHierarchyInfo renameADHinfo) {
    }

    public void setUserInput(int renameDepth, boolean matchingNames, boolean renameInParentInstances, boolean renameInSubInstances) {
    }

    public DVTRenameRefactorInfo makeRADHInfo(List<IRfNamedElement> designInstances) {
        return null;
    }

    public boolean validate() {
        return true;
    }
}

