/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.refactor.rename;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.ui.refactor.rename.PreviewDiagramInstanceInfo;
import ro.amiq.dvt.ui.refactor.rename.RenameConflictType;
import ro.amiq.dvt.ui.search.PortSignalEnum;

public class PreviewDiagramInfo {
    private String fNewName;
    private Map<IRfNamedElement, PreviewDiagramInstanceInfo> fPreviewDiagramInstanceInfos;
    private int fRenameDepth;
    private boolean fMatchingNames;
    private boolean fRenameInParentInstances;
    private boolean fRenameInSubInstances;
    private List<IRfNamedElement> fInitialDesignInstance;
    private IRfNamedElement fStartingElement;

    public PreviewDiagramInfo(String newName, int renameDepth, boolean matchingNames, boolean renameInParentInstances, boolean renameInSubInstances, List<IRfNamedElement> designInstances, IRfNamedElement startingElement) {
        this.fNewName = newName;
        this.fPreviewDiagramInstanceInfos = new HashMap<IRfNamedElement, PreviewDiagramInstanceInfo>();
        this.fRenameDepth = renameDepth;
        this.fMatchingNames = matchingNames;
        this.fRenameInParentInstances = renameInParentInstances;
        this.fRenameInSubInstances = renameInSubInstances;
        this.fInitialDesignInstance = designInstances;
        this.fStartingElement = startingElement;
    }

    public void addPreViewDiagramInstanceInfo(IRfNamedElement instance, IRfNamedElement modifiedField, boolean isDummyField, boolean shouldBeRenamed, boolean isSideEffect, RenameConflictType conflictType, boolean isInitialElement, HidOperator portConnection) {
        IRfNamedElement firstDesignInstance;
        if (instance == null) {
            return;
        }
        if (instance instanceof IRfDesignElement && modifiedField != null && RfSearchUtils.getPortOrSignalEnum(modifiedField, modifiedField.getRfProject().getProject()) == PortSignalEnum.PORT_MATCH && ((firstDesignInstance = this.fInitialDesignInstance.get(0)) instanceof IRfDesignElement && firstDesignInstance instanceof IRfBlockElement && ((IRfDesignElement)firstDesignInstance).getKind() == IRfNamedElement.ElementKind.VHDL_ARCHITECTURE ? !instance.equals(((IRfBlockElement)firstDesignInstance).getEntity()) : !instance.equals(firstDesignInstance))) {
            return;
        }
        PreviewDiagramInstanceInfo previewInfo = this.fPreviewDiagramInstanceInfos.get(instance);
        if (previewInfo == null || !this.isConflict(previewInfo.getRenameConflict()) && this.isConflict(conflictType)) {
            previewInfo = new PreviewDiagramInstanceInfo(instance, shouldBeRenamed, conflictType, isInitialElement);
            if (modifiedField != null) {
                previewInfo.addPort(modifiedField, isDummyField);
            }
            if (portConnection != null) {
                previewInfo.addPortConnections(portConnection);
            }
            if (isSideEffect) {
                previewInfo.setSideEffect();
            }
            this.fPreviewDiagramInstanceInfos.put(instance, previewInfo);
        } else {
            if (modifiedField != null) {
                previewInfo.addPort(modifiedField, isDummyField);
            }
            if (portConnection != null) {
                previewInfo.addPortConnections(portConnection);
            }
            if (shouldBeRenamed) {
                previewInfo.setShouldBeRenamed(true);
            }
            if (isSideEffect) {
                previewInfo.setSideEffect();
                previewInfo.setShouldBeRenamed(shouldBeRenamed);
            }
        }
    }

    public String getNewName() {
        if (this.fNewName != null) {
            return this.fNewName;
        }
        return "";
    }

    public void setNewName(String newName) {
        this.fNewName = newName;
    }

    public Map<IRfNamedElement, PreviewDiagramInstanceInfo> getPreviewDiagramInstanceInfos() {
        return this.fPreviewDiagramInstanceInfos;
    }

    public int getRenameDepth() {
        return this.fRenameDepth;
    }

    public boolean getMatchingNames() {
        return this.fMatchingNames;
    }

    public boolean isRenameInParentInstances() {
        return this.fRenameInParentInstances;
    }

    public boolean isRenameInSubInstances() {
        return this.fRenameInSubInstances;
    }

    public List<IRfNamedElement> getInitialDesignInstance() {
        return this.fInitialDesignInstance;
    }

    public IRfNamedElement getRenamedPortOrSignal() {
        return this.fStartingElement;
    }

    private boolean isConflict(RenameConflictType conflictType) {
        return conflictType == RenameConflictType.AMBIGUITY_CONFLICT || conflictType == RenameConflictType.DUPLICATE_CONFLICT;
    }

    public void updateUserInput(int renameDepth, boolean matchingNames, boolean renameInParentInstances, boolean renameInSubInstances) {
        this.fRenameDepth = renameDepth;
        this.fMatchingNames = matchingNames;
        this.fRenameInParentInstances = renameInParentInstances;
        this.fRenameInSubInstances = renameInSubInstances;
    }
}

