/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.refactor.rename;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.ui.refactor.rename.RenameConflictType;

public class PreviewDiagramInstanceInfo {
    private IRfNamedElement fInstanceOrModule;
    private Map<IRfNamedElement, Boolean> fModifiedInstancePort;
    private List<IRfNamedElement> fInstancePath;
    private Set<HidOperator> fPortConnections;
    private boolean fShouldBeRenamed;
    private boolean fIsSideEffect;
    private RenameConflictType fRenameConflict;
    private boolean fInitialElement;

    public PreviewDiagramInstanceInfo(IRfNamedElement instanceOrModule, boolean shouldBeRenamed, RenameConflictType renameConflict, boolean initialElement) {
        this.fInstanceOrModule = instanceOrModule;
        this.fShouldBeRenamed = shouldBeRenamed;
        this.fRenameConflict = renameConflict;
        this.fInitialElement = initialElement;
        this.fModifiedInstancePort = new HashMap<IRfNamedElement, Boolean>();
        this.fPortConnections = new HashSet<HidOperator>();
        this.fInstancePath = null;
    }

    public PreviewDiagramInstanceInfo(PreviewDiagramInstanceInfo previewInfo, List<IRfNamedElement> instancePath, boolean isSideEffect) {
        this.fInstanceOrModule = instancePath.get(instancePath.size() - 1);
        this.fShouldBeRenamed = previewInfo.fShouldBeRenamed;
        this.fRenameConflict = previewInfo.fRenameConflict;
        this.fModifiedInstancePort = new HashMap<IRfNamedElement, Boolean>(previewInfo.getModifiedInstancePorts());
        this.fPortConnections = new HashSet<HidOperator>(previewInfo.getPortConnections());
        this.fInstancePath = instancePath;
        this.fIsSideEffect = isSideEffect;
        this.fInitialElement = false;
    }

    public void addPort(IRfNamedElement port, boolean isDummy) {
        Boolean exisitingDummyAttribute = this.fModifiedInstancePort.get(port);
        if (exisitingDummyAttribute == null || !isDummy) {
            this.fModifiedInstancePort.put(port, isDummy);
        }
    }

    public void addPortConnections(HidOperator operator) {
        this.fPortConnections.add(operator);
    }

    public IRfNamedElement getInstanceOrModule() {
        return this.fInstanceOrModule;
    }

    public boolean shouldBeRenamed() {
        return this.fShouldBeRenamed;
    }

    public void setShouldBeRenamed(boolean shouldBeRenamed) {
        this.fShouldBeRenamed = shouldBeRenamed;
    }

    public Map<IRfNamedElement, Boolean> getModifiedInstancePorts() {
        return this.fModifiedInstancePort;
    }

    public void setSideEffect() {
        this.fIsSideEffect = true;
    }

    public boolean isSideEffect() {
        return this.fIsSideEffect;
    }

    public RenameConflictType getRenameConflict() {
        return this.fRenameConflict;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fInstanceOrModule == null ? 0 : this.fInstanceOrModule.hashCode());
        result = 31 * result + (this.fModifiedInstancePort == null ? 0 : this.fModifiedInstancePort.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PreviewDiagramInstanceInfo other = (PreviewDiagramInstanceInfo)obj;
        if (this.fInstanceOrModule == null ? other.fInstanceOrModule != null : !this.fInstanceOrModule.equals(other.fInstanceOrModule)) {
            return false;
        }
        return !(this.fModifiedInstancePort == null ? other.fModifiedInstancePort != null : !this.fModifiedInstancePort.equals(other.fModifiedInstancePort));
    }

    public boolean isInitialElement() {
        return this.fInitialElement;
    }

    public void setInitialElement() {
        this.fInitialElement = true;
    }

    public List<HidOperator> getPortConnections() {
        return new ArrayList<HidOperator>(this.fPortConnections);
    }

    public List<IRfNamedElement> getInstancePath() {
        return this.fInstancePath;
    }

    public void setInstancePath(List<IRfNamedElement> instancePath) {
        this.fInstancePath = instancePath;
    }
}

