/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.refactor.rename;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.ui.refactor.rename.PreviewDiagramInfo;
import ro.amiq.dvt.ui.refactor.rename.RenameConflictType;

public class RenameAcrossHierarchyInfo {
    private int fRenameDepth;
    private boolean fMatchingNames;
    private boolean fRenameInParentInstances;
    private boolean fRenameInSubInstances;
    private IRfNamedElement fStartingElement;
    private List<IRfNamedElement> fDesignInstances;
    private Map<IRfScopeElement, Set<IRfNamedElement>> fAmbiguityCases = new HashMap<IRfScopeElement, Set<IRfNamedElement>>();
    private Map<IRfNamedElement, List<IRfFieldElement>> fConflictingMessages = new HashMap<IRfNamedElement, List<IRfFieldElement>>();
    private PreviewDiagramInfo fDiagramPreview;

    public RenameAcrossHierarchyInfo(int renameDepth, boolean matchingNames, boolean renameInParentInstances, boolean renameInSubInstances, List<IRfNamedElement> designInstances, String newName, IRfNamedElement startingElement) {
        this.fRenameDepth = renameDepth;
        this.fMatchingNames = matchingNames;
        this.fRenameInParentInstances = renameInParentInstances;
        this.fRenameInSubInstances = renameInSubInstances;
        this.fDesignInstances = designInstances;
        this.fStartingElement = startingElement;
        this.fDiagramPreview = new PreviewDiagramInfo(newName, this.fRenameDepth, this.fMatchingNames, this.fRenameInParentInstances, this.fRenameInSubInstances, this.fDesignInstances, startingElement);
    }

    public RenameAcrossHierarchyInfo(List<IRfNamedElement> designInstances, String newName, IRfNamedElement startingElement) {
        this(0, false, true, true, designInstances, newName, startingElement);
    }

    public void setUserInput(int renameDepth, boolean matchingNames, boolean renameInParentInstances, boolean renameInSubInstances) {
        this.fRenameDepth = renameDepth;
        this.fMatchingNames = matchingNames;
        this.fRenameInParentInstances = renameInParentInstances;
        this.fRenameInSubInstances = renameInSubInstances;
        this.fDiagramPreview.updateUserInput(renameDepth, matchingNames, renameInParentInstances, renameInSubInstances);
    }

    public int getRenameDepth() {
        return this.fRenameDepth;
    }

    public boolean isMatchingNames() {
        return this.fMatchingNames;
    }

    public boolean renameInParentInstaces() {
        return this.fRenameInParentInstances;
    }

    public boolean renameInSubInstances() {
        return this.fRenameInSubInstances;
    }

    public List<IRfNamedElement> getDesignInstances() {
        return this.fDesignInstances;
    }

    public void addAmbiguityCases(IRfScopeElement scope, IRfNamedElement element) {
        Set<IRfNamedElement> ambiguityPerScope = this.fAmbiguityCases.get(scope);
        if (ambiguityPerScope == null) {
            ambiguityPerScope = new HashSet<IRfNamedElement>();
            this.fAmbiguityCases.put(scope, ambiguityPerScope);
        }
        ambiguityPerScope.add(element);
    }

    public void addConflictingCases(IRfNamedElement namedElement, List<IRfFieldElement> conflictingElements) {
        this.fConflictingMessages.put(namedElement, conflictingElements);
    }

    public Map<IRfNamedElement, List<IRfFieldElement>> getConflictingMessages() {
        return this.fConflictingMessages;
    }

    public Map<IRfScopeElement, Set<IRfNamedElement>> getAmbiguityCases() {
        return this.fAmbiguityCases;
    }

    public void addPreViewDiagramInstanceInfo(IRfNamedElement instance, IRfNamedElement modifiedInstancePort, boolean shoudlBeRenamed, RenameConflictType renameConflict, boolean isInitialElement, HidOperator portConnection) {
        this.fDiagramPreview.addPreViewDiagramInstanceInfo(instance, modifiedInstancePort, false, shoudlBeRenamed, false, renameConflict, isInitialElement, portConnection);
    }

    public void addPreViewDiagramInstanceInfo(IRfNamedElement instance, IRfNamedElement modifiedInstancePort, boolean isDummyField, boolean shoudlBeRenamed, RenameConflictType renameConflict, boolean isInitialElement, HidOperator portConnection) {
        this.fDiagramPreview.addPreViewDiagramInstanceInfo(instance, modifiedInstancePort, isDummyField, shoudlBeRenamed, false, renameConflict, isInitialElement, portConnection);
    }

    public PreviewDiagramInfo getDiagramPreview() {
        return this.fDiagramPreview;
    }

    public IRfNamedElement getStartingElement() {
        return this.fStartingElement;
    }

    public void clearConflictingAndDiagramInfo() {
        this.fAmbiguityCases.clear();
        this.fConflictingMessages.clear();
        this.fDiagramPreview.getPreviewDiagramInstanceInfos().clear();
    }
}

