/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.refactor.replace;

import java.util.List;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import ro.amiq.dvt.ui.refactor.replace.params.ProjectChangesRaw;
import ro.amiq.dvt.ui.refactor.replace.params.ReplaceChangeRaw;
import ro.amiq.dvt.ui.refactor.replace.params.SingleFileChangesRaw;
import ro.amiq.dvt.utils.DVTFileUtils;

public class DVTReplaceRefactoring
extends Refactoring {
    private static final String PROJECT_NOT_FOUND_ERROR = "Project %s not found or not opened";
    private static final String FILE_NOT_FOUND_ERROR = "File %s within project %s was not found while trying to apply the changes";
    private static final String INVALID_LINE_NUMBER = "File %s doesn't contain line %d";
    private static final String REPLACE_REFACTORING_CHANGE_FILE = "Changes for file %s";
    private final ProjectChangesRaw rawChanges;
    private final String name;
    private final String rootChangeName;

    public DVTReplaceRefactoring(ProjectChangesRaw rawChanges, String name, String rootChangeName) {
        this.rawChanges = rawChanges;
        this.name = name;
        this.rootChangeName = rootChangeName;
    }

    public String getName() {
        return this.name;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        IProject project = this.rawChanges.getProject();
        if (project == null) {
            return RefactoringStatus.createFatalErrorStatus((String)PROJECT_NOT_FOUND_ERROR);
        }
        if (!project.exists() || !project.isOpen()) {
            return RefactoringStatus.createFatalErrorStatus((String)String.format(PROJECT_NOT_FOUND_ERROR, project.getName()));
        }
        for (SingleFileChangesRaw fileChangesRaw : this.rawChanges.getProjectChanges()) {
            IFile file = this.getFile(project, fileChangesRaw);
            if (file.exists()) continue;
            return RefactoringStatus.createFatalErrorStatus((String)String.format(FILE_NOT_FOUND_ERROR, file.getName(), project.getName()));
        }
        return new RefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        IProject project = this.rawChanges.getProject();
        CompositeChange rootChange = new CompositeChange(this.rootChangeName);
        for (SingleFileChangesRaw fileChangesRaw : this.rawChanges.getProjectChanges()) {
            IFile file = this.getFile(project, fileChangesRaw);
            Change fileChanges = this.createFileChanges(file, fileChangesRaw.getFileChanges());
            rootChange.add(fileChanges);
        }
        return rootChange;
    }

    private Change createFileChanges(IFile file, List<ReplaceChangeRaw> fileChanges) throws CoreException {
        CompositeChange fileChangesRoot = new CompositeChange(String.format(REPLACE_REFACTORING_CHANGE_FILE, file.getName()));
        TextFileChange change = new TextFileChange(String.format(REPLACE_REFACTORING_CHANGE_FILE, file.getName()), file);
        change.setEdit((TextEdit)new MultiTextEdit());
        boolean shouldDisconnectFileBufferManager = false;
        ITextFileBufferManager textFileBufferManager = FileBuffers.getTextFileBufferManager();
        try {
            ITextFileBuffer textFileBuffer = textFileBufferManager.getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
            if (textFileBuffer == null) {
                textFileBufferManager.connect(file.getFullPath(), LocationKind.IFILE, null);
                textFileBuffer = textFileBufferManager.getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
                shouldDisconnectFileBufferManager = true;
            }
            IDocument document = textFileBuffer.getDocument();
            for (ReplaceChangeRaw fileChange : fileChanges) {
                ReplaceEdit edit = this.createReplaceEdit(document, file.getName(), fileChange);
                change.addEdit((TextEdit)edit);
            }
            fileChangesRoot.add((Change)change);
            CompositeChange compositeChange = fileChangesRoot;
            return compositeChange;
        }
        finally {
            if (shouldDisconnectFileBufferManager && textFileBufferManager != null) {
                textFileBufferManager.disconnect(file.getFullPath(), LocationKind.IFILE, null);
            }
        }
    }

    private ReplaceEdit createReplaceEdit(IDocument document, String filename, ReplaceChangeRaw fileChange) throws CoreException {
        try {
            int startLineOffset = document.getLineOffset(fileChange.getStartLine() - 1);
            String lineDelimiter = document.getLineDelimiter(fileChange.getEndLine() - 1);
            int endLineDelimiterLength = lineDelimiter != null ? lineDelimiter.length() : 0;
            int endLineOffset = document.getLineOffset(fileChange.getEndLine() - 1) + document.getLineLength(fileChange.getEndLine() - 1) - endLineDelimiterLength;
            return new ReplaceEdit(startLineOffset, endLineOffset - startLineOffset, fileChange.getNewText());
        }
        catch (BadLocationException badLocationException) {
            throw new CoreException((IStatus)new Status(4, "ro.amiq.dvt", String.format(INVALID_LINE_NUMBER, filename, fileChange.getEndLine())));
        }
    }

    public IFile getFile(IProject project, SingleFileChangesRaw fileChanges) {
        Path filePath = new Path(fileChanges.getFilePath());
        Object absolutePath = filePath.isAbsolute() ? filePath : project.getLocation().append((IPath)filePath);
        return DVTFileUtils.getInstance().getWorkspaceFiles(project, absolutePath.toOSString())[0];
    }
}

