/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.refactor.utils;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.concurrent.Callable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.resource.RenameResourceChange;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.part.PageBook;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.refactor.DVTRefactoringProcessor;
import ro.amiq.dvt.ui.refactor.utils.ChangeVisitor;
import ro.amiq.dvt.utils.DVTFileUtils;

public abstract class DVTRefactoringWizard
extends RefactoringWizard {
    private boolean performFinishCalled;

    public DVTRefactoringWizard(Refactoring refactoring, int flags) {
        super(refactoring, flags);
        RefactoringProcessor processor;
        if (refactoring instanceof ProcessorBasedRefactoring && (processor = ((ProcessorBasedRefactoring)refactoring).getProcessor()) instanceof DVTRefactoringProcessor) {
            ((DVTRefactoringProcessor)processor).setWizard(this);
        }
    }

    public IWizardPage getStartingPage() {
        Control control;
        IWizardPage page = super.getStartingPage();
        if (page instanceof RefactoringWizardPage && (control = ((RefactoringWizardPage)page).getControl()) != null && control instanceof PageBook) {
            PageBook pageBook = (PageBook)control;
            Control[] controlArray = pageBook.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Label label;
                String originalString;
                Control child = controlArray[n2];
                if (child != null && child instanceof Composite && ((Composite)child).getChildren() != null && ((Composite)child).getChildren().length == 1 && ((Composite)child).getChildren()[0] instanceof Label && (originalString = (label = (Label)((Composite)child).getChildren()[0]).getText()).startsWith("The refactoring does not change any source code")) {
                    label.setText(String.valueOf(originalString) + "\n\nNOTE: This might be due to incorrectly specified refactoring items," + "\n or due to an out-of-date database (rebuild to update).");
                }
                ++n2;
            }
        }
        return page;
    }

    public void validateEdit(IProgressMonitor monitor, final IFile[] filesAboutToChange) {
        DVTFileUtils.getInstance().fixFileModificationValidatorPermissions((IResource[])filesAboutToChange, new Callable<IStatus>(){

            @Override
            public IStatus call() {
                return ResourcesPlugin.getWorkspace().validateEdit(filesAboutToChange, (Object)DVTRefactoringWizard.this.getShell());
            }
        }, false, monitor);
    }

    public boolean performFinish(final boolean includeRenameChanges) {
        this.performFinishCalled = true;
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    final HashSet filesAboutToChange = new HashSet();
                    ChangeVisitor.accept(DVTRefactoringWizard.this.getChange(), new ChangeVisitor(){

                        @Override
                        public boolean visit(Change c) {
                            if (c != null && c.getModifiedElement() instanceof IFile && c.isEnabled()) {
                                if (c instanceof RenameResourceChange && !includeRenameChanges) {
                                    return true;
                                }
                                filesAboutToChange.add((IFile)c.getModifiedElement());
                            }
                            return true;
                        }
                    });
                    IFile[] filesAboutToChangeArray = filesAboutToChange.toArray(new IFile[filesAboutToChange.size()]);
                    DVTRefactoringWizard.this.validateEdit(monitor, filesAboutToChangeArray);
                }
            });
        }
        catch (InvocationTargetException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        catch (InterruptedException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return super.performFinish();
    }

    public boolean performFinish() {
        return this.performFinish(true);
    }

    public boolean isPerformFinishCalled() {
        return this.performFinishCalled;
    }
}

