/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.reportissue;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.text.StringCharacterIterator;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import ro.amiq.dvt.builders.DVTBuildConsole;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.reportissue.DVTHeapHistogramCollectorDelegate;
import ro.amiq.dvt.ui.reportissue.DVTThreadDumpCollectorUIDelegate;
import ro.amiq.dvt.utils.Utils;

public class DVTHeapHistogramCollector {
    private static final String DIAGNOSTICS_CMD_MBEAN_NAME = "com.sun.management:type=DiagnosticCommand";
    private static final String MEMORY_HISTOGRAM_CMD = "gcClassHistogram";
    private static final String TIME_PATTERN = "u-MM-dd_HH-mm-ss.SSS";
    public static final String FILE_PREFIX = "dvt_heap_histo_";
    public static final String LOG_EXTENSION = ".log";
    public static final String ARCHIVE_EXTENSION = ".zip";
    public static final String BASE_SAVE_LOCATION = "/.dvt/.profiling/";
    public static final String HEAP_HISTOGRAMS_COLLECTED_MESSAGE_FORMAT = "{0}Histograms collected in file: {1}";
    private boolean wasAutomaticallyStarted;
    private static final DVTHeapHistogramCollector INSTANCE = new DVTHeapHistogramCollector();
    private int histogramId;
    private String fileOrArchiveName;
    private String fileOrArchivePath;
    private ZipOutputStream zipOutStream;
    private AtomicBoolean isSessionInProgress = new AtomicBoolean(false);
    private static MBeanServer platformBeanServer;
    private static ScheduledThreadPoolExecutor executor;

    static {
        Runtime.getRuntime().addShutdownHook(DVTHeapHistogramCollector.getInstance().new StopHook());
        platformBeanServer = ManagementFactory.getPlatformMBeanServer();
        executor = new ScheduledThreadPoolExecutor(1);
    }

    private static String formatSize(long size) {
        long nexp;
        long sizeAbs = Math.abs(size);
        if (sizeAbs < 1000L) {
            return String.valueOf(size) + "B";
        }
        StringCharacterIterator ci = new StringCharacterIterator("KMGTPE");
        long exp = 1000L;
        while (sizeAbs >= (nexp = exp * 1000L)) {
            exp = nexp;
            ci.next();
        }
        return String.format("%.3f%cB", (double)size / (double)exp, Character.valueOf(ci.current()));
    }

    private static long getTotalMemoryFromHistogram(String histogram) {
        try {
            return Long.parseLong(histogram.substring(histogram.length() - 16, histogram.length() - 1).replace(" ", ""));
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    private static String getUniqueArchiveName() {
        return FILE_PREFIX + Instant.now().atZone(ZoneId.systemDefault()).format(DateTimeFormatter.ofPattern(TIME_PATTERN)) + ARCHIVE_EXTENSION;
    }

    private static String getArchivedLogName(int prefixNumber, String content, long size) {
        if (!content.isEmpty()) {
            return String.valueOf(prefixNumber) + "_" + content + "_" + DVTHeapHistogramCollector.formatSize(size) + LOG_EXTENSION;
        }
        return String.valueOf(prefixNumber) + "_" + DVTHeapHistogramCollector.formatSize(size) + LOG_EXTENSION;
    }

    public static String getSaveToLocation(String dirInBaseLocation) {
        IProject currentProject;
        String projectLocation = ".";
        IPath workspaceLocation = Utils.getWorkspaceLocation();
        if (workspaceLocation != null) {
            projectLocation = workspaceLocation.toOSString();
        }
        if ((currentProject = DVTThreadDumpCollectorUIDelegate.getCurrentProject()) != null) {
            projectLocation = currentProject.getLocation().toOSString();
        }
        StringBuilder saveLocation = new StringBuilder();
        saveLocation.append(projectLocation).append(BASE_SAVE_LOCATION).append(dirInBaseLocation);
        File saveToLocationFile = new File(saveLocation.toString());
        if (!saveToLocationFile.exists()) {
            saveToLocationFile.mkdirs();
        }
        return saveLocation.toString();
    }

    public static void updateStatusBar(String fileName) {
        DVTHeapHistogramCollectorDelegate.updateStatusBar(MessageFormat.format(HEAP_HISTOGRAMS_COLLECTED_MESSAGE_FORMAT, "DVT Heap Histogram Collector: ", fileName));
    }

    public static DVTHeapHistogramCollector getInstance() {
        return INSTANCE;
    }

    private DVTHeapHistogramCollector() {
    }

    public boolean startSession(String dirInBaseSaveLocation, boolean wasAutomaticallyStarted) {
        if (!this.isSessionInProgress.compareAndSet(false, true)) {
            return false;
        }
        executor.schedule(() -> {
            try {
                this.wasAutomaticallyStarted = wasAutomaticallyStarted;
                this.histogramId = 1;
                this.fileOrArchiveName = DVTHeapHistogramCollector.getUniqueArchiveName();
                this.fileOrArchivePath = String.valueOf(DVTHeapHistogramCollector.getSaveToLocation(dirInBaseSaveLocation)) + File.separator + this.fileOrArchiveName;
                this.zipOutStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(this.fileOrArchivePath)));
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                this.zipOutStream = null;
                return;
            }
        }, 0L, TimeUnit.MILLISECONDS);
        return true;
    }

    public boolean isSessionInProgress() {
        return this.isSessionInProgress.get();
    }

    public boolean collectHistogram() {
        return this.collectHistogram("");
    }

    public boolean collectHistogram(String archivedLogNamePrefix) {
        if (!this.isSessionInProgress.get()) {
            return false;
        }
        ScheduledFuture<?> future = executor.schedule(() -> {
            String histogram = null;
            try {
                histogram = (String)platformBeanServer.invoke(new ObjectName(DIAGNOSTICS_CMD_MBEAN_NAME), MEMORY_HISTOGRAM_CMD, new Object[1], new String[]{"[Ljava.lang.String;"});
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return;
            }
            if (histogram == null) {
                return;
            }
            if (this.zipOutStream != null) {
                try {
                    this.zipOutStream.putNextEntry(new ZipEntry(DVTHeapHistogramCollector.getArchivedLogName(this.histogramId, archivedLogNamePrefix, DVTHeapHistogramCollector.getTotalMemoryFromHistogram(histogram))));
                    this.zipOutStream.write(histogram.getBytes(StandardCharsets.UTF_8));
                    this.zipOutStream.closeEntry();
                    this.zipOutStream.flush();
                    ++this.histogramId;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return;
                }
            }
        }, 0L, TimeUnit.MILLISECONDS);
        if (this.wasAutomaticallyStarted) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return false;
            }
        }
        return true;
    }

    public void endSession() {
        if (!this.isSessionInProgress.compareAndSet(true, false)) {
            return;
        }
        executor.schedule(() -> {
            if (this.zipOutStream == null) {
                return;
            }
            if (this.wasAutomaticallyStarted) {
                this.logHeapHistogramFileLocation();
            } else {
                DVTHeapHistogramCollector.updateStatusBar(this.fileOrArchiveName);
            }
            try {
                this.zipOutStream.closeEntry();
                this.zipOutStream.close();
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            this.zipOutStream = null;
            this.fileOrArchiveName = null;
            this.fileOrArchivePath = null;
        }, 0L, TimeUnit.MILLISECONDS);
    }

    public void logHeapHistogramFileLocation() {
        String projectName = "";
        IProject currentProject = DVTThreadDumpCollectorUIDelegate.getCurrentProject();
        if (currentProject != null) {
            projectName = currentProject.getName();
        }
        if (this.fileOrArchivePath == null) {
            return;
        }
        File file = new File(this.fileOrArchivePath);
        if (file.exists()) {
            DVTBuildConsole buildConsole = DVTBuildConsoleRegistry.getConsole(Utils.getProject(projectName));
            if (buildConsole == null) {
                return;
            }
            buildConsole.print(MessageFormat.format(HEAP_HISTOGRAMS_COLLECTED_MESSAGE_FORMAT, System.lineSeparator(), this.fileOrArchivePath));
        }
    }

    public class StopHook
    extends Thread {
        @Override
        public void run() {
            if (DVTHeapHistogramCollector.this.zipOutStream != null) {
                try {
                    DVTHeapHistogramCollector.this.zipOutStream.closeEntry();
                    DVTHeapHistogramCollector.this.zipOutStream.close();
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        }
    }
}

