/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.reportissue;

import java.time.LocalDateTime;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.reportissue.DVTIncrementalStatsModel;
import ro.amiq.dvt.ui.reportissue.IncrementalBuildThreadDumpHandler;

enum DVTIncrementalStatsJsonHelper {
    INSTANCE;

    private final String TIMESTAMP_LABEL = "timestamp";
    private final String DURATION_LABEL = "durationMs";
    private final String CHANGED_FILES_LABEL = "changedFiles";
    private final String DELTA_FILES_LABEL = "otherDeltaFiles";
    private final int INDENT_FACTOR = 4;

    String toJson(Set<DVTIncrementalStatsModel> statsSet) {
        if (statsSet == null) {
            return null;
        }
        try {
            JSONArray jsonArray = new JSONArray();
            for (DVTIncrementalStatsModel model : statsSet) {
                String jsonObj = this.toJson(model);
                if (jsonObj == null) continue;
                jsonArray.put(new JSONObject(jsonObj));
            }
            return jsonArray.toString(4);
        }
        catch (JSONException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    private String toJson(DVTIncrementalStatsModel statsModel) {
        if (statsModel == null) {
            return null;
        }
        try {
            JSONObject json = new JSONObject();
            json.put("timestamp", statsModel.getTimestamp().format(IncrementalBuildThreadDumpHandler.DATE_TIME_FORMATTER));
            json.put("durationMs", statsModel.getDurationMs());
            json.put("changedFiles", new JSONArray(statsModel.getChangedFiles()));
            if (!statsModel.getOtherDeltaFiles().isEmpty()) {
                json.put("otherDeltaFiles", new JSONArray(statsModel.getOtherDeltaFiles()));
            }
            return json.toString(4);
        }
        catch (JSONException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    Set<DVTIncrementalStatsModel> toStatsSet(String json) {
        LinkedHashSet<DVTIncrementalStatsModel> statsSet = new LinkedHashSet<DVTIncrementalStatsModel>();
        if (json == null) {
            return statsSet;
        }
        try {
            JSONArray jsonArray = new JSONArray(json);
            int i = 0;
            while (i < jsonArray.length()) {
                DVTIncrementalStatsModel statsObject = this.toStatsObject(jsonArray.getJSONObject(i).toString());
                if (statsObject != null) {
                    statsSet.add(statsObject);
                }
                ++i;
            }
            return statsSet;
        }
        catch (JSONException jSONException) {
            return statsSet;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return statsSet;
        }
    }

    private DVTIncrementalStatsModel toStatsObject(String json) {
        if (json == null) {
            return null;
        }
        try {
            Set<String> otherDeltaFiles;
            JSONObject jsonObject = new JSONObject(json);
            LocalDateTime timestamp = LocalDateTime.parse(jsonObject.getString("timestamp"), IncrementalBuildThreadDumpHandler.DATE_TIME_FORMATTER);
            long duration = jsonObject.getLong("durationMs");
            LinkedHashSet<String> changedFiles = this.jsonArrayToSet(jsonObject.getJSONArray("changedFiles"));
            try {
                otherDeltaFiles = this.jsonArrayToSet(jsonObject.getJSONArray("otherDeltaFiles"));
            }
            catch (JSONException jSONException) {
                otherDeltaFiles = Collections.emptySet();
            }
            return new DVTIncrementalStatsModel(timestamp, changedFiles, otherDeltaFiles, duration);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    private LinkedHashSet<String> jsonArrayToSet(JSONArray jsonArray) {
        if (jsonArray == null) {
            return null;
        }
        try {
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            int i = 0;
            while (i < jsonArray.length()) {
                set.add(jsonArray.getString(i));
                ++i;
            }
            return set;
        }
        catch (JSONException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }
}

