/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.reportissue;

import java.time.LocalDateTime;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ro.amiq.dvt.model.reflection.DeltaFileKind;
import ro.amiq.dvt.model.reflection.DeltaFileWrapper;
import ro.amiq.dvt.model.reflection.ParserPath;

class DVTIncrementalStatsModel {
    private static final String BUILD_CONFIG_LABEL = "Build Config";
    private LocalDateTime timestamp;
    private Set<String> changedFiles;
    private Set<String> otherDeltaFiles;
    private long durationMs;

    protected DVTIncrementalStatsModel(LocalDateTime timestamp, Set<DeltaFileWrapper> incrementalDeltaFiles, long durationMs) {
        this(incrementalDeltaFiles);
        this.timestamp = timestamp;
        this.durationMs = durationMs;
    }

    protected DVTIncrementalStatsModel(Set<DeltaFileWrapper> incrementalFiles) {
        this.changedFiles = this.extractDeltaFiles(incrementalFiles, DeltaFileKind.CHANGED);
        if (this.changedFiles.isEmpty()) {
            this.changedFiles.add(BUILD_CONFIG_LABEL);
        }
        this.otherDeltaFiles = this.extractDeltaFiles(incrementalFiles, DeltaFileKind.DELTA);
    }

    protected DVTIncrementalStatsModel(LocalDateTime timestamp, Set<String> changedFiles, Set<String> otherDeltaFiles, long durationMs) {
        this.timestamp = timestamp;
        this.changedFiles = changedFiles;
        this.otherDeltaFiles = otherDeltaFiles;
        this.durationMs = durationMs;
    }

    private Set<String> extractDeltaFiles(Set<DeltaFileWrapper> incrementalFiles, DeltaFileKind deltaFileKind) {
        return incrementalFiles.stream().filter(deltaFileWrapper -> deltaFileKind.equals((Object)deltaFileWrapper.getKind())).flatMap(deltaFileWrapper -> {
            ParserPath parserPath = deltaFileWrapper.getParserPath();
            if (parserPath == null) {
                return Stream.empty();
            }
            if (parserPath.path == null) {
                return Stream.empty();
            }
            return Stream.of(parserPath.path);
        }).collect(Collectors.toSet());
    }

    protected LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    protected long getDurationMs() {
        return this.durationMs;
    }

    protected Set<String> getChangedFiles() {
        return this.changedFiles;
    }

    protected Set<String> getOtherDeltaFiles() {
        return this.otherDeltaFiles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DVTIncrementalStatsModel that = (DVTIncrementalStatsModel)o;
        return Objects.equals(this.changedFiles, that.changedFiles) && Objects.equals(this.otherDeltaFiles, that.otherDeltaFiles);
    }

    public int hashCode() {
        return Objects.hash(this.changedFiles, this.otherDeltaFiles);
    }
}

