/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.reportissue;

import java.net.URI;
import java.time.LocalDateTime;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.model.floatingwidgets.FNotificationDirtyReason;
import ro.amiq.dvt.model.floatingwidgets.FReportIssueDirtyResource;
import ro.amiq.dvt.model.floatingwidgets.FReportIssueNotificationTracker;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetFactory;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetType;
import ro.amiq.dvt.ui.reportissue.DVTIncrementalThreadDumpCollectorDelegateCommon;
import ro.amiq.dvt.ui.reportissue.DVTThreadDumpCollectorUIDelegate;

class DVTIncrementalThreadDumpCollectorDelegate
extends DVTIncrementalThreadDumpCollectorDelegateCommon {
    protected DVTIncrementalThreadDumpCollectorDelegate(LocalDateTime timestamp, String profilingDirectory) {
        super(timestamp, profilingDirectory);
    }

    @Override
    protected float computeDirectorySize(String profilingDirectory) {
        IProject currentProject = DVTThreadDumpCollectorUIDelegate.getCurrentProject();
        if (currentProject == null) {
            return 0.0f;
        }
        IPath directoryPath = Path.fromOSString((String)profilingDirectory);
        if (directoryPath == null) {
            return 0.0f;
        }
        IWorkspace workspace = currentProject.getWorkspace();
        if (workspace == null) {
            return 0.0f;
        }
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        if (workspaceRoot == null) {
            return 0.0f;
        }
        IContainer container = workspaceRoot.getContainerForLocation(directoryPath);
        if (container == null) {
            return 0.0f;
        }
        if (!container.exists()) {
            return 0.0f;
        }
        final float[] directorySizeBytes = new float[]{0.0f};
        try {
            container.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    IFileInfo fileInfo;
                    block14: {
                        IFileStore store;
                        block13: {
                            String filePathString;
                            block12: {
                                IPath location;
                                block11: {
                                    IResource resource;
                                    block10: {
                                        if (proxy.getType() != 1) {
                                            return true;
                                        }
                                        String name = proxy.getName();
                                        if (name == null) {
                                            return false;
                                        }
                                        if (!name.startsWith("incremental")) {
                                            return false;
                                        }
                                        resource = proxy.requestResource();
                                        if (resource != null) break block10;
                                        return false;
                                    }
                                    location = resource.getLocation();
                                    if (location != null) break block11;
                                    return false;
                                }
                                filePathString = location.toOSString();
                                if (filePathString != null) break block12;
                                return false;
                            }
                            store = EFS.getStore((URI)new URI("file://" + filePathString));
                            if (store != null) break block13;
                            return false;
                        }
                        fileInfo = store.fetchInfo();
                        if (fileInfo != null) break block14;
                        return false;
                    }
                    try {
                        directorySizeBytes[0] = directorySizeBytes[0] + (float)fileInfo.getLength();
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                    return false;
                }
            }, 0);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return directorySizeBytes[0] / 1024.0f / 1024.0f;
    }

    @Override
    protected void handleFloatingNotification() {
        FReportIssueDirtyResource dirtyResource = new FReportIssueDirtyResource(FNotificationDirtyReason.INCREMENTAL_THREAD_DUMP_COLLECTED);
        FReportIssueNotificationTracker.INSTANCE.addDirtyResource(DVTThreadDumpCollectorUIDelegate.getCurrentProject(), dirtyResource);
        FWidgetFactory.INSTANCE.paint(true, FWidgetType.REPORT_ISSUE);
    }
}

