/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.reportissue;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import ro.amiq.dvt.model.reflection.DeltaFileWrapper;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.reportissue.DVTIncrementalStatsJsonHelper;
import ro.amiq.dvt.ui.reportissue.DVTIncrementalStatsModel;
import ro.amiq.dvt.ui.reportissue.DVTIncrementalThreadDumpDropUtil;
import ro.amiq.dvt.ui.reportissue.IncrementalBuildThreadDumpHandler;

public abstract class DVTIncrementalThreadDumpCollectorDelegateCommon {
    protected static final String INCREMENTAL_FILE_PREFIX = "incremental";
    protected static final String GENERIC_INCREMENTAL_LOG_FILE = "incremental_dvt_stats";
    protected static final String DELTA_INFO_LOG_FILE = "delta_info";
    private ZipOutputStream zipGenericLogOS;
    private File currentSessionGenericLogPath;
    private LocalDateTime timestamp;
    private String profilingDirectory;
    private long startTime = System.currentTimeMillis();

    protected DVTIncrementalThreadDumpCollectorDelegateCommon(LocalDateTime timestamp, String profilingDirectory) {
        this.timestamp = timestamp;
        this.profilingDirectory = profilingDirectory;
        this.currentSessionGenericLogPath = new File(profilingDirectory, "incremental_dvt_stats.zip");
    }

    protected void handleIncrementalLogs(Set<DeltaFileWrapper> incrementalFiles, String deltaInfo, String profilingDirectory) throws IOException {
        long elapsedTime = System.currentTimeMillis() - this.startTime;
        DVTIncrementalThreadDumpDropUtil.INSTANCE.uniqueDelta(this.getIncrementalStatsContent(), incrementalFiles, profilingDirectory);
        DVTIncrementalThreadDumpDropUtil.INSTANCE.limitDirectorySize(profilingDirectory, this.computeDirectorySize(profilingDirectory));
        this.buildIncrementalStats(incrementalFiles, elapsedTime);
        this.buildDeltaInfoLog(deltaInfo);
        if (DVTIncrementalThreadDumpDropUtil.INSTANCE.isUniqueDeltaDump()) {
            this.handleFloatingNotification();
        }
    }

    protected abstract void handleFloatingNotification();

    private void buildIncrementalStats(Set<DeltaFileWrapper> incrementalFiles, long elapsedTime) throws IOException {
        if (incrementalFiles == null) {
            return;
        }
        Set<DVTIncrementalStatsModel> statsSet = this.getIncrementalStatsContent();
        DVTIncrementalThreadDumpDropUtil.INSTANCE.cleanIncrementalStats(statsSet);
        if (this.zipGenericLogOS == null) {
            this.zipGenericLogOS = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(this.currentSessionGenericLogPath)));
            this.zipGenericLogOS.putNextEntry(new ZipEntry(GENERIC_INCREMENTAL_LOG_FILE));
        }
        DVTIncrementalStatsModel statsEntry = new DVTIncrementalStatsModel(this.timestamp, incrementalFiles, elapsedTime);
        statsSet.remove(statsEntry);
        statsSet.add(statsEntry);
        String jsonStats = DVTIncrementalStatsJsonHelper.INSTANCE.toJson(statsSet);
        if (jsonStats == null) {
            incrementalFiles = null;
            this.clean();
            return;
        }
        try {
            Throwable throwable = null;
            Object var8_9 = null;
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(jsonStats.getBytes(StandardCharsets.UTF_8));){
                int len;
                byte[] buffer = new byte[1024];
                while ((len = inputStream.read(buffer)) > 0) {
                    this.zipGenericLogOS.write(buffer, 0, len);
                }
                this.zipGenericLogOS.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        incrementalFiles = null;
        this.clean();
    }

    /*
     * Exception decompiling
     */
    private Set<DVTIncrementalStatsModel> getIncrementalStatsContent() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void buildDeltaInfoLog(String deltaInfo) throws IOException {
        if (deltaInfo == null || deltaInfo.isEmpty()) {
            return;
        }
        File deltaInfoFileLog = new File(this.profilingDirectory, "incremental." + this.timestamp.format(IncrementalBuildThreadDumpHandler.DATE_TIME_FORMATTER) + "." + DELTA_INFO_LOG_FILE + ".zip");
        Throwable throwable = null;
        Object var4_5 = null;
        try (ZipOutputStream zipDeltaInfoOS = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(deltaInfoFileLog)));){
            zipDeltaInfoOS.putNextEntry(new ZipEntry(DELTA_INFO_LOG_FILE));
            try {
                Throwable throwable2 = null;
                Object var7_11 = null;
                try (ByteArrayInputStream inputStream = new ByteArrayInputStream(deltaInfo.getBytes(StandardCharsets.UTF_8));){
                    int len;
                    byte[] buffer = new byte[1024];
                    while ((len = inputStream.read(buffer)) > 0) {
                        zipDeltaInfoOS.write(buffer, 0, len);
                    }
                    zipDeltaInfoOS.flush();
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void clean() throws IOException {
        this.currentSessionGenericLogPath = null;
        if (this.zipGenericLogOS == null) {
            return;
        }
        this.zipGenericLogOS.closeEntry();
        this.zipGenericLogOS.close();
        this.zipGenericLogOS = null;
    }

    protected abstract float computeDirectorySize(String var1);
}

