/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.reportissue;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ro.amiq.dvt.model.reflection.DeltaFileWrapper;
import ro.amiq.dvt.ui.reportissue.DVTIncrementalStatsModel;
import ro.amiq.dvt.ui.reportissue.IncrementalBuildThreadDumpHandler;

enum DVTIncrementalThreadDumpDropUtil {
    INSTANCE;

    private static final float INCREMENTAL_MAX_DIRECTORY_SIZE_MB = 20.0f;
    private boolean isUniqueDeltaDump;
    private int nofDeletedThreadDumps;

    protected boolean isUniqueDeltaDump() {
        return this.isUniqueDeltaDump;
    }

    void uniqueDelta(Set<DVTIncrementalStatsModel> incrementalStatsSet, Set<DeltaFileWrapper> incrementalFiles, String profilingDirectory) throws IOException {
        DVTIncrementalStatsModel collectedStats = this.getStatsForDeltaInfo(incrementalStatsSet, incrementalFiles);
        if (collectedStats == null) {
            this.isUniqueDeltaDump = true;
            return;
        }
        this.isUniqueDeltaDump = false;
        this.dropLogs(collectedStats.getTimestamp(), profilingDirectory);
    }

    private DVTIncrementalStatsModel getStatsForDeltaInfo(Set<DVTIncrementalStatsModel> statsSet, Set<DeltaFileWrapper> incrementalFiles) {
        if (incrementalFiles == null) {
            return null;
        }
        DVTIncrementalStatsModel incrementalStatsWrapper = new DVTIncrementalStatsModel(incrementalFiles);
        return statsSet.stream().filter(incrementalStatsWrapper::equals).findFirst().orElse(null);
    }

    private void dropLogs(LocalDateTime timestamp, String profilingDirectory) throws IOException {
        String timestampString = timestamp.format(IncrementalBuildThreadDumpHandler.DATE_TIME_FORMATTER);
        Throwable throwable = null;
        Object var5_6 = null;
        try (Stream<Path> files = Files.walk(Paths.get(profilingDirectory, new String[0]), new FileVisitOption[0]);){
            List collectedLogs = files.filter(p -> {
                File file = p.toFile();
                if (file == null) {
                    return false;
                }
                if (!file.isFile()) {
                    return false;
                }
                String name = file.getName();
                if (name == null) {
                    return false;
                }
                return name.contains(timestampString);
            }).collect(Collectors.toList());
            if (collectedLogs == null || collectedLogs.isEmpty()) {
                return;
            }
            for (Path collectedLog : collectedLogs) {
                Files.deleteIfExists(collectedLog);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    void limitDirectorySize(String profilingDirectory, float directorySizeMB) throws IOException {
        Path directory = Paths.get(profilingDirectory, new String[0]);
        this.nofDeletedThreadDumps = 0;
        while (directorySizeMB > 20.0f) {
            Path oldestFilePath = null;
            Throwable throwable = null;
            Object var6_7 = null;
            try (Stream<Path> files = Files.walk(directory, new FileVisitOption[0]);){
                File file;
                Optional<Path> oldestFileCandidate = files.filter(p -> {
                    File file = p.toFile();
                    if (file == null) {
                        return false;
                    }
                    if (!file.isFile()) {
                        return false;
                    }
                    String name = file.getName();
                    if (name == null) {
                        return false;
                    }
                    return name.contains("incremental");
                }).min((p1, p2) -> p1.toFile().compareTo(p2.toFile()));
                if (!oldestFileCandidate.isPresent() || (oldestFilePath = oldestFileCandidate.get()) == null || (file = oldestFilePath.toFile()) == null) continue;
                float oldestFileSizeMB = (float)file.length() / 1024.0f / 1024.0f;
                directorySizeMB -= oldestFileSizeMB;
                if (!Files.deleteIfExists(oldestFilePath)) continue;
                ++this.nofDeletedThreadDumps;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    void cleanIncrementalStats(Set<DVTIncrementalStatsModel> statsSet) {
        if (statsSet == null) {
            return;
        }
        Iterator<DVTIncrementalStatsModel> iterator = statsSet.iterator();
        int nofDeletedStats = 0;
        while (nofDeletedStats < this.nofDeletedThreadDumps && iterator.hasNext()) {
            iterator.next();
            iterator.remove();
            ++nofDeletedStats;
        }
    }
}

