/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.reportissue;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTStartupConstants;
import ro.amiq.dvt.ui.reportissue.ThreadDumpCollectorConstants;

public enum DVTThreadDumpCollector {
    INSTANCE;

    private static final String DEFAULT_NAME_FORMAT = "%s.thread_dump.zip";
    private static final ScheduledExecutorService SCHEDULER;
    private static ScheduledFuture<?> scheduledFixedRateJob;
    private static RunnableThreadDumpGenerator threadDumpGenerator;

    static {
        SCHEDULER = Executors.newSingleThreadScheduledExecutor();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                DVTThreadDumpCollector.stop();
                SCHEDULER.shutdown();
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }));
    }

    public static SettingsBuilder with() {
        return new SettingsBuilder();
    }

    public static boolean start() {
        return DVTThreadDumpCollector.start(500L, 500L, ThreadDumpCollectorConstants.DEFAULT_TIME_UNIT, DVTThreadDumpCollector.generateOuputFileName(), ThreadDumpCollectorConstants.getOutputDirectory(), 0.0f, 0);
    }

    public static void logEvent(String message) {
        if (threadDumpGenerator != null) {
            threadDumpGenerator.logEvent(message);
        }
    }

    public static void resume(long interval, String message) {
        DVTThreadDumpCollector.resume(0L, interval, TimeUnit.MILLISECONDS, message, false);
    }

    public static void pause() {
        DVTThreadDumpCollector.pause("");
    }

    public static void pause(String message) {
        String stackTrace = Arrays.stream(Thread.currentThread().getStackTrace()).map(StackTraceElement::toString).collect(Collectors.joining("\n\tat "));
        DVTThreadDumpCollector.logEvent(String.format("Thread Dump *PAUSED* (" + message + ") from:\n %s", stackTrace));
        if (scheduledFixedRateJob != null) {
            scheduledFixedRateJob.cancel(true);
        }
    }

    public static boolean isRunning() {
        return scheduledFixedRateJob != null && !scheduledFixedRateJob.isCancelled() && !scheduledFixedRateJob.isDone();
    }

    public static String stop() {
        block3: {
            try {
                if (scheduledFixedRateJob != null) break block3;
                return "";
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return "";
            }
        }
        scheduledFixedRateJob.cancel(true);
        return threadDumpGenerator.close();
    }

    private static final String generateOuputFileName() {
        ZonedDateTime zone = Instant.now().atZone(ZoneId.systemDefault());
        return String.format(DEFAULT_NAME_FORMAT, zone.format(DateTimeFormatter.ofPattern("u-MM-dd_HH-mm-ss.SSS")));
    }

    private static boolean start(long delay, long interval, TimeUnit timeUnit, String filename, String location, float maxSizeMB, int maxDumps) {
        try {
            DVTThreadDumpCollector.stop();
            threadDumpGenerator = new RunnableThreadDumpGenerator(filename, location, maxSizeMB, maxDumps);
            String stackTrace = Arrays.stream(Thread.currentThread().getStackTrace()).map(StackTraceElement::toString).collect(Collectors.joining("\n\tat "));
            DVTThreadDumpCollector.logEvent(String.format("Thread Dump *STARTED* (%d interval, %d delay) from:\n %s", interval, delay, stackTrace));
            scheduledFixedRateJob = SCHEDULER.scheduleAtFixedRate(threadDumpGenerator, delay, interval, timeUnit);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
        return true;
    }

    private static void resume(long delay, long interval, TimeUnit timeUnit, String message, boolean resetDumps) {
        if (scheduledFixedRateJob == null) {
            return;
        }
        scheduledFixedRateJob.cancel(true);
        if (resetDumps) {
            threadDumpGenerator.resetDumps();
        }
        scheduledFixedRateJob = SCHEDULER.scheduleAtFixedRate(threadDumpGenerator, delay, interval, timeUnit);
        String stackTrace = Arrays.stream(Thread.currentThread().getStackTrace()).map(StackTraceElement::toString).collect(Collectors.joining("\n\tat "));
        DVTThreadDumpCollector.logEvent(String.format("Thread Dump *RESUMED* (%d interval, %d delay) from:\n %s", interval, delay, stackTrace));
        DVTThreadDumpCollector.logEvent(message);
    }

    private static class RunnableThreadDumpGenerator
    implements Runnable {
        private static final int SIZE_CHECK_FREQUENCY = 5;
        private int dumps;
        private String filename;
        private String outputDir;
        private Queue<String> events = new ConcurrentLinkedQueue<String>();
        private float maxSizeMB;
        private int maxDumps;
        private ZipOutputStream zip;
        private boolean closed;

        public RunnableThreadDumpGenerator(String filename, String outputDir, float maxSizeMB, int maxDumps) {
            this.filename = filename;
            this.outputDir = outputDir;
            this.maxSizeMB = maxSizeMB;
            this.maxDumps = maxDumps;
        }

        public void resetDumps() {
            this.dumps = 0;
        }

        @Override
        public void run() {
            try {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                this.flushEvents();
                this.flushThreadDumps();
                if (this.isMaxDumpsExceeded() || this.isSizeLimitExceeded()) {
                    scheduledFixedRateJob.cancel(true);
                    return;
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }

        private void flushEvents() {
            StringBuilder sb = new StringBuilder();
            while (!this.events.isEmpty()) {
                String event = this.events.poll();
                sb.append('[').append("Thread Dumps Event : " + event).append(']').append("\n\n");
            }
            this.save(sb.toString());
        }

        private void flushThreadDumps() {
            StringBuilder threadDumps = new StringBuilder();
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            threadDumps.append('[').append("Thread Dumps @").append(' ').append(timestamp).append(']').append("\n\n");
            ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
            ThreadInfo[] threadInfoArray = threadMXBean.getThreadInfo(threadMXBean.getAllThreadIds(), Integer.MAX_VALUE);
            int n = threadInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                ThreadInfo info = threadInfoArray[n2];
                if (info != null) {
                    threadDumps.append('\"').append(info.getThreadName()).append("\": ").append((Object)info.getThreadState());
                    Stream.of(info.getStackTrace()).forEach(st -> {
                        StringBuilder stringBuilder2 = threadDumps.append("\n    at ").append(this.stackTraceToString((StackTraceElement)st));
                    });
                    threadDumps.append("\n\n");
                }
                ++n2;
            }
            this.save(threadDumps.toString());
            ++this.dumps;
        }

        private String stackTraceToString(StackTraceElement st) {
            return String.valueOf(st.getClassName()) + "." + st.getMethodName() + (st.isNativeMethod() ? "(Native Method)" : (st.getFileName() != null && st.getLineNumber() >= 0 ? "(" + st.getFileName() + ":" + st.getLineNumber() + ")" : (st.getFileName() != null ? "(" + st.getFileName() + ")" : "(Unknown Source)")));
        }

        private synchronized void save(String string) {
            try {
                if (this.closed) {
                    return;
                }
                if (this.zip == null) {
                    File location;
                    if (!this.filename.endsWith(".thread_dump.zip")) {
                        this.filename = String.valueOf(this.filename) + ".thread_dump.zip";
                    }
                    if (!(location = new File(this.outputDir, this.filename)).exists()) {
                        location.getParentFile().mkdirs();
                    }
                    this.zip = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(location.getAbsolutePath())));
                    this.zip.putNextEntry(new ZipEntry("thread_dumps.log"));
                }
                byte[] data = string.getBytes();
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                this.zip.write(data, 0, data.length);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }

        private boolean isMaxDumpsExceeded() {
            return this.maxDumps > 0 && this.dumps >= this.maxDumps;
        }

        private boolean isSizeLimitExceeded() {
            if (this.maxSizeMB == 0.0f) {
                return false;
            }
            if ((this.dumps - 1) % 5 != 0) {
                return false;
            }
            File file = new File(this.outputDir, this.filename);
            return !((float)(FileUtils.sizeOf((File)file) / 0x100000L) < this.maxSizeMB);
        }

        public void logEvent(String message) {
            this.events.add(String.valueOf(message) + " @ " + new Timestamp(System.currentTimeMillis()));
        }

        public synchronized String close() {
            try {
                if (this.zip == null) {
                    return "";
                }
                if (this.closed) {
                    String string = new File(this.outputDir, this.filename).getAbsolutePath();
                    return string;
                }
                String stackTrace = Arrays.stream(Thread.currentThread().getStackTrace()).map(StackTraceElement::toString).collect(Collectors.joining("\n\tat "));
                this.logEvent(String.format("Thread Dump *STOPPED* from:\n %s", stackTrace));
                if (this.dumps > 0) {
                    this.flushEvents();
                }
                this.zip.closeEntry();
                this.zip.finish();
                this.zip.close();
                String string = new File(this.outputDir, this.filename).getAbsolutePath();
                return string;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            finally {
                this.closed = true;
            }
            return "";
        }
    }

    public static class SettingsBuilder {
        private long delay = 500L;
        private long interval = 500L;
        private TimeUnit timeUnit = ThreadDumpCollectorConstants.DEFAULT_TIME_UNIT;
        private String filename = DVTThreadDumpCollector.generateOuputFileName();
        private String path;
        private String prefix = "";
        private float maxSizeMB;
        private int maxDumps;
        private String event = "";
        private boolean resetDumps;

        public SettingsBuilder delay(long delay) {
            this.delay = delay;
            return this;
        }

        public SettingsBuilder interval(long interval) {
            this.interval = interval;
            return this;
        }

        public SettingsBuilder timeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        public SettingsBuilder filename(String filename) {
            this.filename = filename;
            return this;
        }

        private String getFilename() {
            StringBuilder result = new StringBuilder();
            if (DVTStartupConstants.isLSRunning.get()) {
                result.append(ThreadDumpCollectorConstants.getPlatformPrefix()).append('.');
            }
            if (!this.prefix.isEmpty()) {
                result.append(this.prefix).append('.');
            }
            result.append(this.filename);
            return result.toString();
        }

        public SettingsBuilder path(String path) {
            this.path = path;
            return this;
        }

        public SettingsBuilder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public SettingsBuilder maxSize(float maxSize) {
            this.maxSizeMB = maxSize;
            return this;
        }

        public SettingsBuilder maxDumps(int maxDumps) {
            this.maxDumps = maxDumps;
            return this;
        }

        public SettingsBuilder event(String event) {
            this.event = event;
            return this;
        }

        public SettingsBuilder resetDumps() {
            this.resetDumps = true;
            return this;
        }

        public boolean start() {
            String location = ThreadDumpCollectorConstants.getOutputDirectory();
            if (this.path != null) {
                location = String.valueOf(location) + File.separator + this.path;
            }
            return DVTThreadDumpCollector.start(this.delay, this.interval, this.timeUnit, this.getFilename(), location, this.maxSizeMB, this.maxDumps);
        }

        public void resume() {
            DVTThreadDumpCollector.resume(this.delay, this.interval, this.timeUnit, this.event, this.resetDumps);
        }
    }
}

