/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.reportissue;

import java.io.Serializable;
import java.util.EnumMap;
import java.util.Map;
import java.util.stream.Collectors;

public class DVTThreadDumpCollectorAttributes
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_PERIOD_MS = 500;
    private Map<DVTProfileAttribute, Integer> fAttributes = new EnumMap<DVTProfileAttribute, Integer>(DVTProfileAttribute.class);

    public boolean hasAttribute(DVTProfileAttribute attribute) {
        return this.fAttributes.containsKey((Object)DVTProfileAttribute.ALL) || this.fAttributes.containsKey((Object)attribute);
    }

    public int getInterval(DVTProfileAttribute attribute) {
        if (this.fAttributes.containsKey((Object)attribute)) {
            return this.fAttributes.get((Object)attribute);
        }
        if (this.fAttributes.containsKey((Object)DVTProfileAttribute.ALL)) {
            return this.fAttributes.get((Object)DVTProfileAttribute.ALL);
        }
        return 500;
    }

    public void addAttribute(DVTProfileAttribute attribute, int periodMS) {
        this.fAttributes.put(attribute, periodMS);
    }

    public boolean isEmpty() {
        return this.fAttributes == null || this.fAttributes.isEmpty();
    }

    public String toString() {
        if (this.fAttributes == null || this.fAttributes.isEmpty()) {
            return "none";
        }
        return this.fAttributes.entrySet().stream().map(e -> e.getKey() + "@" + e.getValue() + "ms").collect(Collectors.joining(", "));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fAttributes == null ? 0 : this.fAttributes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DVTThreadDumpCollectorAttributes)) {
            return false;
        }
        DVTThreadDumpCollectorAttributes other = (DVTThreadDumpCollectorAttributes)obj;
        return !(this.fAttributes == null ? other.fAttributes != null : !this.fAttributes.equals(other.fAttributes));
    }

    public static enum DVTProfileAttribute {
        VLOG_RI,
        VLOG_RC,
        VLOG_RD,
        VLOG_US,
        VLOG_EP,
        VLOG_CP,
        ELAB,
        UNEL,
        VHDL_RU,
        VHDL_RT,
        VHDL_RD,
        VHDL_US,
        VHDL_USBD,
        VHDL_CP,
        ALL;

    }
}

