/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.reportissue;

import java.io.File;
import java.util.zip.ZipFile;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.reportissue.DVTThreadDumpCollector;
import ro.amiq.dvt.ui.reportissue.DVTThreadDumpCollectorUIDelegate;
import ro.amiq.dvt.ui.smartcopy.SmartCopyUtils;
import ro.amiq.dvt.utils.DVTFileUtils;

public class DVTThreadDumpCollectorDelegate
extends AbstractHandler {
    private static final String START_THREAD_DUMP_COMMAND_ID = "ro.amiq.dvt.ui.StartThreadDumpCollector";
    private static final String STOP_THREAD_DUMP_COMMAND_ID = "ro.amiq.dvt.ui.StopThreadDumpCollector";
    private static final String OPEN_THREAD_DUMP_COMMAND_ID = "ro.amiq.dvt.ui.OpenThreadDumpCollectorDialog";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (START_THREAD_DUMP_COMMAND_ID.equals(event.getCommand().getId())) {
            boolean started = DVTThreadDumpCollector.start();
            if (started) {
                SmartCopyUtils.updateStatusBarWithInfo("DVT Thread Dump Collector started!");
            } else {
                SmartCopyUtils.updateStatusBarWithError("DVT Thread Dump Collector could not start! Report the issue from Help > DVT Quick Help > Report an Issue...");
            }
        } else if (STOP_THREAD_DUMP_COMMAND_ID.equals(event.getCommand().getId())) {
            String path = DVTThreadDumpCollector.stop();
            if (!path.isEmpty()) {
                try {
                    Throwable throwable = null;
                    Object var4_7 = null;
                    try (ZipFile zip = new ZipFile(path);){
                        SmartCopyUtils.updateStatusBarWithInfo("DVT Thread Dump Collector finished: " + path);
                        File extracted = DVTFileUtils.getInstance().extractTemporaryFileFromZip(zip);
                        DVTFileUtils.getInstance().openFile(extracted);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        } else if (OPEN_THREAD_DUMP_COMMAND_ID.equals(event.getCommand().getId())) {
            DVTThreadDumpCollectorUIDelegate.INSTANCE.showPopUpDialog(DVTThreadDumpCollector.isRunning());
        }
        return null;
    }
}

