/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.reportissue;

import java.io.File;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import ro.amiq.dvt.model.reflection.util.RfGUIReferencesUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.reportissue.DVTThreadDumpCollector;
import ro.amiq.dvt.ui.smartcopy.SmartCopyUtils;
import ro.amiq.dvt.utils.DVTFileUtils;

public enum DVTThreadDumpCollectorUIDelegate {
    INSTANCE;

    private ThreadDumpDialog fDialog;
    private static final String THREAD_DUMP_IN_PROGRESS_MESSAGE = "A thread dump is currently in progress.";

    public void showPopUpDialog(boolean fSessionInProgress) {
        this.fDialog = new ThreadDumpDialog(DVTUiUtils.getActiveWorkbenchWindow().getShell(), !fSessionInProgress);
        this.fDialog.open();
    }

    public boolean isDialogOpen() {
        return this.fDialog != null && this.fDialog.getShell() != null && !this.fDialog.getShell().isDisposed();
    }

    public void enableDialog() {
        if (this.fDialog == null || this.fDialog.isEnabled() || this.fDialog.getShell() == null || this.fDialog.getShell().isDisposed()) {
            return;
        }
        this.fDialog.switchState(true);
    }

    public void updateStatusBar(String message, boolean isError, boolean displayInLSMode) {
        SmartCopyUtils.updateStatusBarWithInfo(message);
    }

    public static IProject getCurrentProject() {
        return RfGUIReferencesUtils.getCurrentProject();
    }

    private class ThreadDumpDialog
    extends TitleAreaDialog {
        private boolean fDialogEnabled;
        private Text fDialogPeriodText;
        private int interval;
        private Button openInEditor;

        public ThreadDumpDialog(Shell parentShell, boolean enabled) {
            super(parentShell);
            this.interval = 500;
            this.setShellStyle(1264);
            this.fDialogEnabled = enabled;
        }

        protected Point getInitialSize() {
            return new Point(425, 250);
        }

        public void create() {
            super.create();
            this.setTitleImage(DVTImages.imageCache.getImage(DVTImages.REPORT_ISSUE_TITLE));
            this.setTitle("Fill in the Thread Dump Collector parameters.");
            if (!this.fDialogEnabled) {
                this.setMessage(DVTThreadDumpCollectorUIDelegate.THREAD_DUMP_IN_PROGRESS_MESSAGE, 2);
            }
            this.getShell().layout();
        }

        public boolean isEnabled() {
            return this.fDialogEnabled;
        }

        public void switchState(boolean enable) {
            this.fDialogEnabled = enable;
            Display.getDefault().asyncExec(() -> {
                if (enable) {
                    this.fDialogPeriodText.setEnabled(true);
                    this.getButton(1024).setText("Start");
                    this.setMessage(null, 2);
                    this.validateFields();
                } else {
                    this.fDialogPeriodText.setEnabled(false);
                    this.getButton(1024).setText("Stop");
                    this.setMessage(DVTThreadDumpCollectorUIDelegate.THREAD_DUMP_IN_PROGRESS_MESSAGE, 2);
                }
            });
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText("DVT Thread Dump Collector");
            shell.setImage(DVTImages.imageCache.getImage(DVTImages.REPORT_ISSUE_IMAGE));
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 1, "Close", true);
            this.createButton(parent, 1024, this.fDialogEnabled ? "Start" : "Stop", true).setEnabled(true);
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 1024) {
                Button button = this.getButton(buttonId);
                if ("Start".equals(button.getText())) {
                    boolean started = DVTThreadDumpCollector.with().interval(this.interval).start();
                    if (started) {
                        SmartCopyUtils.updateStatusBarWithInfo("DVT Thread Dump Collector started!");
                        this.switchState(false);
                    } else {
                        SmartCopyUtils.updateStatusBarWithError("DVT Thread Dump Collector could not start! Report the issue from Help > DVT Quick Help > Report an Issue...");
                    }
                    return;
                }
                if ("Stop".equals(button.getText())) {
                    String zipFileLocation = DVTThreadDumpCollector.stop();
                    SmartCopyUtils.updateStatusBarWithInfo("DVT Thread Dump Collector finished: " + zipFileLocation);
                    this.switchState(true);
                    if (this.openInEditor.getSelection()) {
                        try {
                            Throwable throwable = null;
                            Object var5_8 = null;
                            try (ZipFile zip = new ZipFile(zipFileLocation);){
                                File extracted = DVTFileUtils.getInstance().extractTemporaryFileFromZip(zip);
                                DVTFileUtils.getInstance().openFile(extracted);
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (Exception e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                        }
                    }
                    return;
                }
            }
            this.close();
        }

        protected boolean isResizable() {
            return true;
        }

        public boolean isHelpAvailable() {
            return false;
        }

        protected Control createDialogArea(Composite parent) {
            Composite container = (Composite)super.createDialogArea(parent);
            Composite composite = new Composite(container, 0);
            GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).applyTo(composite);
            GridDataFactory.fillDefaults().applyTo((Control)composite);
            Label label = new Label(composite, 0);
            GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)label);
            label.setText("Period (milliseconds): ");
            this.fDialogPeriodText = new Text(composite, 2048);
            GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)this.fDialogPeriodText);
            this.fDialogPeriodText.setText(String.valueOf(500));
            this.fDialogPeriodText.setEnabled(this.fDialogEnabled);
            this.fDialogPeriodText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    ThreadDumpDialog.this.validateFields();
                }
            });
            label = new Label(composite, 0);
            GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)label);
            label.setText("Open log file in editor: ");
            this.openInEditor = new Button(composite, 32);
            this.openInEditor.setSelection(false);
            return container;
        }

        private boolean validateFields() {
            block5: {
                block4: {
                    try {
                        if (!this.fDialogPeriodText.getText().isEmpty()) break block4;
                        this.setMessage("Period field must not be empty!", 3);
                        this.getButton(1024).setEnabled(false);
                        return false;
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        return true;
                    }
                }
                if (this.fDialogPeriodText.getText().matches("[1-9]\\d*")) break block5;
                this.setMessage("Period field must be a valid number!", 3);
                this.getButton(1024).setEnabled(false);
                return false;
            }
            this.setMessage(null, 3);
            this.getButton(1024).setEnabled(true);
            this.interval = Integer.parseInt(this.fDialogPeriodText.getText());
            return true;
        }
    }
}

