/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.reportissue;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.reportissue.HttpUploaderResult;
import ro.amiq.dvt.ui.reportissue.HttpUploaderUtils;

class HttpUploader {
    private final AtomicBoolean fIsActive = new AtomicBoolean(true);
    private final AtomicBoolean fIsSending = new AtomicBoolean(false);
    private HashMap<String, Object> fParams;
    private URL fURL = null;
    private HttpURLConnection fConnection;
    private OutputStream fOutputStream = null;
    private static final int BUFFER_SIZE = 500000;
    private static final int CONNECTION_TIMEOUT_MILLIS = 10000;
    private String fBoundary = "---------------------------" + this.randomString() + this.randomString() + this.randomString();

    public HttpUploader(String strURL, HashMap<String, Object> params) {
        try {
            this.fURL = new URL(strURL);
            this.fParams = params;
        }
        catch (Exception e) {
            this.fIsSending.set(false);
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private String randomString() {
        Random random = new Random();
        return Long.toString(random.nextLong(), 36);
    }

    public void setIsActive(boolean state) {
        this.fIsActive.set(state);
    }

    public boolean isSending() {
        return this.fIsSending.get();
    }

    public HttpUploaderResult upload() {
        if (this.fParams == null || this.fURL == null) {
            return HttpUploaderUtils.INSTANCE.buildErroneousResult();
        }
        try {
            URLConnection connection = this.fURL.openConnection();
            if (!(connection instanceof HttpURLConnection)) {
                HttpUploaderResult httpUploaderResult = HttpUploaderUtils.INSTANCE.buildErroneousResult();
                return httpUploaderResult;
            }
            this.fConnection = (HttpURLConnection)connection;
            this.fConnection.setReadTimeout(10000);
            this.fConnection.setDoOutput(true);
            this.fConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.fBoundary);
            this.fOutputStream = this.fConnection.getOutputStream();
            if (!this.fIsActive.get()) {
                this.fOutputStream.close();
                HttpUploaderResult httpUploaderResult = HttpUploaderUtils.INSTANCE.buildErroneousResult();
                return httpUploaderResult;
            }
            for (Map.Entry<String, Object> entry : this.fParams.entrySet()) {
                String param = entry.getKey();
                if (!this.fIsActive.get()) {
                    this.fOutputStream.close();
                    HttpUploaderResult httpUploaderResult = HttpUploaderUtils.INSTANCE.buildErroneousResult();
                    return httpUploaderResult;
                }
                Object object = entry.getValue();
                if (object instanceof File) {
                    File file = (File)object;
                    this.setParameter(param, file.getPath(), new BufferedInputStream(new FileInputStream(file)));
                } else {
                    this.setParameter(param, object.toString());
                }
                this.fIsSending.set(true);
            }
            this.fIsSending.set(false);
            this.boundary();
            this.writeln("--");
            this.fOutputStream.close();
            InputStream retIS = this.fConnection.getInputStream();
            if (!this.fIsActive.get()) {
                retIS.close();
                HttpUploaderResult httpUploaderResult = HttpUploaderUtils.INSTANCE.buildErroneousResult();
                return httpUploaderResult;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(retIS));
            String s = "";
            HttpUploaderResult uploadResult = null;
            while ((s = br.readLine()) != null) {
                JsonObject uploadResponse = JsonParser.parseString((String)s).getAsJsonObject();
                uploadResult = HttpUploaderUtils.INSTANCE.parseUploadResponse(uploadResponse);
            }
            retIS.close();
            HttpUploaderResult httpUploaderResult = uploadResult;
            return httpUploaderResult;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            HttpUploaderResult httpUploaderResult = HttpUploaderUtils.INSTANCE.buildErroneousResult();
            return httpUploaderResult;
        }
        finally {
            this.fIsSending.set(false);
        }
    }

    private void setParameter(String name, String filename, InputStream is) {
        this.boundary();
        this.writeName(name);
        this.write("; filename=\"");
        this.write(filename);
        this.write('\"');
        this.newline();
        this.write("Content-Type: ");
        String fType = URLConnection.guessContentTypeFromName(filename);
        if (fType == null) {
            fType = "application/octet-stream";
        }
        this.writeln(fType);
        this.newline();
        this.pipe(is, this.fOutputStream);
        this.newline();
    }

    private void setParameter(String name, String value) {
        this.boundary();
        this.writeName(name);
        this.newline();
        this.newline();
        this.writeln(value);
    }

    private void boundary() {
        this.write("--");
        this.write(this.fBoundary);
    }

    private void write(char c) {
        try {
            this.fOutputStream.write(c);
        }
        catch (Exception e) {
            this.fIsSending.set(false);
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void write(String s) {
        try {
            this.fOutputStream.write(s.getBytes());
        }
        catch (Exception e) {
            this.fIsSending.set(false);
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void newline() {
        this.write("\r\n");
    }

    private void writeln(String s) {
        this.write(s);
        this.newline();
    }

    private void writeName(String name) {
        this.newline();
        this.write("Content-Disposition: form-data; name=\"");
        this.write(name);
        this.write('\"');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pipe(InputStream in, OutputStream out) {
        try {
            byte[] buffer = new byte[500000];
            InputStream inputStream = in;
            synchronized (inputStream) {
                int nRead;
                while ((nRead = in.read(buffer, 0, buffer.length)) >= 0 && this.fIsActive.get()) {
                    out.write(buffer, 0, nRead);
                }
            }
            out.flush();
            buffer = null;
        }
        catch (Exception e) {
            this.fIsSending.set(false);
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

