/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.reportissue;

import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.reportissue.HttpUploader;
import ro.amiq.dvt.ui.reportissue.HttpUploaderResult;
import ro.amiq.dvt.ui.reportissue.HttpUploaderUtils;

public class HttpUploaderMonitor {
    private String fUrlString;
    private HashMap<String, Object> fParams;
    private static final int UPLOAD_TIMEOUT_MILLIS = 60000;
    private IProgressMonitor fProgressMonitor;

    public HttpUploaderMonitor(String urlString, HashMap<String, Object> params, IProgressMonitor monitor) {
        this.fUrlString = urlString;
        this.fParams = params;
        this.fProgressMonitor = monitor;
    }

    public HttpUploaderResult upload() {
        HttpUploaderThread hut = new HttpUploaderThread(this.fUrlString, this.fParams);
        hut.start();
        int delta = 100;
        int maxIterations = 60000 / delta;
        this.fProgressMonitor.beginTask("Sending DVT Issue Report...", -1);
        HttpUploaderResult uploadResult = null;
        int currentIteration = 0;
        try {
            while (hut.isSending() || currentIteration < maxIterations) {
                if (this.fProgressMonitor.isCanceled()) {
                    HttpUploaderResult httpUploaderResult = new HttpUploaderResult(true);
                    return httpUploaderResult;
                }
                uploadResult = hut.getHttpUploaderRes();
                if (uploadResult != null) {
                    HttpUploaderResult httpUploaderResult = uploadResult;
                    return httpUploaderResult;
                }
                Thread.sleep(delta);
                ++currentIteration;
            }
            HttpUploaderResult httpUploaderResult = uploadResult;
            return httpUploaderResult;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        finally {
            hut.setIsActive(false);
        }
        return HttpUploaderUtils.INSTANCE.buildErroneousResult();
    }

    private static class HttpUploaderThread
    extends Thread {
        private HttpUploader fHttpUploader;
        private HttpUploaderResult fHttpUploaderRes;

        public HttpUploaderThread(String strURL, HashMap<String, Object> params) {
            super("DVT Report Issue HttpUploaderThread");
            this.fHttpUploader = new HttpUploader(strURL, params);
        }

        public void setIsActive(boolean state) {
            this.fHttpUploader.setIsActive(state);
        }

        public HttpUploaderResult getHttpUploaderRes() {
            return this.fHttpUploaderRes;
        }

        public boolean isSending() {
            return this.fHttpUploader.isSending();
        }

        @Override
        public void run() {
            this.fHttpUploaderRes = this.fHttpUploader.upload();
        }
    }
}

