/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.reportissue;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import ro.amiq.dvt.ui.reportissue.HttpUploaderResult;

public enum HttpUploaderUtils {
    INSTANCE;

    private static final String SUCCESS_FIELD = "success";
    private static final String MESSAGE_FIELD = "message";

    public HttpUploaderResult buildErroneousResult() {
        return new HttpUploaderResult(false, "Error while sending the issue report. Please check your Internet connection!");
    }

    private boolean getSuccessField(JsonObject uploadResponse) {
        if (!uploadResponse.has(SUCCESS_FIELD)) {
            return false;
        }
        JsonElement successObj = uploadResponse.get(SUCCESS_FIELD);
        if (!(successObj instanceof JsonPrimitive)) {
            return false;
        }
        return ((JsonPrimitive)successObj).getAsBoolean();
    }

    private String getMessageField(JsonObject uploadResponse) {
        if (!uploadResponse.has(MESSAGE_FIELD)) {
            return null;
        }
        JsonElement messageObj = uploadResponse.get(MESSAGE_FIELD);
        if (!(messageObj instanceof JsonPrimitive)) {
            return null;
        }
        return ((JsonPrimitive)messageObj).getAsString();
    }

    public HttpUploaderResult parseUploadResponse(JsonObject uploadResponse) {
        boolean success = this.getSuccessField(uploadResponse);
        String message = this.getMessageField(uploadResponse);
        return new HttpUploaderResult(success, message);
    }
}

