/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.reportissue;

import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.DeltaFileWrapper;
import ro.amiq.dvt.model.reflection.IIncrementalDeltaContainer;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.ui.reportissue.IncrementalDeltaFilesCallback;
import ro.amiq.dvt.ui.reportissue.IncrementalDeltaInfoCallback;

interface IIncrementalInfoCallbackFactoryCommon {
    default public IncrementalDeltaFilesCallback createIncrementalDeltaFilesCallback(RfMixedLangProject rfMixedLangProject) {
        return () -> {
            HashSet<DeltaFileWrapper> deltaFiles = new HashSet<DeltaFileWrapper>();
            this.extractDeltaFiles(rfMixedLangProject, deltaFiles);
            return deltaFiles;
        };
    }

    default public void extractDeltaFiles(RfMixedLangProject rfMixedLangProject, Set<DeltaFileWrapper> deltaFiles) {
        if (rfMixedLangProject == null) {
            return;
        }
        for (IRfSingleLangProject rfProject : rfMixedLangProject.getSingleLangProjects()) {
            IIncrementalDeltaContainer incrementalDeltaContainer = rfProject.getIncrementalDeltaContainer();
            if (incrementalDeltaContainer == null) continue;
            deltaFiles.addAll(incrementalDeltaContainer.getDeltaFilesParserPath(true));
        }
    }

    default public IncrementalDeltaInfoCallback createIncrementalDeltaInfoCallback(RfMixedLangProject rfMixedLangProject) {
        return () -> {
            StringBuilder deltaInfoBuilder = new StringBuilder();
            for (IRfSingleLangProject rfProject : rfMixedLangProject.getSingleLangProjects()) {
                String projectDeltaInfo;
                IIncrementalDeltaContainer incrementalDeltaContainer = rfProject.getIncrementalDeltaContainer();
                if (incrementalDeltaContainer == null || (projectDeltaInfo = incrementalDeltaContainer.logDelta(IIncrementalDeltaContainer.LogOption.ALL.exclude(IIncrementalDeltaContainer.LogOption.BEFORE_INCREMENTAL_NAMED_ELEMENTS).exclude(IIncrementalDeltaContainer.LogOption.AFTER_INCREMENTAL_NAMED_ELEMENTS).exclude(IIncrementalDeltaContainer.LogOption.CHANGED_TYPE_NAMES))) == null || projectDeltaInfo.isEmpty()) continue;
                deltaInfoBuilder.append(projectDeltaInfo);
            }
            return deltaInfoBuilder.toString();
        };
    }
}

