/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.reportissue;

import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.IncrementalProfilingWrapper;
import ro.amiq.dvt.model.reflection.DeltaFileWrapper;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.reportissue.DVTIncrementalThreadDumpCollectorDelegate;
import ro.amiq.dvt.ui.reportissue.DVTThreadDumpCollector;
import ro.amiq.dvt.ui.reportissue.IncrementalDeltaFilesCallback;
import ro.amiq.dvt.ui.reportissue.IncrementalDeltaInfoCallback;
import ro.amiq.dvt.ui.reportissue.ThreadDumpCollectorConstants;

public enum IncrementalBuildThreadDumpHandler {
    INSTANCE;

    static final DateTimeFormatter DATE_TIME_FORMATTER;
    private static final float INCREMENTAL_MAX_FILE_SIZE_MB = 2.0f;
    private DVTIncrementalThreadDumpCollectorDelegate fIncrementalThreadDumpDelegate;
    private IncrementalDeltaFilesCallback changedFilesCallback;
    private IncrementalDeltaInfoCallback deltaInfoCallback;
    private String location;
    private boolean isRunning;

    static {
        DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("u-MM-dd_HH-mm-ss.SSS");
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void createSession(IncrementalDeltaFilesCallback changedFilesCallback, IncrementalDeltaInfoCallback deltaInfoCallback, IProject project) {
        if (DVTThreadDumpCollector.isRunning()) {
            return;
        }
        IncrementalProfilingWrapper incrementalProfileWrapper = BuildConfigManager.getIncrementalProfilingWrapper(project);
        if (incrementalProfileWrapper == null || incrementalProfileWrapper.isDummy()) {
            return;
        }
        this.location = String.valueOf(ThreadDumpCollectorConstants.getOutputDirectory()) + File.separator + "incremental";
        LocalDateTime startTimestamp = LocalDateTime.now();
        this.fIncrementalThreadDumpDelegate = new DVTIncrementalThreadDumpCollectorDelegate(startTimestamp, this.location);
        this.changedFilesCallback = changedFilesCallback;
        this.deltaInfoCallback = deltaInfoCallback;
        DVTThreadDumpCollector.with().prefix("incremental").filename(startTimestamp.format(DATE_TIME_FORMATTER)).interval(incrementalProfileWrapper.getPeriod()).path("incremental").delay(incrementalProfileWrapper.getDelayTime()).maxSize(2.0f).start();
        this.isRunning = true;
    }

    public void destroySession() {
        try {
            if (!this.isRunning) {
                return;
            }
            if (DVTThreadDumpCollector.stop().isEmpty()) {
                return;
            }
            this.isRunning = false;
            Set<DeltaFileWrapper> incrementalDeltaFiles = null;
            if (this.changedFilesCallback != null) {
                incrementalDeltaFiles = this.changedFilesCallback.getDeltaFiles();
            }
            String deltaInfo = null;
            if (this.deltaInfoCallback != null) {
                deltaInfo = this.deltaInfoCallback.getDeltaInfo();
            }
            if (this.fIncrementalThreadDumpDelegate == null) {
                return;
            }
            this.fIncrementalThreadDumpDelegate.handleIncrementalLogs(incrementalDeltaFiles, deltaInfo, this.location);
            this.fIncrementalThreadDumpDelegate = null;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

