/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.reportissue;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.reflection.DeltaFileKind;
import ro.amiq.dvt.model.reflection.DeltaFileWrapper;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.ui.reportissue.IIncrementalInfoCallbackFactoryCommon;
import ro.amiq.dvt.ui.reportissue.IncrementalDeltaFilesCallback;

public enum IncrementalInfoCallbackFactory implements IIncrementalInfoCallbackFactoryCommon
{
    INSTANCE;

    private final List<LanguageKind> nonDeltaContainerLanguages = Arrays.asList(LanguageKind.E, LanguageKind.PSS);
    private Map<LanguageKind, Set<FileCompileInfo>> changedFiles;

    public IncrementalDeltaFilesCallback createIncrementalDeltaFilesCallback(RfMixedLangProject rfMixedLangProject, Map<LanguageKind, Set<FileCompileInfo>> changedFiles) {
        this.changedFiles = changedFiles;
        return this.createIncrementalDeltaFilesCallback(rfMixedLangProject);
    }

    @Override
    public void extractDeltaFiles(RfMixedLangProject rfMixedLangProject, Set<DeltaFileWrapper> deltaFiles) {
        IIncrementalInfoCallbackFactoryCommon.super.extractDeltaFiles(rfMixedLangProject, deltaFiles);
        if (this.changedFiles == null) {
            return;
        }
        for (LanguageKind nonDeltaContainerLanguage : this.nonDeltaContainerLanguages) {
            if (!this.changedFiles.containsKey((Object)nonDeltaContainerLanguage)) continue;
            deltaFiles.addAll(this.handleNonDeltaContainerChangedFiles(this.changedFiles, nonDeltaContainerLanguage));
        }
    }

    private Set<DeltaFileWrapper> handleNonDeltaContainerChangedFiles(Map<LanguageKind, Set<FileCompileInfo>> changedFiles, LanguageKind nonDeltaContainerLanguage) {
        Set<DeltaFileWrapper> changedFilesWrapper = changedFiles.get((Object)nonDeltaContainerLanguage).stream().flatMap(fileCompileInfo -> {
            IFile file = fileCompileInfo.getFile();
            if (file == null) {
                return Stream.empty();
            }
            IPath fullPath = file.getLocation();
            if (fullPath == null) {
                return Stream.empty();
            }
            return Stream.of(new DeltaFileWrapper(new ParserPath(fullPath.toOSString()), DeltaFileKind.CHANGED));
        }).collect(Collectors.toSet());
        return changedFilesWrapper;
    }
}

