/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.reportissue;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ConfigurationInfo;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.ai.AIHostContributorManager;
import ro.amiq.dvt.ai.IAIHostContributor;
import ro.amiq.dvt.flclient.DFLI;
import ro.amiq.dvt.node.NodeJSManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.reportissue.HttpUploaderMonitor;
import ro.amiq.dvt.ui.reportissue.HttpUploaderResult;
import ro.amiq.dvt.ui.reportissue.ThreadDumpCollectorConstants;
import ro.amiq.dvt.ui.smartcopy.SmartCopyUtils;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.ui.utils.StringEditorUtils;
import ro.amiq.dvt.ui.views.templates.TemplatesViewUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTProfilingUtils;
import ro.amiq.dvt.utils.XMLParser;

class ReportIssueDialog
extends TitleAreaDialog {
    private static final int DETAILED_THREAD_DUMP_NAME_NOF_SEGMENTS = 4;
    private static final String THREAD_DUMP_SEGMENT_SEPARATOR = ".";
    private static final String AMIQ_SUPPORT_GROUP = "support@amiq.com";
    TableViewer fTableViewer;
    Text fNameText;
    Text fCompanyText;
    Text fEmailText;
    Text fSummaryText;
    Text fInfoText;
    Label fAttachInfoLabel;
    Composite fAttachFilesComposite;
    Button fAddFileButton;
    Button fSelectAllButton;
    Button fDeselectAllButton;
    Map<String, Object> fFilesToBeZipped = new TreeMap<String, Object>();
    Shell fShell;
    public static boolean IS_STARTED = false;
    private static final String REPORT_AN_ISSUE_IN_DVT = "Report an Issue in DVT";
    private static final long ATTACHED_FILES_DEFAULT_SIZE = 0x1900000L;
    private static final String DVT_REPORT_ISSUE_MAX_SIZE_MB = "DVT_REPORT_ISSUE_MAX_SIZE_MB";
    private final long fAttachedFilesMaxSize;
    private static final String UPLOAD_FILES_URL = "https://eda.amiq.com/report_issue/v2.php";
    private static final String ECLIPSE_LOG_FILE_NAME = "eclipse.log";
    private static final String ECLIPSE_INFO_FILE_NAME = "eclipse.info";
    private static final String LICENSE_LOG_FILE_NAME = "license.log";
    private static final String HARDWARE_INFO_FILE_NAME = "hardware.info";
    private static final String OS_INFO_FILE_NAME = "os.info";
    private static final String AI_ASSISTANT_LOG_FILE_NAME = "ai_assistant.log";
    private static final String AI_TOOLS_LOG_FILE_NAME = "ai_tools.log";
    private static final String ISSUE_REPORT_FILE_NAME = "issue.report";
    private static final String AI_NODE_RUNTIME_LOG_FILE_NAME = "ai_node.log";
    public static final String MSG_CONNECTION_NOT_AVAILABLE = "Connection not available";
    public static final String MSG_UNABLE_TO_SEND_EMAIL = "Error: Unable to send the report!";
    private static final String INTERNAL_VALIDATION_FIELD = "validation";
    private static final String EMAIL_SUBJECT_FIELD = "subject";
    private static final String EMAIL_COMPANY_FIELD = "company";
    private static final String EMAIL_TEXT_FIELD = "text";
    private static final String EMAIL_SENDER_FIELD = "sender";
    private static final String EMAIL_ATTACHMENT_FIELD = "attachment";
    private static final String DVT_VERSION_FIELD = "dvt_version";
    private static final String INTERNAL_VALIDATION_TEXT = "DVT123";
    private static final String DVT_ZIP_FILE_NAME = "dvt_report_";
    private static final String DEFAULT_SUB_TITLE_MESSAGE = "'Send' the report directly or 'Save as Zip' file and send it manually to support@amiq.com";
    private static final int SAVE_ZIP_BUTTON = 1024;
    private static final int SEND_BUTTON = 1025;
    private String fSenderInfo;
    private String fCurrentDVTVersion;
    private String fSaveFilesPath;
    private String fEnvMaxSize = null;
    private HashMap<String, Object> fUploadParams = new HashMap();
    private SelectionListener selectAllListener;
    private SelectionListener deselectAllListener;
    private static final String HIDDEN_ENV_TAG = "<<< HIDDEN >>>";
    private static final List<String> OBFUSCATED_ENVS = List.of("ANTHROPIC_API_KEY", "AZURE_OPENAI_API_KEY", "AWS_ACCESS_KEY_ID", "AWS_BEARER_TOKEN_BEDROCK", "AWS_SECRET_ACCESS_KEY", "GOOGLE_AI_API_KEY", "OPENAI_API_KEY");

    public ReportIssueDialog(Shell parent) {
        super(parent);
        this.setShellStyle(1264);
        IS_STARTED = true;
        this.fShell = parent;
        long newSize = 0L;
        this.fEnvMaxSize = System.getenv(DVT_REPORT_ISSUE_MAX_SIZE_MB);
        if (this.fEnvMaxSize != null && !this.fEnvMaxSize.isEmpty()) {
            try {
                newSize = Long.valueOf(this.fEnvMaxSize) * 1024L * 1024L;
            }
            catch (NumberFormatException numberFormatException) {
                newSize = 0x1900000L;
            }
        } else {
            newSize = 0x1900000L;
        }
        this.fAttachedFilesMaxSize = newSize;
        try {
            Job gatherJob = new Job("Collecting System Info"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        boolean result = ReportIssueDialog.this.getSystemInfo(monitor);
                        monitor.done();
                        Status retStatus = result ? new Status(0, "ro.amiq.dvt", "") : new Status(4, "ro.amiq.dvt", "Report Issue could not collect System data.");
                        this.done((IStatus)retStatus);
                        if (!result) {
                            Status status = retStatus;
                            return status;
                        }
                        ReportIssueDialog.this.fShell.getDisplay().asyncExec(() -> {
                            int n = ReportIssueDialog.this.open();
                        });
                        Status status = retStatus;
                        return status;
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                    finally {
                        IS_STARTED = false;
                    }
                    return new Status(0, "ro.amiq.dvt", "");
                }
            };
            gatherJob.setSystem(false);
            gatherJob.setUser(true);
            gatherJob.schedule();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public String hideEnvironmentVariables(String systemSummary) {
        if (systemSummary == null || systemSummary.isEmpty()) {
            return systemSummary;
        }
        String sectionHeaderPrefix = "*** ";
        String systemEnvHeader = String.valueOf(sectionHeaderPrefix) + "System environment variables:";
        if (!systemSummary.contains(systemEnvHeader)) {
            return systemSummary;
        }
        StringBuilder result = new StringBuilder();
        String[] lines = systemSummary.split(System.lineSeparator());
        boolean inEnvSection = false;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if ((line = line.trim()).isEmpty()) {
                result.append(System.lineSeparator());
            } else {
                int equalsIndex;
                String varName;
                if (line.startsWith(sectionHeaderPrefix)) {
                    inEnvSection = false;
                    if (line.startsWith(systemEnvHeader)) {
                        inEnvSection = true;
                    }
                }
                if (inEnvSection && line.contains("=") && OBFUSCATED_ENVS.contains(varName = line.substring(0, equalsIndex = line.indexOf("=")))) {
                    result.append(varName).append("=").append(HIDDEN_ENV_TAG).append(System.lineSeparator());
                } else {
                    result.append(line).append(System.lineSeparator());
                }
            }
            ++n2;
        }
        return result.toString();
    }

    private boolean getSystemInfo(IProgressMonitor monitor) {
        block31: {
            block30: {
                File nodeRuntimeLogFile;
                IAIHostContributor aiHostContributor;
                block29: {
                    File[] hserrFiles;
                    File currentUserDirFolder;
                    String currentUserDir;
                    block28: {
                        block27: {
                            monitor.beginTask("Collecting System Info...", -1);
                            this.fCurrentDVTVersion = DVTPlugin.getDefault().getBundle().getVersion().toString();
                            if (!monitor.isCanceled()) break block27;
                            return false;
                        }
                        String systemInfoContent = this.hideEnvironmentVariables(ConfigurationInfo.getSystemSummary());
                        if (systemInfoContent != null) {
                            this.fFilesToBeZipped.put(ECLIPSE_INFO_FILE_NAME, systemInfoContent);
                        }
                        if (!monitor.isCanceled()) break block28;
                        return false;
                    }
                    String logfilename = Platform.getLogFileLocation().toOSString();
                    File logFile = new File(logfilename);
                    if (logFile.exists()) {
                        this.fFilesToBeZipped.put(ECLIPSE_LOG_FILE_NAME, logFile);
                        File[] bakFilesTmp = logFile.getParentFile().listFiles(new FilenameFilter(){

                            @Override
                            public boolean accept(File dir, String name) {
                                return name.matches("\\.bak_[0-9]+\\.log");
                            }
                        });
                        if (bakFilesTmp != null) {
                            File[] fileArray = bakFilesTmp;
                            int n = bakFilesTmp.length;
                            int n2 = 0;
                            while (n2 < n) {
                                File file = fileArray[n2];
                                this.fFilesToBeZipped.put(file.getName(), file);
                                ++n2;
                            }
                        }
                    }
                    if ((aiHostContributor = AIHostContributorManager.INSTANCE.getAiHostContributor()) != null) {
                        String aiToolsConsoleContents;
                        String aiMainConsoleContents = aiHostContributor.getMainConsoleContent();
                        if (aiMainConsoleContents != null && !aiMainConsoleContents.isEmpty()) {
                            this.fFilesToBeZipped.put(AI_ASSISTANT_LOG_FILE_NAME, aiMainConsoleContents);
                        }
                        if ((aiToolsConsoleContents = aiHostContributor.getAIToolsConsoleContent()) != null && !aiToolsConsoleContents.isEmpty()) {
                            this.fFilesToBeZipped.put(AI_TOOLS_LOG_FILE_NAME, aiToolsConsoleContents);
                        }
                    }
                    if ((currentUserDir = System.getProperty("user.dir")) != null && (currentUserDirFolder = new File(currentUserDir)).exists() && (hserrFiles = currentUserDirFolder.listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name.startsWith("hs_err") && name.endsWith(".log");
                        }
                    })) != null) {
                        File[] fileArray = hserrFiles;
                        int n = hserrFiles.length;
                        int n3 = 0;
                        while (n3 < n) {
                            File hserrFile = fileArray[n3];
                            this.fFilesToBeZipped.put(hserrFile.getName(), hserrFile);
                            ++n3;
                        }
                    }
                    if (aiHostContributor != null) {
                        File mcpLogsDir = aiHostContributor.getMcpLogsDir();
                        List<File> mcpLogFiles = Arrays.asList(mcpLogsDir.listFiles());
                        for (File mcpLogFile : mcpLogFiles) {
                            String mcpLogFileName = mcpLogFile.getName();
                            if (!mcpLogFileName.endsWith(".connector") && !mcpLogFileName.endsWith(".endpoint")) continue;
                            this.fFilesToBeZipped.put(mcpLogFileName, mcpLogFile);
                        }
                    }
                    if (aiHostContributor != null) {
                        File mcpRegistryDir = aiHostContributor.getMcpRegistryDir();
                        List<File> mcpRegistryFiles = Arrays.asList(mcpRegistryDir.listFiles());
                        for (File mcpRegistryFile : mcpRegistryFiles) {
                            this.fFilesToBeZipped.put(mcpRegistryFile.getName(), mcpRegistryFile);
                        }
                    }
                    if (!monitor.isCanceled()) break block29;
                    return false;
                }
                String licenseLog = DFLI.I.l();
                if (licenseLog != null) {
                    this.fFilesToBeZipped.put(LICENSE_LOG_FILE_NAME, licenseLog);
                }
                if (aiHostContributor != null && (nodeRuntimeLogFile = NodeJSManager.INSTANCE.getAndFlushLogFile(aiHostContributor.getNodeRuntimeId())) != null) {
                    this.fFilesToBeZipped.put(AI_NODE_RUNTIME_LOG_FILE_NAME, nodeRuntimeLogFile);
                }
                if (!monitor.isCanceled()) break block30;
                return false;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("== CPU Info ==\n");
            sb.append(DVTProfilingUtils.cpuInfo().trim());
            sb.append("\n\n== Memory Info ==\n");
            sb.append(DVTProfilingUtils.memInfo().trim());
            String hardwareInfoContent = sb.toString();
            this.fFilesToBeZipped.put(HARDWARE_INFO_FILE_NAME, hardwareInfoContent);
            sb.setLength(0);
            sb.append("== OS Info ==\n");
            sb.append(DVTProfilingUtils.sysInfo().trim());
            sb.append("\n\n== dvt_os_information.sh ==");
            sb.append(DVTProfilingUtils.dvtOsInformation().trim());
            sb.append("\n\n== Environment Variables ==\n");
            Map<String, String> unmodifiableEnvMap = System.getenv();
            HashMap<String, String> envMap = new HashMap<String, String>(unmodifiableEnvMap);
            for (String obfucatedEnv : OBFUSCATED_ENVS) {
                if (!envMap.containsKey(obfucatedEnv)) continue;
                envMap.put(obfucatedEnv, HIDDEN_ENV_TAG);
            }
            sb.append("\n\n" + envMap.entrySet().stream().map(e -> String.valueOf((String)e.getKey()) + "=" + (String)e.getValue()).collect(Collectors.joining("\n")));
            this.fFilesToBeZipped.put(OS_INFO_FILE_NAME, sb.toString());
            if (!monitor.isCanceled()) break block31;
            return false;
        }
        try {
            IPath workspaceLocation;
            List<IProject> allProjectsFromWorkspace = TemplatesViewUtils.getAllProjectsFromWorkspace();
            if (allProjectsFromWorkspace != null) {
                for (IProject project : allProjectsFromWorkspace) {
                    File build_log = new File(String.valueOf(project.getLocation().toOSString()) + File.separator + "dvt_build.log");
                    if (build_log.exists()) {
                        this.fFilesToBeZipped.put("Build log (" + project.getName() + ")", build_log);
                    }
                    String projectRoot = project.getLocation().toOSString();
                    File folder = new File(projectRoot);
                    this.getThreadDumpFiles(project, folder, false);
                    File profilingFolder = new File(folder, ThreadDumpCollectorConstants.DEFAULT_OUTPUT_PROJECT_DIR);
                    this.getThreadDumpFiles(project, profilingFolder, true);
                }
            }
            if ((workspaceLocation = ro.amiq.dvt.utils.Utils.getWorkspaceLocation()) != null) {
                File workspaceFolder = new File(workspaceLocation.toOSString());
                workspaceFolder.listFiles((dir, name) -> {
                    this.processThreadDumpFile(null, new File(dir + File.separator + name));
                    return false;
                });
            }
            return true;
        }
        catch (Exception e2) {
            DVTLogger.INSTANCE.logError((Throwable)e2);
            return false;
        }
    }

    private void getThreadDumpFiles(IProject project, File folder, boolean exploreEntireFolder) {
        File[] resources = folder.listFiles();
        if (resources == null) {
            return;
        }
        File[] fileArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            File resource = fileArray[n2];
            if (resource.isFile()) {
                this.processThreadDumpFile(project, resource);
            } else if (exploreEntireFolder && resource.isDirectory()) {
                this.getThreadDumpFiles(project, resource, true);
            }
            ++n2;
        }
    }

    private void processThreadDumpFile(IProject project, File file) {
        String name = file.getName();
        String dir = file.getParent();
        if (name.startsWith("incremental") && name.contains("delta_info")) {
            int start = "incremental".length() + 1;
            String timestamp = name.substring(start, name.indexOf(THREAD_DUMP_SEGMENT_SEPARATOR, start));
            String projectInfo = project != null ? " (" + project.getName() + ")" : "";
            this.fFilesToBeZipped.put("Incremental Delta Info " + timestamp + projectInfo, new File(dir, name));
            return;
        }
        if (name.endsWith(".thread_dump.zip")) {
            int numberOfSegments = name.length() - name.replace(THREAD_DUMP_SEGMENT_SEPARATOR, "").length();
            String threadDumpType = "";
            String timestamp = "";
            if (numberOfSegments >= 4) {
                int threadDumpTypeStartIndex = 0;
                threadDumpTypeStartIndex = name.indexOf(THREAD_DUMP_SEGMENT_SEPARATOR);
                threadDumpType = name.substring(0, threadDumpTypeStartIndex);
                threadDumpType = String.valueOf(threadDumpType.substring(0, 1).toUpperCase()) + threadDumpType.substring(1);
                timestamp = name.substring(threadDumpTypeStartIndex + 1, name.indexOf(THREAD_DUMP_SEGMENT_SEPARATOR, threadDumpTypeStartIndex + 1));
            } else {
                timestamp = name.substring(0, name.indexOf(THREAD_DUMP_SEGMENT_SEPARATOR));
            }
            String projectInfo = project != null ? " (" + project.getName() + ")" : "";
            this.fFilesToBeZipped.put(String.valueOf(threadDumpType) + " Thread dump " + timestamp + projectInfo, new File(dir, name));
            return;
        }
        if (name.startsWith("parser_") && name.endsWith(".thread_dump.zip")) {
            String timestamp = name.substring(name.lastIndexOf(95) + 1, name.indexOf(THREAD_DUMP_SEGMENT_SEPARATOR));
            String projectInfo = project != null ? " (" + project.getName() + ")" : "";
            this.fFilesToBeZipped.put("Parse Profiling Thread dump " + timestamp + projectInfo, new File(String.valueOf(dir) + File.separator + name));
            return;
        }
        if (name.startsWith("dvt_heap_histo_") && name.endsWith(".zip")) {
            String filestamp = name.substring(15, name.lastIndexOf(THREAD_DUMP_SEGMENT_SEPARATOR));
            String projectInfo = project != null ? " (" + project.getName() + ")" : "";
            this.fFilesToBeZipped.put("Heap histogram " + filestamp + projectInfo, new File(dir, name));
            return;
        }
        if (name.startsWith("incremental_dvt_stats")) {
            String projectInfo = project != null ? " (" + project.getName() + ")" : "";
            this.fFilesToBeZipped.put("Incremental Stats" + projectInfo, new File(dir, name));
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(REPORT_AN_ISSUE_IN_DVT);
        shell.setImage(DVTImages.imageCache.getImage(DVTImages.REPORT_ISSUE_IMAGE));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
        this.createButton(parent, 1025, "Send", true).setEnabled(false);
        this.createButton(parent, 1024, "Save as Zip", true).setEnabled(false);
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        Calendar calendar = Calendar.getInstance();
        String date = String.valueOf(calendar.get(1)) + "_" + (calendar.get(2) + 1) + "_" + calendar.get(5) + "_" + calendar.get(11) + "-" + calendar.get(12);
        this.fSaveFilesPath = String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + DVT_ZIP_FILE_NAME + date + ".zip";
        if (buttonId == 1025) {
            MessageDialog messageDialog = new MessageDialog(this.fShell, REPORT_AN_ISSUE_IN_DVT, DVTImages.imageCache.getImage(DVTImages.REPORT_ISSUE_IMAGE), "In order to send the Issue Report, DVT will connect to Internet.\nDo you want to proceed?", 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
            if (messageDialog.open() == 0) {
                this.createZipArchive(this.fFilesToBeZipped, this.fSaveFilesPath);
                this.saveHistory();
                this.uploadFile(this.fSaveFilesPath);
                return;
            }
        } else if (buttonId == 1024) {
            String filterPath = DVTFileUtils.getInstance().getLastDirectory();
            FileDialog fileDialog = new FileDialog(this.fShell, 8192);
            fileDialog.setFilterPath(filterPath);
            fileDialog.setText("Save Zip File");
            String[] fFilterExt = new String[]{"*.zip"};
            fileDialog.setFileName(DVT_ZIP_FILE_NAME + date + ".zip");
            fileDialog.setFilterExtensions(fFilterExt);
            String selectedFile = fileDialog.open();
            if (selectedFile == null) {
                return;
            }
            this.fSaveFilesPath = selectedFile;
            DVTFileUtils.getInstance().setLastDirectory(new File(selectedFile).getPath());
            this.createZipArchive(this.fFilesToBeZipped, this.fSaveFilesPath);
            this.saveHistory();
            this.close();
        }
    }

    private void uploadFile(String fileName) {
        String emailSenderText = this.fEmailText.getText().trim();
        String emailSubjectText = "DVT Issue Report - " + this.fSummaryText.getText().trim() + " (" + this.fNameText.getText().trim() + " - " + this.fCompanyText.getText().trim() + ")";
        Calendar cal = Calendar.getInstance();
        String date = String.valueOf(cal.get(5)) + "-" + (cal.get(2) + 1) + "-" + cal.get(1);
        String emailText = String.valueOf(this.fInfoText.getText().trim()) + "\n\n" + date + "\n\n=== DVT-Version ===\n" + this.fCurrentDVTVersion + "\n";
        File attachmentFile = new File(fileName);
        String emailCompanyText = this.fCompanyText.getText().trim();
        this.fUploadParams.put(INTERNAL_VALIDATION_FIELD, INTERNAL_VALIDATION_TEXT);
        this.fUploadParams.put(EMAIL_SENDER_FIELD, emailSenderText);
        this.fUploadParams.put(EMAIL_SUBJECT_FIELD, emailSubjectText);
        this.fUploadParams.put(EMAIL_TEXT_FIELD, emailText);
        this.fUploadParams.put(EMAIL_ATTACHMENT_FIELD, attachmentFile);
        this.fUploadParams.put(EMAIL_COMPANY_FIELD, emailCompanyText);
        this.fUploadParams.put(DVT_VERSION_FIELD, this.fCurrentDVTVersion);
        Job sendJob = new Job("Sending DVT Issue Report..."){

            protected IStatus run(IProgressMonitor monitor) {
                Status status;
                block9: {
                    HttpUploaderResult ans;
                    boolean successfullUpload;
                    block7: {
                        IStatus iStatus;
                        block8: {
                            block5: {
                                Status status2;
                                block6: {
                                    successfullUpload = false;
                                    try {
                                        ans = new HttpUploaderMonitor(ReportIssueDialog.UPLOAD_FILES_URL, ReportIssueDialog.this.fUploadParams, monitor).upload();
                                        monitor.done();
                                        if (ans != null) break block5;
                                        status2 = new Status(4, "ro.amiq.dvt", "Error while sending the issue report!");
                                        if (successfullUpload) break block6;
                                    }
                                    catch (Throwable throwable) {
                                        if (!successfullUpload) {
                                            Display.getDefault().asyncExec(() -> {
                                                Utils.setEnabledRecursive((Composite)ReportIssueDialog.this.getShell(), true);
                                                ReportIssueDialog.this.setMessage(ReportIssueDialog.DEFAULT_SUB_TITLE_MESSAGE, 1);
                                            });
                                        }
                                        throw throwable;
                                    }
                                    Display.getDefault().asyncExec(() -> {
                                        Utils.setEnabledRecursive((Composite)ReportIssueDialog.this.getShell(), true);
                                        ReportIssueDialog.this.setMessage(ReportIssueDialog.DEFAULT_SUB_TITLE_MESSAGE, 1);
                                    });
                                }
                                return status2;
                            }
                            boolean success = ans.getSuccess();
                            if (!success) break block7;
                            Display.getDefault().asyncExec(() -> {
                                SmartCopyUtils.updateStatusBarWithInfo("DVT Issue Report has been delivered!");
                                ReportIssueDialog.this.close();
                            });
                            successfullUpload = true;
                            iStatus = Status.OK_STATUS;
                            if (successfullUpload) break block8;
                            Display.getDefault().asyncExec(() -> {
                                Utils.setEnabledRecursive((Composite)ReportIssueDialog.this.getShell(), true);
                                ReportIssueDialog.this.setMessage(ReportIssueDialog.DEFAULT_SUB_TITLE_MESSAGE, 1);
                            });
                        }
                        return iStatus;
                    }
                    status = new Status(4, "ro.amiq.dvt", ans.getMessage());
                    if (successfullUpload) break block9;
                    Display.getDefault().asyncExec(() -> {
                        Utils.setEnabledRecursive((Composite)ReportIssueDialog.this.getShell(), true);
                        ReportIssueDialog.this.setMessage(ReportIssueDialog.DEFAULT_SUB_TITLE_MESSAGE, 1);
                    });
                }
                return status;
            }
        };
        Utils.setEnabledRecursive((Composite)this.getShell(), false);
        this.setMessage("Sending DVT Issue Report...", 1);
        sendJob.setSystem(false);
        sendJob.setUser(true);
        sendJob.schedule();
    }

    protected boolean isResizable() {
        return true;
    }

    private void updateSizeLabel() {
        if (!this.isAttachedFilesSizeOK()) {
            DVTColorUtil.INSTANCE.setForeground((Control)this.fAttachInfoLabel, PlatformUI.getWorkbench().getDisplay().getSystemColor(3), true);
            this.fAttachInfoLabel.setText("The total size of the attachments is " + this.getAttachedFilesSize() + ". Reduce the size down to " + this.fAttachedFilesMaxSize / 0x100000L + " MB, to enable the transfer over email!");
        } else {
            DVTColorUtil.INSTANCE.setForeground((Control)this.fAttachInfoLabel, DVTColorUtil.INSTANCE.getDefaultForeground((Control)this.fAttachInfoLabel), true);
            this.fAttachInfoLabel.setText("The total size of the attachments is " + this.getAttachedFilesSize() + THREAD_DUMP_SEGMENT_SEPARATOR);
        }
        this.validateFields();
        this.fAttachInfoLabel.requestLayout();
    }

    private boolean isAttachedFilesSizeOK() {
        return this.getAttachedFilesSizeInBytes() <= this.fAttachedFilesMaxSize;
    }

    public void create() {
        super.create();
        this.setMessage(DEFAULT_SUB_TITLE_MESSAGE, 1);
        this.updateSizeLabel();
        this.setTitleImage(DVTImages.imageCache.getImage(DVTImages.REPORT_ISSUE_TITLE));
        this.setTitle("Fill in your contact information, issue details and attach the relevant files.");
        Rectangle screenSize = this.getShell().getDisplay().getPrimaryMonitor().getBounds();
        this.getShell().setLocation((screenSize.width - this.getShell().getBounds().width) / 2, (screenSize.height - this.getShell().getBounds().height) / 2);
        this.getShell().layout();
    }

    protected Control createDialogArea(final Composite parent) {
        Control container = super.createDialogArea(parent);
        Composite composite = new Composite((Composite)container, 0);
        GridData gd = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gd);
        composite.setLayout((Layout)new GridLayout(2, true));
        Group detailsGroup = new Group(composite, 2048);
        detailsGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        detailsGroup.setLayout((Layout)new GridLayout(2, false));
        detailsGroup.setText("User Details");
        Label nameLabel = new Label((Composite)detailsGroup, 0);
        nameLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        nameLabel.setText("Name: ");
        this.fNameText = new Text((Composite)detailsGroup, 2048);
        this.fNameText.setEditable(true);
        this.fNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fNameText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                ReportIssueDialog.this.validateFields();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        Label companyLabel = new Label((Composite)detailsGroup, 0);
        companyLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        companyLabel.setText("Company: ");
        this.fCompanyText = new Text((Composite)detailsGroup, 2048);
        this.fCompanyText.setEditable(true);
        this.fCompanyText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fCompanyText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                ReportIssueDialog.this.validateFields();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        Label emailLabel = new Label((Composite)detailsGroup, 0);
        emailLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        emailLabel.setText("E-mail: ");
        this.fEmailText = new Text((Composite)detailsGroup, 2048);
        this.fEmailText.setEditable(true);
        this.fEmailText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fEmailText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                ReportIssueDialog.this.validateFields();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        Group attachGroup = new Group(composite, 2048);
        attachGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        attachGroup.setLayout((Layout)new GridLayout(2, false));
        attachGroup.setText("Attachments");
        this.fTableViewer = new CheckboxTableViewer(new Table((Composite)attachGroup, 68386));
        GridDataFactory.fillDefaults().hint(-1, 485).grab(true, true).align(4, 4).applyTo(this.fTableViewer.getControl());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.fTableViewer);
        this.fTableViewer.getTable().setHeaderVisible(true);
        this.fTableViewer.getTable().setLinesVisible(true);
        TableViewerColumn checkColumn = new TableViewerColumn(this.fTableViewer, 0x1000000);
        checkColumn.getColumn().setWidth(25);
        checkColumn.getColumn().setResizable(false);
        TableViewerColumn fileNameColumn = new TableViewerColumn(this.fTableViewer, 0);
        fileNameColumn.getColumn().setText("File Name");
        fileNameColumn.getColumn().setWidth(400);
        TableViewerColumn sizeColumn = new TableViewerColumn(this.fTableViewer, 0x1000000);
        sizeColumn.getColumn().setText("Size");
        sizeColumn.getColumn().setWidth(80);
        TableViewerColumn actionColumn = new TableViewerColumn(this.fTableViewer, 0x1000000);
        actionColumn.getColumn().setText("");
        actionColumn.getColumn().setWidth(20);
        this.fTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                ArrayList<String> filesToBeZippedSorted = new ArrayList<String>();
                Set<String> fFilesToBeZippedKeySet = ReportIssueDialog.this.fFilesToBeZipped.keySet();
                if (fFilesToBeZippedKeySet.contains(ReportIssueDialog.ECLIPSE_LOG_FILE_NAME)) {
                    filesToBeZippedSorted.add(ReportIssueDialog.ECLIPSE_LOG_FILE_NAME);
                }
                for (String file : fFilesToBeZippedKeySet) {
                    if (!file.startsWith(".bak")) continue;
                    filesToBeZippedSorted.add(file);
                }
                Collections.sort(filesToBeZippedSorted.subList(1, filesToBeZippedSorted.size()));
                if (fFilesToBeZippedKeySet.contains(ReportIssueDialog.ECLIPSE_INFO_FILE_NAME)) {
                    filesToBeZippedSorted.add(ReportIssueDialog.ECLIPSE_INFO_FILE_NAME);
                }
                if (fFilesToBeZippedKeySet.contains(ReportIssueDialog.LICENSE_LOG_FILE_NAME)) {
                    filesToBeZippedSorted.add(ReportIssueDialog.LICENSE_LOG_FILE_NAME);
                }
                if (fFilesToBeZippedKeySet.contains(ReportIssueDialog.HARDWARE_INFO_FILE_NAME)) {
                    filesToBeZippedSorted.add(ReportIssueDialog.HARDWARE_INFO_FILE_NAME);
                }
                if (fFilesToBeZippedKeySet.contains(ReportIssueDialog.OS_INFO_FILE_NAME)) {
                    filesToBeZippedSorted.add(ReportIssueDialog.OS_INFO_FILE_NAME);
                }
                if (fFilesToBeZippedKeySet.contains(ReportIssueDialog.AI_ASSISTANT_LOG_FILE_NAME)) {
                    filesToBeZippedSorted.add(ReportIssueDialog.AI_ASSISTANT_LOG_FILE_NAME);
                }
                if (fFilesToBeZippedKeySet.contains(ReportIssueDialog.AI_TOOLS_LOG_FILE_NAME)) {
                    filesToBeZippedSorted.add(ReportIssueDialog.AI_TOOLS_LOG_FILE_NAME);
                }
                if (fFilesToBeZippedKeySet.contains(ReportIssueDialog.AI_NODE_RUNTIME_LOG_FILE_NAME)) {
                    filesToBeZippedSorted.add(ReportIssueDialog.AI_NODE_RUNTIME_LOG_FILE_NAME);
                }
                for (String file : fFilesToBeZippedKeySet) {
                    if (!file.startsWith("Build log")) continue;
                    filesToBeZippedSorted.add(file);
                }
                for (String file : fFilesToBeZippedKeySet) {
                    if (!file.startsWith("Thread dump")) continue;
                    filesToBeZippedSorted.add(file);
                }
                for (String file : fFilesToBeZippedKeySet) {
                    if (!file.startsWith("hs_err")) continue;
                    filesToBeZippedSorted.add(file);
                }
                for (String file : fFilesToBeZippedKeySet) {
                    if (filesToBeZippedSorted.contains(file)) continue;
                    filesToBeZippedSorted.add(file);
                }
                return filesToBeZippedSorted.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }
        });
        fileNameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof String)) {
                    return null;
                }
                if (ReportIssueDialog.ECLIPSE_LOG_FILE_NAME.equals(element)) {
                    return "Eclipse log";
                }
                if (ReportIssueDialog.ECLIPSE_INFO_FILE_NAME.equals(element)) {
                    return "Eclipse info";
                }
                if (ReportIssueDialog.LICENSE_LOG_FILE_NAME.equals(element)) {
                    return "License log";
                }
                if (ReportIssueDialog.HARDWARE_INFO_FILE_NAME.equals(element)) {
                    return "Hardware info";
                }
                if (ReportIssueDialog.OS_INFO_FILE_NAME.equals(element)) {
                    return "OS info";
                }
                if (ReportIssueDialog.AI_ASSISTANT_LOG_FILE_NAME.equals(element)) {
                    return "AI Assistant log";
                }
                if (ReportIssueDialog.AI_TOOLS_LOG_FILE_NAME.equals(element)) {
                    return "AI Tools log";
                }
                if (ReportIssueDialog.AI_NODE_RUNTIME_LOG_FILE_NAME.equals(element)) {
                    return "AI Assistant Node Runtime log";
                }
                if (((String)element).contains(".bak_")) {
                    return "Eclipse log (" + ((String)element).subSequence(5, 6) + ")";
                }
                return (String)element;
            }

            public String getToolTipText(Object element) {
                Object file = ReportIssueDialog.this.fFilesToBeZipped.get(element);
                if (file instanceof File) {
                    return ((File)file).getAbsolutePath();
                }
                return null;
            }
        });
        sizeColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                try {
                    Object content = ReportIssueDialog.this.fFilesToBeZipped.get(element);
                    if (content instanceof File) {
                        return ReportIssueDialog.this.getFileSize((File)content);
                    }
                    if (content instanceof String) {
                        return ReportIssueDialog.this.formatFileSize(((String)content).getBytes(StandardCharsets.UTF_8).length);
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
                return null;
            }
        });
        actionColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return "";
            }

            public Image getImage(Object element) {
                return DVTImages.imageCache.getImage(DVTImages.IMG_PREVIEW);
            }
        });
        this.fTableViewer.getTable().addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Point point = new Point(event.x, event.y);
                ViewerCell cell = ReportIssueDialog.this.fTableViewer.getCell(point);
                if (cell == null) {
                    return;
                }
                if (cell.getImage() == null) {
                    return;
                }
                Object element = cell.getElement();
                if (!(element instanceof String)) {
                    return;
                }
                Object content = ReportIssueDialog.this.fFilesToBeZipped.get(element);
                if (content instanceof File) {
                    if (((File)content).getName().endsWith(".zip")) {
                        DVTFileUtils.getInstance().openZipFile((File)content);
                    } else {
                        DVTFileUtils.getInstance().openFile((File)content);
                    }
                } else if (content instanceof String) {
                    StringEditorUtils.INSTANCE.openString((String)element, (String)content);
                }
            }
        });
        this.fTableViewer.getTable().addListener(8, new Listener(){

            public void handleEvent(Event event) {
                Point point = new Point(event.x, event.y);
                ViewerCell cell = ReportIssueDialog.this.fTableViewer.getCell(point);
                if (cell == null) {
                    return;
                }
                Object element = cell.getElement();
                if (!(element instanceof String)) {
                    return;
                }
                Object content = ReportIssueDialog.this.fFilesToBeZipped.get(element);
                if (content instanceof File) {
                    if (((File)content).getName().endsWith(".zip")) {
                        DVTFileUtils.getInstance().openZipFile((File)content);
                    } else {
                        DVTFileUtils.getInstance().openFile((File)content);
                    }
                } else if (content instanceof String) {
                    StringEditorUtils.INSTANCE.openString((String)element, (String)content);
                }
            }
        });
        this.fTableViewer.setInput(this.fFilesToBeZipped);
        this.fAttachFilesComposite = new Composite((Composite)attachGroup, 0);
        this.fAttachFilesComposite.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.fAttachFilesComposite.setLayout((Layout)layout);
        this.fAttachInfoLabel = new Label(this.fAttachFilesComposite, 64);
        this.fAttachInfoLabel.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Composite attachFilesButtonsGroup = new Composite(this.fAttachFilesComposite, 64);
        attachFilesButtonsGroup.setLayout((Layout)new GridLayout(3, false));
        this.fSelectAllButton = new Button(attachFilesButtonsGroup, 8);
        this.fSelectAllButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.fSelectAllButton.setText("Select All");
        this.selectAllListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ReportIssueDialog.this.fTableViewer.refresh();
                ((CheckboxTableViewer)ReportIssueDialog.this.fTableViewer).setCheckedElements(ReportIssueDialog.this.fFilesToBeZipped.keySet().toArray());
                ReportIssueDialog.this.fTableViewer.refresh();
                ReportIssueDialog.this.updateSizeLabel();
            }
        };
        this.fSelectAllButton.addSelectionListener(this.selectAllListener);
        this.fDeselectAllButton = new Button(attachFilesButtonsGroup, 8);
        this.fDeselectAllButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.fDeselectAllButton.setText("Deselect All");
        this.deselectAllListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ReportIssueDialog.this.fTableViewer.refresh();
                for (String file : ReportIssueDialog.this.fFilesToBeZipped.keySet()) {
                    ((CheckboxTableViewer)ReportIssueDialog.this.fTableViewer).setChecked((Object)file, false);
                }
                ReportIssueDialog.this.fTableViewer.refresh();
                ReportIssueDialog.this.updateSizeLabel();
            }
        };
        this.fDeselectAllButton.addSelectionListener(this.deselectAllListener);
        this.fAddFileButton = new Button(attachFilesButtonsGroup, 8);
        this.fAddFileButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.fAddFileButton.setText("Add...");
        this.fAddFileButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String fFilterPath = DVTFileUtils.getInstance().getLastDirectory();
                FileDialog fFileDialog = new FileDialog(parent.getShell(), 4096);
                fFileDialog.setFilterPath(fFilterPath);
                fFileDialog.setText("Open File");
                String selectedFilePath = fFileDialog.open();
                if (selectedFilePath == null || selectedFilePath.isEmpty()) {
                    return;
                }
                File selectedFile = new File(selectedFilePath);
                if (selectedFile != null && !ReportIssueDialog.this.fFilesToBeZipped.containsValue(selectedFile)) {
                    ReportIssueDialog.this.fFilesToBeZipped.put("attachments/" + selectedFile.getName(), selectedFile);
                    DVTFileUtils.getInstance().setLastDirectory(selectedFile.getPath());
                    ReportIssueDialog.this.fTableViewer.refresh();
                    ((CheckboxTableViewer)ReportIssueDialog.this.fTableViewer).setChecked((Object)("attachments/" + selectedFile.getName()), true);
                    ReportIssueDialog.this.updateSizeLabel();
                    ReportIssueDialog.this.fTableViewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        ((CheckboxTableViewer)this.fTableViewer).addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ReportIssueDialog.this.updateSizeLabel();
            }
        });
        Group infoTextGroup = new Group(composite, 2048);
        infoTextGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        infoTextGroup.setLayout((Layout)new GridLayout(2, false));
        infoTextGroup.setText("Issue Description");
        Label summaryLabel = new Label((Composite)infoTextGroup, 0);
        summaryLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        summaryLabel.setText("Summary: ");
        this.fSummaryText = new Text((Composite)infoTextGroup, 2048);
        this.fSummaryText.setEditable(true);
        this.fSummaryText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fSummaryText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                ReportIssueDialog.this.validateFields();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.fInfoText = new Text((Composite)infoTextGroup, 2624);
        this.fInfoText.setEditable(true);
        this.fInfoText.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.fInfoText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                ReportIssueDialog.this.validateFields();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        composite.setTabList(new Control[]{detailsGroup, infoTextGroup, attachGroup});
        this.loadHistory();
        this.fTableViewer.refresh();
        ((CheckboxTableViewer)this.fTableViewer).setCheckedElements(this.fFilesToBeZipped.keySet().toArray());
        this.fTableViewer.refresh();
        return container;
    }

    private void createZipArchive(Map<String, Object> files, String destinationFile) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ZipOutputStream zipOS = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(destinationFile)));){
                if (this.fSenderInfo != null && !this.fSenderInfo.isEmpty()) {
                    this.writeZipEntry(zipOS, ISSUE_REPORT_FILE_NAME, new ByteArrayInputStream(this.fSenderInfo.getBytes(StandardCharsets.UTF_8)));
                }
                for (Map.Entry<String, Object> file : files.entrySet()) {
                    String filename = file.getKey();
                    if (!((CheckboxTableViewer)this.fTableViewer).getChecked((Object)filename)) continue;
                    Object value = file.getValue();
                    if (value instanceof String) {
                        this.writeZipEntry(zipOS, filename, new ByteArrayInputStream(((String)value).getBytes(StandardCharsets.UTF_8)));
                        continue;
                    }
                    if (!(value instanceof File) || !((File)value).exists()) continue;
                    this.writeZipEntry(zipOS, filename, new BufferedInputStream(new FileInputStream(((File)value).getAbsolutePath())));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void writeZipEntry(ZipOutputStream zipOS, String filename, InputStream is) {
        byte[] fBuffer = new byte[1024];
        try {
            int len;
            zipOS.putNextEntry(new ZipEntry(filename));
            while ((len = is.read(fBuffer)) > 0) {
                zipOS.write(fBuffer, 0, len);
            }
            zipOS.closeEntry();
            is.close();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private boolean validateFields() {
        if (this.fNameText.getText().isEmpty()) {
            this.setMessage("User Name field must not be empty!", 3);
            this.getButton(1025).setEnabled(false);
            this.getButton(1024).setEnabled(false);
            return false;
        }
        if (this.fCompanyText.getText().isEmpty()) {
            this.setMessage("Company's name field must not be empty!", 3);
            this.getButton(1025).setEnabled(false);
            this.getButton(1024).setEnabled(false);
            return false;
        }
        if (this.fEmailText.getText().length() < 3 || !this.fEmailText.getText().matches("^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,63}$")) {
            this.setMessage("You must specify a valid e-mail address!", 3);
            this.getButton(1025).setEnabled(false);
            this.getButton(1024).setEnabled(false);
            return false;
        }
        if (this.fSummaryText.getText().isEmpty()) {
            this.setMessage("Summary field must not be empty!", 3);
            this.getButton(1025).setEnabled(false);
            this.getButton(1024).setEnabled(false);
            return false;
        }
        Calendar cal = Calendar.getInstance();
        String date = String.valueOf(cal.get(5)) + "-" + (cal.get(2) + 1) + "-" + cal.get(1);
        this.fSenderInfo = "Name: " + this.fNameText.getText() + " \nCompany: " + this.fCompanyText.getText() + " \nEmail: " + this.fEmailText.getText() + "\n\nDate:" + date + "\n\nDVT Version: " + this.fCurrentDVTVersion + " \n\nDescription:\n\n" + this.fInfoText.getText();
        if (!this.isAttachedFilesSizeOK()) {
            this.setMessage("The attachments cannot be sent over Email!", 2);
            this.getButton(1025).setEnabled(false);
            this.getButton(1024).setEnabled(true);
            return false;
        }
        if (this.fInfoText.getText().isEmpty()) {
            this.setMessage("Issue Description field is empty!", 2);
        } else {
            this.setMessage(DEFAULT_SUB_TITLE_MESSAGE, 1);
        }
        this.getButton(1025).setEnabled(true);
        this.getButton(1024).setEnabled(true);
        return true;
    }

    private String getFileSize(File file) {
        long currentSize = 0L;
        currentSize = this.getFileSizeInBytes(file);
        return this.formatFileSize(currentSize);
    }

    private String getAttachedFilesSize() {
        long currentSize = 0L;
        currentSize = this.getAttachedFilesSizeInBytes();
        return this.formatFileSize(currentSize);
    }

    private String formatFileSize(long currentSize) {
        if (currentSize < 1024L) {
            return String.valueOf(new DecimalFormat("##,####.##").format(currentSize)) + " B";
        }
        if (currentSize < 0x100000L) {
            return String.valueOf(new DecimalFormat("##,####.##").format(currentSize / 1024L)) + " KB";
        }
        return String.valueOf(new DecimalFormat("##,####.##").format(currentSize / 0x100000L)) + " MB";
    }

    private long getFileSizeInBytes(File file) {
        return file.length();
    }

    private long getAttachedFilesSizeInBytes() {
        long currentSize = 0L;
        for (Map.Entry<String, Object> file : this.fFilesToBeZipped.entrySet()) {
            if (!((CheckboxTableViewer)this.fTableViewer).getChecked((Object)file.getKey())) continue;
            Object content = file.getValue();
            if (content instanceof File) {
                currentSize += ((File)content).length();
                continue;
            }
            if (!(content instanceof String)) continue;
            currentSize += (long)((String)content).length();
        }
        return currentSize;
    }

    private void loadHistory() {
        String workspacePath = Platform.getLocation().toOSString();
        XMLParser parser = new XMLParser("attributes");
        try {
            File src = new File(String.valueOf(workspacePath) + File.separator + "reportissue-history.xml");
            parser.load(src.getAbsolutePath());
            if (this.fNameText != null) {
                this.fNameText.setText(parser.get("name"));
            }
            if (this.fEmailText != null) {
                this.fEmailText.setText(parser.get("email"));
            }
            if (this.fCompanyText != null) {
                this.fCompanyText.setText(parser.get(EMAIL_COMPANY_FIELD));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void saveHistory() {
        String workspacePath = Platform.getLocation().toOSString();
        XMLParser parser = new XMLParser("attributes");
        if (this.fEmailText != null) {
            parser.put("email", this.fEmailText.getText());
        }
        if (this.fNameText != null) {
            parser.put("name", this.fNameText.getText());
        }
        if (this.fCompanyText != null) {
            parser.put(EMAIL_COMPANY_FIELD, this.fCompanyText.getText());
        }
        try {
            File dest = new File(String.valueOf(workspacePath) + File.separator + "reportissue-history.xml");
            if (!dest.exists()) {
                dest.createNewFile();
            }
            parser.save(dest.getAbsolutePath());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public boolean close() {
        IS_STARTED = false;
        this.fSelectAllButton.removeSelectionListener(this.selectAllListener);
        this.fSelectAllButton.dispose();
        this.fDeselectAllButton.removeSelectionListener(this.deselectAllListener);
        this.fDeselectAllButton.dispose();
        return super.close();
    }

    public int open() {
        IS_STARTED = true;
        return super.open();
    }
}

