/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.search;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.FileTextSearchScope;
import ro.amiq.dvt.model.reflection.util.RfGUISearchUtils;
import ro.amiq.dvt.ui.search.BaseFileSearchQuery;
import ro.amiq.dvt.ui.search.BaseFileSearchResult;
import ro.amiq.dvt.ui.search.BaseTextSearchQuery;
import ro.amiq.dvt.ui.search.text.BaseTextSearchResultCollector;
import ro.amiq.dvt.ui.search.ui.SearchMessages;
import ro.amiq.dvt.utils.DVTStringUtil;

public class AggregateSearchQuery
extends BaseTextSearchQuery {
    private static final String AGGREGATED_SEARCH_LABEL = "Aggregated search";
    private ArrayList<BaseFileSearchQuery> fQueries = new ArrayList();
    private BaseTextSearchResultCollector fCollector;
    private IProject project;

    public AggregateSearchQuery(FileTextSearchScope scope, String searchLabel, IProject project) {
        super(scope, searchLabel);
        this.project = project;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        AbstractTextSearchResult textResult = (AbstractTextSearchResult)this.getSearchResult();
        textResult.removeAll();
        for (BaseFileSearchQuery query : this.fQueries) {
            query.setSearchResult((BaseFileSearchResult)this.getSearchResult());
            query.setAccumulateResults(true);
            IStatus resultStatus = query.run(monitor, this.fCollector);
            if (resultStatus.getCode() == 0) continue;
            return resultStatus;
        }
        return Status.OK_STATUS;
    }

    @Override
    public String getSearchType() {
        return AGGREGATED_SEARCH_LABEL;
    }

    public void addQuery(BaseFileSearchQuery query) {
        this.fQueries.add(query);
    }

    @Override
    public boolean isFileNameSearch() {
        return false;
    }

    @Override
    protected BaseFileSearchResult makeFileSearchResult(BaseTextSearchQuery query) {
        return RfGUISearchUtils.getResult(query, this.project);
    }

    @Override
    public String getResultLabel(int nMatches) {
        String searchString = this.getSearchLabel();
        String searchType = this.getSearchType();
        if (searchString.length() > 0) {
            String description = DVTStringUtil.removeTicks(this.getScope().getDescription());
            if (nMatches == 1) {
                Object[] args = new Object[]{searchType, searchString, "", description};
                return MessageFormat.format(SearchMessages.ReferenceSearchQuery_singularLabel, args);
            }
            Object[] args = new Object[]{searchType, searchString, nMatches, "", description};
            return MessageFormat.format(SearchMessages.ReferenceSearchQuery_pluralPattern, args);
        }
        return "";
    }
}

