/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.search;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import ro.amiq.dvt.model.DVTMixedLangModelManager;
import ro.amiq.dvt.model.IBuildDoneListener;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.search.BaseSearchQuery;

public abstract class BaseConstraintsSearchQuery
extends BaseSearchQuery
implements IBuildDoneListener {
    private RfElementPath fRfElementPath;
    private IRfNamedElement fCachedElement;
    private AbstractTextSearchResult fSearchResult;
    private IRfSingleLangProject fRfProject;
    private IProject fProject;
    private IProgressMonitor fMonitor;
    private Class<?> fFieldClass;
    private boolean fProjectRebuilt;
    protected ParserPath fCurrentParserPath;

    public BaseConstraintsSearchQuery(IRfNamedElement element) {
        this.fCachedElement = element;
        this.fRfElementPath = RfElementPath.path(element);
        this.fFieldClass = element.getClass();
        this.fRfProject = element.getRfProject();
        this.fProject = this.fRfProject.getProject();
        this.fSearchResult = this.makeSearchResult();
        DVTMixedLangModelManager.getInstance().addBuildDoneListener(this);
        this.fCurrentParserPath = null;
    }

    public IStatus run(IProgressMonitor monitor) {
        try {
            this.clean();
            int monitorTicks = this.computeMonitorTicks();
            if (this.useScaledMonitor()) {
                this.fMonitor = new ScaledSubProgressMonitor(monitor, monitorTicks);
                monitor.beginTask("Searching constraints", 100);
                this.fMonitor.beginTask("Searching constraints", 100);
            } else {
                this.fMonitor = new SubProgressMonitor(monitor, monitorTicks);
                monitor.beginTask("Searching constraints", monitorTicks);
                this.fMonitor.beginTask("Searching constraints", monitorTicks);
            }
            Object field = this.getField();
            if (field == null) {
                this.fMonitor.done();
                return Status.OK_STATUS;
            }
            this.computeMatches();
            this.fMonitor.done();
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return Status.CANCEL_STATUS;
        }
    }

    private void clean() {
        this.fSearchResult.removeAll();
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public AbstractTextSearchResult getSearchResult() {
        return this.fSearchResult;
    }

    public IProject getProject() {
        return this.fProject;
    }

    protected <T extends IRfSingleLangProject> T getRfProject() {
        return (T)this.fRfProject;
    }

    protected <T extends IRfNamedElement> T getField() {
        if (!this.fProjectRebuilt) {
            return (T)this.fCachedElement;
        }
        this.fCachedElement = this.fRfElementPath.toNamedElement(this.fProject);
        if (this.fCachedElement == null) {
            return null;
        }
        if (this.fCachedElement.getClass() != this.fFieldClass) {
            return null;
        }
        this.fProjectRebuilt = false;
        return (T)this.fCachedElement;
    }

    public String getLabel() {
        String fieldNameForLabel = this.getFieldNameForLabel();
        if (fieldNameForLabel == null && this.fRfElementPath != null) {
            fieldNameForLabel = this.fRfElementPath.getElementName();
        }
        if (fieldNameForLabel == null) {
            fieldNameForLabel = "";
        }
        return "[".concat(this.fProject.getName()).concat("]").concat(" Constraints of ").concat(fieldNameForLabel);
    }

    public IProgressMonitor getMonitor() {
        return this.fMonitor;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.fMonitor = monitor;
    }

    protected abstract String getFieldNameForLabel();

    protected abstract void computeMatches();

    protected abstract int computeMonitorTicks();

    protected abstract AbstractTextSearchResult makeSearchResult();

    protected abstract boolean useScaledMonitor();

    @Override
    public void buildDone(IBuildDoneListener.BuildFinishReason buildFinishReason, String projectName) {
        if (IBuildDoneListener.BuildFinishReason.isCanceled(buildFinishReason)) {
            return;
        }
        if (projectName != null && projectName.equals(this.fProject.getName())) {
            this.fProjectRebuilt = true;
        }
    }

    private static class ScaledSubProgressMonitor
    extends SubProgressMonitor {
        private int fAccumulatedWork = 0;
        private int fTicksPerStep;
        private boolean fCanceled;

        public ScaledSubProgressMonitor(IProgressMonitor monitor, int work) {
            super(monitor, 100);
            this.fTicksPerStep = work / 100;
        }

        public void worked(int work) {
            ++this.fAccumulatedWork;
            if (this.fAccumulatedWork > this.fTicksPerStep) {
                super.worked(work);
                this.fAccumulatedWork = 0;
                this.fCanceled = super.isCanceled();
            }
        }

        public boolean isCanceled() {
            return this.fCanceled;
        }
    }
}

