/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.search;

import java.text.MessageFormat;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DecorationContext;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelDecorator;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.SearchPreferencePage;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.search.ExactAndPotentialMatchesPerResourcePair;
import ro.amiq.dvt.ui.search.IFileSearchContentProvider;
import ro.amiq.dvt.ui.search.LineElement;
import ro.amiq.dvt.ui.search.text.BaseFileSearchPage;
import ro.amiq.dvt.ui.search.ui.SearchMessages;
import ro.amiq.dvt.ui.utils.DVTColorUtil;

public abstract class BaseFileLabelProvider
extends StyledCellLabelProvider
implements ILabelProvider,
IPropertyChangeListener {
    public static final int SHOW_LABEL = 1;
    public static final int SHOW_LABEL_PATH = 2;
    public static final int SHOW_PATH_LABEL = 3;
    public static final int SHOW_PATH = 4;
    public static final int SHOW_POSSIBLE_MATCHES = 5;
    private static final String fgSeparatorFormat = "{0} - {1}";
    public static final String HIGHLIGHT_BG_COLOR_NAME = "org.eclipse.search.ui.match.highlight";
    private WorkbenchLabelProvider fLabelProvider;
    private AbstractTextSearchViewPage fPage;
    private BaseFileSearchPage resultPage;
    private int fOrder;
    private String[] fArgs = new String[2];
    protected Image fLineMatchImage;
    protected Image fLineMatchReadImage;
    protected Image fLineMatchWriteImage;
    protected Image fLineMatchReadWriteImage;
    private HashSet<Object> fMatchedBold = new HashSet();
    private final StyledString.Styler fBoldStyler;
    private final StyledString.Styler fSearchedElementStyler;
    private final StyledString.Styler fPossibleSearchedElementStyler;
    private ILabelDecorator fLabelDecorator;
    private Color fForegroudPossibleMatchColor;

    public BaseFileLabelProvider(AbstractTextSearchViewPage page, int orderFlag, ILabelDecorator decorator) {
        this.fLabelProvider = new WorkbenchLabelProvider();
        this.fOrder = orderFlag;
        this.fPage = page;
        this.fLineMatchImage = DVTImages.imageCache.getImage(DVTImages.DESC_SEARCH_LINE);
        this.fLineMatchReadImage = DVTImages.imageCache.getImage(DVTImages.SEARCH_READ_HIT);
        this.fLineMatchWriteImage = DVTImages.imageCache.getImage(DVTImages.SEARCH_WRITE_HIT);
        this.fLineMatchReadWriteImage = DVTImages.imageCache.getImage(DVTImages.SEARCH_READ_WRITE_HIT);
        this.fLabelDecorator = decorator;
        SearchPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.updateForegroundPossibleMatchColor();
        this.fBoldStyler = new StyledString.Styler(){
            FontRegistry fontRegistry = JFaceResources.getFontRegistry();

            public void applyStyles(TextStyle textStyle) {
                Display current = Display.getCurrent();
                if (current == null) {
                    return;
                }
                textStyle.font = this.fontRegistry.getBold(current.getSystemFont().getFontData()[0].getName());
            }
        };
        this.fPossibleSearchedElementStyler = new StyledString.Styler(){
            FontRegistry fontRegistry = JFaceResources.getFontRegistry();
            ColorRegistry colorRegistry = JFaceResources.getColorRegistry();

            public void applyStyles(TextStyle textStyle) {
                Display current = Display.getCurrent();
                if (current == null) {
                    return;
                }
                textStyle.foreground = BaseFileLabelProvider.this.fForegroudPossibleMatchColor;
                textStyle.background = this.colorRegistry.get(BaseFileLabelProvider.HIGHLIGHT_BG_COLOR_NAME);
                textStyle.font = this.fontRegistry.getBold(current.getSystemFont().getFontData()[0].getName());
            }
        };
        this.fSearchedElementStyler = new StyledString.Styler(){
            FontRegistry fontRegistry = JFaceResources.getFontRegistry();
            ColorRegistry colorRegistry = JFaceResources.getColorRegistry();

            public void applyStyles(TextStyle textStyle) {
                Display current = Display.getCurrent();
                if (current == null) {
                    return;
                }
                textStyle.background = this.colorRegistry.get(BaseFileLabelProvider.HIGHLIGHT_BG_COLOR_NAME);
                textStyle.font = this.fontRegistry.getBold(current.getSystemFont().getFontData()[0].getName());
            }
        };
    }

    private void updateForegroundPossibleMatchColor() {
        RGB newRGB = SearchPreferencePage.getPotentialMatchForegroundColor();
        if (newRGB == null) {
            return;
        }
        if (this.fForegroudPossibleMatchColor != null && !this.fForegroudPossibleMatchColor.isDisposed() && newRGB.equals((Object)this.fForegroudPossibleMatchColor.getRGB())) {
            return;
        }
        this.fForegroudPossibleMatchColor = DVTColorUtil.INSTANCE.getColor(newRGB);
    }

    public void update(ViewerCell cell) {
        try {
            HashSet<Object> matchedElements = this.getMatchedBold();
            Object cellElement = cell.getElement();
            boolean isBold = matchedElements != null && matchedElements.contains(cellElement);
            String cellText = this.getText(cellElement);
            Region extraInfoRegion = this.getExtraInfoRegion(cellElement, cellText);
            Region lineNumberRegion = null;
            boolean isPossibleMatch = false;
            if (cellElement instanceof LineElement) {
                isPossibleMatch = ((LineElement)cellElement).isPossibleMatch();
                int indexOfColon = cellText.indexOf(":");
                if (indexOfColon != -1) {
                    lineNumberRegion = new Region(0, cellText.indexOf(":") + 1);
                }
            }
            Region searchedElementRegion = this.getSearchedElementRegion(cellElement, cellText);
            StyledString styledString = new StyledString(cellText);
            if (isBold) {
                styledString.setStyle(0, cellText.length(), this.getBoldStyler());
            }
            if (extraInfoRegion != null) {
                boolean extraInfoRegionInsideCellText;
                boolean bl = extraInfoRegionInsideCellText = extraInfoRegion.getOffset() >= 0 && extraInfoRegion.getOffset() + extraInfoRegion.getLength() <= styledString.getString().length();
                if (extraInfoRegionInsideCellText) {
                    styledString.setStyle(extraInfoRegion.getOffset(), extraInfoRegion.getLength(), StyledString.DECORATIONS_STYLER);
                }
            }
            if (lineNumberRegion != null) {
                boolean lineNumberRegionInsideCellText;
                boolean bl = lineNumberRegionInsideCellText = lineNumberRegion.getOffset() >= 0 && lineNumberRegion.getOffset() + lineNumberRegion.getLength() <= styledString.getString().length();
                if (lineNumberRegionInsideCellText) {
                    styledString.setStyle(lineNumberRegion.getOffset(), lineNumberRegion.getLength(), StyledString.QUALIFIER_STYLER);
                }
            }
            if (searchedElementRegion != null) {
                boolean searchedElementRegionInsideCellText;
                boolean bl = searchedElementRegionInsideCellText = searchedElementRegion.getOffset() >= 0 && searchedElementRegion.getOffset() + searchedElementRegion.getLength() <= styledString.getString().length();
                if (searchedElementRegionInsideCellText) {
                    styledString.setStyle(searchedElementRegion.getOffset(), searchedElementRegion.getLength(), this.getSearchedElementStyler(isPossibleMatch));
                }
            }
            cell.setText(cellText);
            cell.setStyleRanges(styledString.getStyleRanges());
            cell.setImage(this.getImage(cellElement));
            super.update(cell);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected Region getExtraInfoRegion(Object cellElement, String cellText) {
        if (!(cellElement instanceof LineElement)) {
            return null;
        }
        String extraInfo = ((LineElement)cellElement).getExtraInfo();
        if (extraInfo == null) {
            return null;
        }
        int grayLength = extraInfo.length();
        int extraInfoOffset = cellText.length() - grayLength;
        return new Region(extraInfoOffset, grayLength);
    }

    protected Region getSearchedElementRegion(Object cellElement, String cellText) {
        if (!(cellElement instanceof LineElement)) {
            return null;
        }
        String searchedElement = ((LineElement)cellElement).getSearchedElement();
        if (searchedElement == null) {
            return null;
        }
        int searchedElementOffset = ((LineElement)cellElement).getSearchedElementOffset();
        if (searchedElementOffset == -1) {
            return null;
        }
        int indexOfColon = cellText.indexOf(":");
        if (indexOfColon != -1) {
            searchedElementOffset += cellText.indexOf(":") + 2;
        }
        int grayLength = searchedElement.length();
        return new Region(searchedElementOffset, grayLength);
    }

    protected void measure(Event event, Object element) {
        super.measure(event, element);
    }

    public void setOrder(int orderFlag) {
        this.fOrder = orderFlag;
    }

    public int getOrder() {
        return this.fOrder;
    }

    public HashSet<Object> getMatchedBold() {
        return this.fMatchedBold;
    }

    public void setMatchedBold(HashSet<Object> matchedBold) {
        this.fMatchedBold = matchedBold;
    }

    public String getText(Object element) {
        String text = this.getLabelProviderText(element);
        if (this.fLabelDecorator != null) {
            if (this.fLabelDecorator instanceof LabelDecorator) {
                LabelDecorator labelDecorator = (LabelDecorator)this.fLabelDecorator;
                String decorated = labelDecorator.decorateText(text, element, DecorationContext.DEFAULT_CONTEXT);
                if (decorated != null) {
                    return decorated;
                }
            } else {
                String decorated = this.fLabelDecorator.decorateText(text, element);
                if (decorated != null) {
                    return decorated;
                }
            }
        }
        return text;
    }

    public String getLabelProviderText(Object element) {
        if (element instanceof LineElement) {
            return this.getLineElementText((LineElement)element);
        }
        if (!(element instanceof IResource)) {
            return null;
        }
        IResource resource = (IResource)element;
        String text = null;
        if (!resource.exists()) {
            text = SearchMessages.FileLabelProvider_removed_resource_label;
        } else {
            IPath path = resource.getFullPath().removeLastSegments(1);
            if (path.getDevice() == null) {
                path = path.makeRelative();
            }
            if (this.fOrder == 1 || this.fOrder == 2) {
                text = this.fLabelProvider.getText((Object)resource);
                if (path != null && this.fOrder == 2) {
                    this.fArgs[0] = text;
                    this.fArgs[1] = path.toOSString();
                    text = MessageFormat.format(fgSeparatorFormat, this.fArgs);
                }
            } else {
                text = path != null ? path.toOSString() : "";
                if (this.fOrder == 3) {
                    this.fArgs[0] = text;
                    this.fArgs[1] = this.fLabelProvider.getText((Object)resource);
                    text = MessageFormat.format(fgSeparatorFormat, this.fArgs);
                }
            }
        }
        int exactMatchCount = 0;
        int possibleMatchCount = 0;
        AbstractTextSearchResult result = this.fPage.getInput();
        this.resultPage = (BaseFileSearchPage)this.fPage;
        if (result != null) {
            IFileSearchContentProvider resultContentProvider = this.resultPage.getContentProvider();
            if (resource instanceof IFile) {
                ExactAndPotentialMatchesPerResourcePair matchCountPair = resultContentProvider.getDisplayedPerResource(resource);
                exactMatchCount = matchCountPair.getExactMatches();
                possibleMatchCount = matchCountPair.getPotentialMatches();
            }
        }
        if (exactMatchCount < 1 && possibleMatchCount < 1) {
            return text;
        }
        String format_possible_match = SearchMessages.FileLabelProvider_count_format_possible_match;
        String format_only_possible_match = SearchMessages.FileLabelProvider_count_format_only_possible_match;
        if (possibleMatchCount != 0) {
            if (exactMatchCount != 0) {
                if (possibleMatchCount == 1 && exactMatchCount == 1) {
                    return MessageFormat.format(SearchMessages.FileLabelProvider_count_format_one_exact_one_possible_match, text, exactMatchCount, possibleMatchCount);
                }
                if (possibleMatchCount == 1) {
                    return MessageFormat.format(SearchMessages.FileLabelProvider_count_format_one_possible_match, text, exactMatchCount, possibleMatchCount);
                }
                if (exactMatchCount == 1) {
                    return MessageFormat.format(SearchMessages.FileLabelProvider_count_format_one_exact_possible_match, text, exactMatchCount, possibleMatchCount);
                }
                return MessageFormat.format(format_possible_match, text, exactMatchCount, possibleMatchCount);
            }
            if (possibleMatchCount == 1) {
                return MessageFormat.format(SearchMessages.FileLabelProvider_count_format_only_one_possible_match, text, possibleMatchCount);
            }
            return MessageFormat.format(format_only_possible_match, text, possibleMatchCount);
        }
        if (exactMatchCount == 1) {
            String format = SearchMessages.FileLabelProvider_single_match_format;
            return MessageFormat.format(format, text, exactMatchCount);
        }
        String format = SearchMessages.FileLabelProvider_count_format;
        return MessageFormat.format(format, text, exactMatchCount);
    }

    private String getLineElementText(LineElement element) {
        StringBuilder result = new StringBuilder();
        result.append(element.getLine());
        result.append(": ");
        result.append(element.getContents().trim());
        if (element.getNumberOfMatches(this.fPage.getInput(), true) > 0) {
            result.append(" (potential match)");
        }
        if (element.getExtraInfo() != null) {
            result.append(" " + element.getExtraInfo());
        }
        return result.toString();
    }

    public Image getImage(Object element) {
        Image image = this.getLabelProviderImage(element);
        if (this.fLabelDecorator != null) {
            if (this.fLabelDecorator instanceof LabelDecorator) {
                LabelDecorator labelDecorator = (LabelDecorator)this.fLabelDecorator;
                Image decorated = labelDecorator.decorateImage(image, element, DecorationContext.DEFAULT_CONTEXT);
                if (decorated != null) {
                    return decorated;
                }
            } else {
                Image decorated = this.fLabelDecorator.decorateImage(image, element);
                if (decorated != null) {
                    return decorated;
                }
            }
        }
        return image;
    }

    protected Image getLabelProviderImage(Object element) {
        if (element instanceof LineElement) {
            if (((LineElement)element).isReadAccess() || ((LineElement)element).isGetterAccess()) {
                return this.fLineMatchReadImage;
            }
            if (((LineElement)element).isWriteAccess() || ((LineElement)element).isSetterAccess()) {
                return this.fLineMatchWriteImage;
            }
            if (((LineElement)element).isReadWriteAccess()) {
                return this.fLineMatchReadWriteImage;
            }
            return this.fLineMatchImage;
        }
        if (!(element instanceof IResource)) {
            return null;
        }
        IResource resource = (IResource)element;
        Image image = this.fLabelProvider.getImage((Object)resource);
        return image;
    }

    public void dispose() {
        super.dispose();
        SearchPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        this.fLabelProvider.dispose();
        this.fLabelDecorator.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return this.fLabelProvider.isLabelProperty(element, property);
    }

    public void removeListener(ILabelProviderListener listener) {
        super.removeListener(listener);
        this.fLabelProvider.removeListener(listener);
        if (this.fLabelDecorator != null) {
            this.fLabelDecorator.removeListener(listener);
        }
    }

    public void addListener(ILabelProviderListener listener) {
        super.addListener(listener);
        this.fLabelProvider.addListener(listener);
        if (this.fLabelDecorator != null) {
            this.fLabelDecorator.addListener(listener);
        }
    }

    public StyledString.Styler getBoldStyler() {
        return this.fBoldStyler;
    }

    public StyledString.Styler getSearchedElementStyler(boolean isPossibleMatch) {
        boolean searchViewPotentialMatchEmphasizeColorPreferenceValue = SearchPreferencePage.arePotentialMatchesEmphasized();
        return isPossibleMatch && searchViewPotentialMatchEmphasizeColorPreferenceValue ? this.fPossibleSearchedElementStyler : this.fSearchedElementStyler;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("org.eclipse.search.potentialMatch.fgColor".equals(event.getProperty())) {
            this.updateForegroundPossibleMatchColor();
        }
    }
}

