/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.search.ui.text.Match;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.search.BaseFileMatchInfo;
import ro.amiq.dvt.ui.search.HitType;
import ro.amiq.dvt.ui.search.LeftRightHandSideOfOperatorEnum;
import ro.amiq.dvt.ui.search.LineElement;
import ro.amiq.dvt.ui.search.text.IFileMatch;

public class BaseFileMatch
extends Match
implements IFileMatch {
    private long fCreationTimeStamp;
    private boolean fPossibleMatch;
    private LineElement fLineElement;
    private BaseFileMatchInfo fInfo;

    public BaseFileMatch(IFile element, int offset, int length, boolean possibleMatch, boolean insideMacroCall, boolean isRenamed) {
        super((Object)element, offset, length);
        this.fCreationTimeStamp = element.getModificationStamp();
        this.fPossibleMatch = possibleMatch;
        this.fInfo = new BaseFileMatchInfo(null, null, insideMacroCall, null, null, isRenamed);
    }

    public BaseFileMatch(IFile element, int offset, int length, boolean possibleMatch) {
        this(element, offset, length, possibleMatch, false, true);
    }

    public BaseFileMatch(IFile element, int offset, int length, boolean possibleMatch, LineElement lineEntry, boolean insideMacroCall, boolean isRenamed) {
        super((Object)element, offset, length);
        this.fCreationTimeStamp = element.getModificationStamp();
        this.fPossibleMatch = possibleMatch;
        this.fLineElement = lineEntry;
        this.fInfo = new BaseFileMatchInfo(null, null, insideMacroCall, null, null, isRenamed);
    }

    public BaseFileMatch(IFile element, int offset, int length, boolean possibleMatch, LineElement lineEntry) {
        this(element, offset, length, possibleMatch, lineEntry, false, true);
    }

    public BaseFileMatch(LineElement element, long creationTimeStamp, int offset, int length, boolean possibleMatch, LineElement lineEntry) {
        super((Object)element, offset, length);
        this.fCreationTimeStamp = creationTimeStamp;
        this.fPossibleMatch = possibleMatch;
        this.fLineElement = lineEntry;
        this.fInfo = new BaseFileMatchInfo(null, null, false, null, null, false);
    }

    public IFile getFile() {
        return (IFile)this.getElement();
    }

    public long getCreationTimeStamp() {
        return this.fCreationTimeStamp;
    }

    @Override
    public boolean isPossibleMatch() {
        return this.fPossibleMatch;
    }

    @Override
    public LineElement getLineElement() {
        return this.fLineElement;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BaseFileMatch)) {
            return false;
        }
        try {
            BaseFileMatch match = (BaseFileMatch)obj;
            return this.locationEquals(match) && this.isPossibleMatch() == match.isPossibleMatch();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    public boolean locationEquals(BaseFileMatch fm) {
        block3: {
            block4: {
                if (!this.getLineElement().equals(fm.getLineElement()) || this.isFiltered() != fm.isFiltered() || this.getCreationTimeStamp() != fm.getCreationTimeStamp() || this.getOffset() != fm.getOffset() || this.getLength() != fm.getLength() || !this.getElement().equals(fm.getElement()) || !this.getFile().equals((Object)fm.getFile())) break block3;
                if (!this.getLeftRightHandSideOfConnection().isNeutralMatch() && !fm.getLeftRightHandSideOfConnection().isNeutralMatch()) break block4;
                return true;
            }
            try {
                return this.getLeftRightHandSideOfConnection() == fm.getLeftRightHandSideOfConnection();
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        return false;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (int)(this.fCreationTimeStamp ^ this.fCreationTimeStamp >>> 32);
        result = 31 * result + (this.fLineElement == null ? 0 : this.fLineElement.hashCode());
        result = 31 * result + (this.fPossibleMatch ? 1231 : 1237);
        return result;
    }

    public boolean isDotStarPortConnection() {
        return this.fInfo.getHitType() == HitType.DOTSTAR;
    }

    public boolean isImplicitPortConnection() {
        return this.fInfo.getHitType() == HitType.IMPLICIT;
    }

    public void setHitType(HitType hitType) {
        this.fInfo.setHitType(hitType);
    }

    public void setInstance(IRfInstanceElement instance) {
        this.fInfo.setInstance(instance);
    }

    public IRfInstanceElement getInstance() {
        return this.fInfo.getInstance();
    }

    public boolean isInsideMacroCall() {
        return this.fInfo.isInsideMacroCall();
    }

    public IRfDefElement getScopeDef() {
        return this.fInfo.getScope();
    }

    public void setScopeDef(IRfDefElement scopeDef) {
        this.fInfo.setfScope(scopeDef);
    }

    public boolean isRenamed() {
        return this.fInfo.isRenamed();
    }

    public void setIsRenamed(boolean isRenamed) {
        this.fInfo.setIsRenamed(isRenamed);
    }

    public void setConnectedElement(String connectedElement) {
        this.fInfo.setConnectedElement(connectedElement);
    }

    public String getConnectedElement() {
        return this.fInfo.getConnectedElement();
    }

    public void setLeftRightHandSideOfConnection(LeftRightHandSideOfOperatorEnum leftRightHandSideOfConnection) {
        this.fInfo.setLeftRightHandSideOfConnection(leftRightHandSideOfConnection);
    }

    public LeftRightHandSideOfOperatorEnum getLeftRightHandSideOfConnection() {
        return this.fInfo.getLeftRightHandSideOfConnection();
    }

    public void setIsInsideHierarchicalAccess(boolean isInsideHierarchicalAccess) {
        this.fInfo.setIsInsideHierarchicalAccess(isInsideHierarchicalAccess);
    }

    public boolean isInsideHierarchicalAccess() {
        return this.fInfo.isInsideHierarchicalAccess();
    }

    public void setIsDeclarationHit(boolean isDeclarationHit) {
        this.fInfo.setIsDeclarationHit(isDeclarationHit);
    }

    public boolean isDeclarationHit() {
        return this.fInfo.isDeclarationHit();
    }

    public boolean isEscaped() {
        return false;
    }

    public boolean isElaborationHit() {
        return this.fInfo.isElaborationHit();
    }

    public void setIsElaborationHit(boolean isElaborationHit) {
        this.fInfo.setIsElaborationHit(isElaborationHit);
    }

    public boolean isInsideComment() {
        return this.fInfo.isInsideComment();
    }

    public void setIsInsideComment(boolean isInsideComment) {
        this.fInfo.setIsInsideComment(isInsideComment);
    }

    public void setHid(Hid hid) {
        this.fInfo.setHid(hid);
    }

    public Hid getHid() {
        return this.fInfo.getHid();
    }
}

