/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.search;

import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.FileTextSearchScope;
import ro.amiq.dvt.ui.search.BaseTextSearchQuery;
import ro.amiq.dvt.ui.search.PatternConstructor;

public abstract class BaseFileSearchQuery
extends BaseTextSearchQuery {
    private final String fSearchText;
    private final String fSearchType;
    private final boolean fIsRegEx;
    private final boolean fIsCaseSensitive;
    private final boolean fIsWholeWord;
    protected int fLimitTo;
    protected boolean fIncludeDeclarations;
    protected int fSearchFor;
    protected boolean fOnlyCompiled;
    protected TextSearchRequestor fCollector;

    protected Pattern getSearchPattern() {
        return PatternConstructor.createPattern(this.getSearchString(), this.isRegexSearch(), true, this.isCaseSensitive(), this.isWholeWord());
    }

    public BaseFileSearchQuery(String searchType, String searchText, String searchLabel, boolean isRegEx, boolean isCaseSensitive, boolean isWholeWord, FileTextSearchScope scope, int limitTo, boolean includeDeclarations, boolean isOnlyCompiled, int searchFor) {
        super(scope, searchLabel);
        this.fSearchType = searchType;
        this.fSearchText = searchText;
        this.fIsRegEx = isRegEx;
        this.fIsCaseSensitive = isCaseSensitive;
        this.fLimitTo = limitTo;
        this.fIncludeDeclarations = includeDeclarations;
        this.fOnlyCompiled = isOnlyCompiled;
        this.fSearchFor = searchFor;
        this.fIsWholeWord = isWholeWord;
    }

    public IStatus run(IProgressMonitor monitor, TextSearchRequestor collector) {
        this.fCollector = collector;
        return this.run(monitor);
    }

    public String getSearchString() {
        return this.fSearchText;
    }

    @Override
    public String getSearchType() {
        String limitToText = "";
        if (this.fLimitTo == 1) {
            limitToText = " references";
        } else if (this.fLimitTo == 0) {
            limitToText = " declarations";
        } else if (this.fLimitTo == 2 || this.fLimitTo == 3) {
            limitToText = " matches";
        }
        return String.valueOf(this.fSearchType) + limitToText;
    }

    public boolean isRegexSearch() {
        return this.fIsRegEx;
    }

    public boolean isCaseSensitive() {
        return this.fIsCaseSensitive;
    }

    public boolean isWholeWord() {
        return this.fIsWholeWord;
    }

    @Override
    public boolean isFileNameSearch() {
        return this.fSearchText.length() == 0;
    }

    protected String getSearchedElementKind() {
        return this.fSearchType;
    }

    public abstract IStatus searchInFile(AbstractTextSearchResult var1, IProgressMonitor var2, IFile var3);
}

