/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.search;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.search.BaseFileMatch;
import ro.amiq.dvt.ui.search.BaseTextSearchQuery;

public class BaseFileSearchResult
extends AbstractTextSearchResult
implements IEditorMatchAdapter,
IFileMatchAdapter {
    private final Match[] EMPTY_ARR = new Match[0];
    private BaseTextSearchQuery fQuery;

    public BaseFileSearchResult(BaseTextSearchQuery job) {
        this.fQuery = job;
    }

    public ImageDescriptor getImageDescriptor() {
        return DVTImages.DESC_OBJ_TSEARCH_DPDN;
    }

    public String getLabel() {
        return this.fQuery.getResultLabel(this.getMatchCount());
    }

    public String getTooltip() {
        return this.getLabel();
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IFile file) {
        return this.getMatches(file);
    }

    public IFile getFile(Object element) {
        if (element instanceof IFile) {
            return (IFile)element;
        }
        return null;
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        IEditorInput ei = editor.getEditorInput();
        if (ei instanceof IFileEditorInput) {
            IFileEditorInput fi = (IFileEditorInput)ei;
            return match.getElement().equals(fi.getFile());
        }
        return false;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        IEditorInput ei = editor.getEditorInput();
        if (ei instanceof IFileEditorInput) {
            IFileEditorInput fi = (IFileEditorInput)ei;
            return this.getMatches(fi.getFile());
        }
        return this.EMPTY_ARR;
    }

    public ISearchQuery getQuery() {
        return this.fQuery;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }

    public int getPossibleMatchCount(Object element) {
        int possibleMatch = 0;
        Match[] matches = this.getMatches(element);
        int i = 0;
        while (i < matches.length) {
            BaseFileMatch fileMatch = (BaseFileMatch)matches[i];
            if (fileMatch.isPossibleMatch()) {
                ++possibleMatch;
            }
            ++i;
        }
        return possibleMatch;
    }

    public boolean isPotentialMatch(Match match) {
        BaseFileMatch fileMatch = (BaseFileMatch)match;
        return fileMatch.isPossibleMatch();
    }

    public Match[] getAllMatches(ArrayList<TreeItem> collectedChildrenWithMatches) {
        ArrayList<Match> resultList = new ArrayList<Match>();
        for (TreeItem elementWithMatches : collectedChildrenWithMatches) {
            Match[] matches = this.getMatches(elementWithMatches.getData());
            if (matches == null) continue;
            resultList.addAll(Arrays.asList(matches));
        }
        Match[] resultArray = new BaseFileMatch[resultList.size()];
        resultArray = resultList.toArray(resultArray);
        return resultArray;
    }
}

