/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.search;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResultPage;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.search.BaseFileLabelProvider;
import ro.amiq.dvt.ui.search.BaseFileMatch;
import ro.amiq.dvt.ui.search.ExactAndPotentialMatchesPerResourcePair;
import ro.amiq.dvt.ui.search.FilteredMap;
import ro.amiq.dvt.ui.search.IFileSearchContentProvider;
import ro.amiq.dvt.ui.search.ISerchResultCategoryFilter;
import ro.amiq.dvt.ui.search.LineElement;
import ro.amiq.dvt.ui.search.text.BaseFileSearchPage;
import ro.amiq.dvt.ui.views.TextFilterObject;

public abstract class BaseFileTreeContentProvider
implements ITreeContentProvider,
IFileSearchContentProvider {
    private final Object[] EMPTY_ARR = new Object[0];
    private AbstractTextSearchResult fResult;
    private AbstractTreeViewer fTreeViewer;
    private FilteredMap fChildrenMap;
    private BaseFileLabelProvider fLabelProvider;

    protected BaseFileTreeContentProvider(BaseFileSearchPage page, AbstractTreeViewer viewer, BaseFileLabelProvider innerLabelProvider) {
        this.fTreeViewer = viewer;
        this.fLabelProvider = innerLabelProvider;
        this.fChildrenMap = new FilteredMap(this.fLabelProvider);
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof AbstractTextSearchResult) {
            this.initialize((AbstractTextSearchResult)newInput);
        }
    }

    protected synchronized void initialize(AbstractTextSearchResult result) {
        this.fResult = result;
        this.fChildrenMap = new FilteredMap(this.fLabelProvider);
        if (result != null) {
            ISearchQuery query = this.fResult.getQuery();
            boolean showLineMatches = this.isShowLineMatches(query);
            Object[] elements = result.getElements();
            int i = 0;
            while (i < elements.length) {
                if (showLineMatches) {
                    Match[] matches = result.getMatches(elements[i]);
                    int j = 0;
                    while (j < matches.length) {
                        this.insert(((BaseFileMatch)matches[j]).getLineElement(), false);
                        ++j;
                    }
                } else {
                    this.insert(elements[i], false);
                }
                ++i;
            }
        }
    }

    protected abstract boolean isShowLineMatches(ISearchQuery var1);

    private void insert(Object child, boolean refreshViewer) {
        Object parent = this.getParent(child);
        while (parent != null) {
            if (this.fChildrenMap.insertChild(parent, child)) {
                if (refreshViewer) {
                    this.fTreeViewer.add(parent, child);
                }
            } else {
                if (refreshViewer) {
                    this.fTreeViewer.refresh(parent);
                }
                return;
            }
            child = parent;
            parent = this.getParent(child);
        }
        if (this.fChildrenMap.insertChild(this.fResult, child) && refreshViewer) {
            this.fTreeViewer.add((Object)this.fResult, child);
        }
    }

    private void remove(Object element, boolean refreshViewer) {
        if (this.hasChildrenNonFiltered(element)) {
            if (refreshViewer) {
                this.fTreeViewer.refresh(element);
            }
        } else if (!this.hasMatches(element)) {
            this.fChildrenMap.remove(element);
            Object parent = this.getParent(element);
            if (parent != null) {
                this.removeFromSiblings(element, parent);
                this.remove(parent, refreshViewer);
            } else {
                this.removeFromSiblings(element, this.fResult);
                if (refreshViewer) {
                    this.fTreeViewer.refresh();
                }
            }
        } else if (refreshViewer) {
            this.fTreeViewer.refresh(element);
        }
    }

    private boolean hasMatches(Object element) {
        if (element instanceof LineElement) {
            LineElement lineElement = (LineElement)element;
            return lineElement.getNumberOfMatches(this.fResult) > 0;
        }
        return this.fResult.getMatchCount(element) > 0;
    }

    private void removeFromSiblings(Object element, Object parent) {
        Set siblings = (Set)this.fChildrenMap.get(parent);
        if (siblings != null) {
            siblings.remove(element);
        }
    }

    public Object[] getChildren(Object parentElement) {
        if (this.fChildrenMap == null) {
            return this.EMPTY_ARR;
        }
        Set children = (Set)this.fChildrenMap.getFiltered(parentElement);
        if (children == null) {
            return this.EMPTY_ARR;
        }
        return children.toArray();
    }

    public Object[] getChildrenNonFiltered(Object parentElement) {
        Set children = (Set)this.fChildrenMap.get(parentElement);
        if (children == null) {
            return this.EMPTY_ARR;
        }
        return children.toArray();
    }

    public boolean hasChildrenNonFiltered(Object element) {
        return this.getChildrenNonFiltered(element).length > 0;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    @Override
    public synchronized void elementsChanged(Object[] updatedElements) {
        int i = 0;
        while (i < updatedElements.length) {
            if (!(updatedElements[i] instanceof LineElement)) {
                if (this.fResult.getMatchCount(updatedElements[i]) > 0) {
                    this.insert(updatedElements[i], i == updatedElements.length - 1);
                } else {
                    this.remove(updatedElements[i], i == updatedElements.length - 1);
                }
            } else {
                LineElement lineElement = (LineElement)updatedElements[i];
                int nMatches = lineElement.getNumberOfMatches(this.fResult);
                if (nMatches > 0) {
                    if (this.fChildrenMap.hasChild(lineElement.getParent(), lineElement)) {
                        this.fTreeViewer.update(new Object[]{lineElement, lineElement.getParent()}, null);
                    } else {
                        this.insert(lineElement, i == updatedElements.length - 1);
                    }
                } else {
                    this.remove(lineElement, i == updatedElements.length - 1);
                }
            }
            ++i;
        }
        if (updatedElements.length > 0) {
            Utils.getActiveShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ISearchResultPage searchViewPage;
                    ISearchResultViewPart searchResultView = NewSearchUI.getSearchResultView();
                    if (searchResultView != null && (searchViewPage = searchResultView.getActivePage()) instanceof BaseFileSearchPage) {
                        ((BaseFileSearchPage)searchViewPage).refresh(true);
                    }
                }
            });
        }
    }

    @Override
    public void clear() {
        this.initialize(this.fResult);
        this.fTreeViewer.refresh();
    }

    public Object getParent(Object element) {
        if (element instanceof IProject) {
            return null;
        }
        if (element instanceof IResource) {
            IResource resource = (IResource)element;
            return resource.getParent();
        }
        if (element instanceof LineElement) {
            return ((LineElement)element).getParent();
        }
        if (element instanceof BaseFileMatch) {
            BaseFileMatch match = (BaseFileMatch)element;
            return match.getLineElement();
        }
        return null;
    }

    @Override
    public boolean filter(TextFilterObject textFilter, ISerchResultCategoryFilter categoryFilter) {
        if (this.fChildrenMap != null) {
            return this.fChildrenMap.filter(textFilter, categoryFilter);
        }
        return true;
    }

    @Override
    public int getDisplayed() {
        return this.fChildrenMap == null ? 0 : this.fChildrenMap.getDisplayed();
    }

    @Override
    public ExactAndPotentialMatchesPerResourcePair getDisplayedPerResource(IResource resource) {
        return this.fChildrenMap == null ? new ExactAndPotentialMatchesPerResourcePair(0, 0) : this.fChildrenMap.getDisplayed(resource);
    }

    @Override
    public int getTotal() {
        return this.fChildrenMap == null ? 0 : this.fChildrenMap.getTotal();
    }

    public void dispose() {
    }

    @Override
    public boolean isGuiFiltered() {
        return this.fChildrenMap != null && this.fChildrenMap.isGuiFiltered();
    }

    @Override
    public HashSet<Object> getMatchedBold() {
        return this.fChildrenMap.getMatchedBold();
    }

    public AbstractTextSearchResult getResult() {
        return this.fResult;
    }
}

