/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.search;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.DVTMixedLangModelManager;
import ro.amiq.dvt.model.IBuildDoneListener;
import ro.amiq.dvt.model.reflection.DummyInstance;
import ro.amiq.dvt.model.reflection.IReportHitsListener;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.model.reflection.RfNamedElementVisitorException;
import ro.amiq.dvt.model.reflection.semantic.extension.IDataType;
import ro.amiq.dvt.model.reflection.util.RfReferencesUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.search.BaseFileMatch;
import ro.amiq.dvt.ui.search.BaseSearchQuery;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.ui.search.FileSynchedAndAvailableManager;
import ro.amiq.dvt.ui.search.InstanceMatch;

public abstract class BaseInstancesSearchQuery
extends BaseSearchQuery
implements IBuildDoneListener {
    protected IRfNamedElement fRfElement;
    protected AbstractTextSearchResult fSearchResult;
    protected IRfSingleLangProject fRfProject;
    protected IProject fProject;
    private IProgressMonitor fMonitor;
    protected HashSet<BaseFileMatch> fCachedMatches;
    protected DocumentManager fDocumentManager;
    protected ParserPath fCurrentParserPath;
    private boolean fProjectRebuilt;
    private RfElementPath fRfElementPath;
    protected static final String VHDL_EDT_BASE_COMMENT_STRING = "--";

    public BaseInstancesSearchQuery(IRfNamedElement element) {
        this.fRfElement = element;
        this.fRfElementPath = RfElementPath.path(element);
        this.fRfProject = element.getRfProject();
        this.fProject = this.fRfProject.getProject();
        this.fSearchResult = this.makeSearchResult();
        this.fCachedMatches = new HashSet();
        this.fDocumentManager = new DocumentManager();
        DVTMixedLangModelManager.getInstance().addBuildDoneListener(this);
    }

    public IRfNamedElement getRfElement() {
        if (!this.fProjectRebuilt) {
            return this.fRfElement;
        }
        this.fRfElement = this.fRfElementPath.toNamedElement(this.fProject);
        if (this.fRfElement == null) {
            return null;
        }
        this.fProjectRebuilt = false;
        return this.fRfElement;
    }

    public IStatus run(IProgressMonitor monitor) {
        final DocumentManager documentManager = new DocumentManager();
        try {
            documentManager.activate();
            long startTime = System.currentTimeMillis();
            this.clean();
            IProgressMonitor progressMonitor = monitor == null ? new NullProgressMonitor() : monitor;
            final FileSynchedAndAvailableManager fileManager = new FileSynchedAndAvailableManager(null, monitor);
            IReportHitsListener<InstanceMatch> reportInstancesListener = new IReportHitsListener<InstanceMatch>(){

                @Override
                public void addMatch(InstanceMatch instanceMatch) {
                    BaseInstancesSearchQuery.this.addInstanceMatch(instanceMatch, documentManager, fileManager);
                }

                @Override
                public Set<InstanceMatch> getMatches() {
                    return null;
                }
            };
            IRfNamedElement namedElement = this.getRfElement();
            if (namedElement == null) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            this.computeInstances(progressMonitor, reportInstancesListener, namedElement);
            RfReferencesUtils.flushMatches(this.fCachedMatches, this.getSearchResult());
            RfReferencesUtils.logComputeInstancesTime(namedElement, startTime);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (RfNamedElementVisitorException e) {
            if (!(e.getCause() instanceof OperationCanceledException)) {
                DVTLogger.INSTANCE.logError(e.getCause());
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        finally {
            documentManager.deactivate();
        }
        return Status.CANCEL_STATUS;
    }

    public void computeInstances(IProgressMonitor progressMonitor, IReportHitsListener<InstanceMatch> reportInstancesListener, IRfNamedElement namedElement) {
        IRfSingleLangProject rfProject = namedElement.getRfProject();
        if (rfProject == null) {
            return;
        }
        this.computeElaboratedInstances(namedElement, rfProject.getELManager(), reportInstancesListener);
    }

    private void computeElaboratedInstances(IRfNamedElement namedElement, ELManager elManager, IReportHitsListener<InstanceMatch> reportInstancesListener) {
        if (!(namedElement instanceof IRfDesignElement)) {
            return;
        }
        IRfDesignElement designElement = (IRfDesignElement)namedElement;
        List<ELInstance> instancesFor = elManager.getMemory().getInstancesFor(designElement, designElement.getKind() == IRfNamedElement.ElementKind.VHDL_ENTITY, Integer.MAX_VALUE);
        if (instancesFor == null || instancesFor.isEmpty()) {
            return;
        }
        for (ELInstance elInstance : instancesFor) {
            IRfDefElement declaration;
            IRfInstanceElement instanceElement = elInstance.getDescription();
            if (instanceElement instanceof DummyInstance || (declaration = instanceElement.getDeclaration()) == null) continue;
            ParserPath parserPath = declaration.getParserPath();
            IDataType dataType = instanceElement.getDataType();
            if (dataType == null) continue;
            reportInstancesListener.addMatch(new InstanceMatch(parserPath, dataType.getOffset(), dataType.getOffset(), -1, -1, instanceElement.getAssociatedTypeName(), dataType.isEscaped()));
        }
    }

    private void clean() {
        this.fSearchResult.removeAll();
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public AbstractTextSearchResult getSearchResult() {
        return this.fSearchResult;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public String getLabel() {
        IRfNamedElement element = this.getRfElement();
        if (element == null) {
            return "";
        }
        return "[".concat(this.fProject.getName()).concat("] ").concat("Instances of ").concat(element.getKindName()).concat(" '" + element.getName() + "'");
    }

    public IProgressMonitor getMonitor() {
        return this.fMonitor;
    }

    @Override
    public void buildDone(IBuildDoneListener.BuildFinishReason buildFinishReason, String projectName) {
        if (IBuildDoneListener.BuildFinishReason.isCanceled(buildFinishReason)) {
            return;
        }
        if (this.fProject == null) {
            return;
        }
        if (projectName != null && projectName.equals(this.fProject.getName())) {
            this.fProjectRebuilt = true;
        }
    }

    protected abstract AbstractTextSearchResult makeSearchResult();

    public abstract void addInstanceMatch(InstanceMatch var1, DocumentManager var2, FileSynchedAndAvailableManager var3);
}

