/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.search;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.ui.search.BaseReferencesInWorkspaceAction;
import ro.amiq.dvt.utils.DVTFileUtils;

public abstract class BaseReferencesInWorkspaceActionCommon
extends TextEditorAction {
    public BaseReferencesInWorkspaceActionCommon(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    public static String[] getFileExtensions(IRfSingleLangProject rfProject) throws CoreException {
        return BaseReferencesInWorkspaceActionCommon.getFileExtensions(rfProject.getProject());
    }

    public static String[] getFileExtensions(IProject rfProject) throws CoreException {
        boolean hasVhdlNature = false;
        boolean hasENature = false;
        boolean hasSlnNature = false;
        boolean hasMsdlNature = false;
        boolean hasPssNature = false;
        boolean hasVlogNature = false;
        String[] natures = BaseReferencesInWorkspaceAction.getProjectNatures(rfProject.getProject());
        String[] eFileExtensions = DVTFileUtils.getInstance().getExtensionsForContentType("ro.amiq.edt.ESource", true);
        String[] slnFileExtensions = DVTFileUtils.getInstance().getExtensionsForContentType("ro.amiq.slndt.SLNSource", true);
        String[] msdlFileExtensions = DVTFileUtils.getInstance().getExtensionsForContentType("ro.amiq.msdldt.MSDLSource", true);
        String[] pssFileExtensions = DVTFileUtils.getInstance().getExtensionsForContentType("ro.amiq.pssdt.PSSSource", true);
        String[] vhdlFileExtensions = DVTFileUtils.getInstance().getExtensionsForContentType("ro.amiq.vhdldt.VhdlSource", true);
        String[] vlogFileExtensions = DVTFileUtils.getInstance().getExtensionsForContentType("ro.amiq.vlogdt.VlogSource", true);
        int eLength = eFileExtensions == null ? 0 : eFileExtensions.length;
        int slnLength = slnFileExtensions == null ? 0 : slnFileExtensions.length;
        int msdlLength = msdlFileExtensions == null ? 0 : msdlFileExtensions.length;
        int pssLength = pssFileExtensions == null ? 0 : pssFileExtensions.length;
        int vhdlLength = vhdlFileExtensions == null ? 0 : vhdlFileExtensions.length;
        int vlogLength = vlogFileExtensions == null ? 0 : vlogFileExtensions.length;
        String[] stringArray = natures;
        int n = natures.length;
        int n2 = 0;
        while (n2 < n) {
            String nature = stringArray[n2];
            if ("ro.amiq.edt.enature".equals(nature)) {
                hasENature = true;
            } else if ("ro.amiq.slndt.slnnature".equals(nature)) {
                hasSlnNature = true;
            } else if ("ro.amiq.msdldt.msdlnature".equals(nature)) {
                hasMsdlNature = true;
            } else if ("ro.amiq.pssdt.pssnature".equals(nature)) {
                hasPssNature = true;
            } else if ("ro.amiq.vhdldt.VhdlNature".equals(nature)) {
                hasVhdlNature = true;
            } else if ("ro.amiq.vlogdt.VlogNature".equals(nature)) {
                hasVlogNature = true;
            }
            ++n2;
        }
        HashSet<String> fileExtensions = new HashSet<String>();
        if (hasENature && eLength > 0) {
            fileExtensions.addAll(Arrays.asList(eFileExtensions));
        }
        if (hasSlnNature && slnLength > 0) {
            fileExtensions.addAll(Arrays.asList(slnFileExtensions));
        }
        if (hasMsdlNature && msdlLength > 0) {
            fileExtensions.addAll(Arrays.asList(msdlFileExtensions));
        }
        if (hasPssNature && pssLength > 0) {
            fileExtensions.addAll(Arrays.asList(pssFileExtensions));
        }
        if (hasVhdlNature && vhdlLength > 0) {
            fileExtensions.addAll(Arrays.asList(vhdlFileExtensions));
        }
        if (hasVlogNature && vlogLength > 0) {
            fileExtensions.addAll(Arrays.asList(vlogFileExtensions));
        }
        fileExtensions.addAll(BaseReferencesInWorkspaceActionCommon.getCompiledFileExtensionPatterns(rfProject));
        return fileExtensions.toArray(new String[fileExtensions.size()]);
    }

    public static Set<String> getCompiledFileExtensionPatterns(IProject project) {
        Set<ParserPath> compiledFiles;
        IRfSingleLangProject pssRfProject;
        Set<ParserPath> compiledFiles2;
        IRfSingleLangProject slnRfProject;
        Set<ParserPath> compiledFiles3;
        IRfSingleLangProject eRfProject;
        Set<ParserPath> compiledFiles4;
        IRfSingleLangProject vhdlRfProject;
        Set<ParserPath> compiledFiles5;
        if (project == null) {
            return Collections.emptySet();
        }
        RfMixedLangProject mixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(project, false);
        if (mixedLangProject == null) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        IRfSingleLangProject vlogRfProject = mixedLangProject.getSingleLangProject("ro.amiq.vlogdt.VlogNature");
        if (vlogRfProject != null && (compiledFiles5 = vlogRfProject.getCompiledFilesSet()) != null && !compiledFiles5.isEmpty()) {
            for (ParserPath compiledFile : compiledFiles5) {
                if (compiledFile.path == null) continue;
                result.add("*." + Path.fromOSString((String)compiledFile.path).getFileExtension());
            }
        }
        if ((vhdlRfProject = mixedLangProject.getSingleLangProject("ro.amiq.vhdldt.VhdlNature")) != null && (compiledFiles4 = vhdlRfProject.getCompiledFilesSet()) != null && !compiledFiles4.isEmpty()) {
            for (ParserPath compiledFile : compiledFiles4) {
                if (compiledFile.path == null) continue;
                result.add("*." + Path.fromOSString((String)compiledFile.path).getFileExtension());
            }
        }
        if ((eRfProject = mixedLangProject.getSingleLangProject("ro.amiq.edt.enature")) != null && (compiledFiles3 = eRfProject.getCompiledFilesSet()) != null && !compiledFiles3.isEmpty()) {
            for (ParserPath compiledFile : compiledFiles3) {
                if (compiledFile.path == null) continue;
                result.add("*." + Path.fromOSString((String)compiledFile.path).getFileExtension());
            }
        }
        if ((slnRfProject = mixedLangProject.getSingleLangProject("ro.amiq.slndt.slnnature")) != null && (compiledFiles2 = slnRfProject.getCompiledFilesSet()) != null && !compiledFiles2.isEmpty()) {
            for (ParserPath compiledFile : compiledFiles2) {
                if (compiledFile.path == null) continue;
                result.add("*." + Path.fromOSString((String)compiledFile.path).getFileExtension());
            }
        }
        if ((pssRfProject = mixedLangProject.getSingleLangProject("ro.amiq.pssdt.pssnature")) != null && (compiledFiles = pssRfProject.getCompiledFilesSet()) != null && !compiledFiles.isEmpty()) {
            for (ParserPath compiledFile : compiledFiles) {
                if (compiledFile.path == null) continue;
                result.add("*." + Path.fromOSString((String)compiledFile.path).getFileExtension());
            }
        }
        return result;
    }
}

