/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.search;

import java.text.MessageFormat;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.FileTextSearchScope;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.ui.search.BaseFileSearchResult;
import ro.amiq.dvt.ui.search.BaseSearchQuery;
import ro.amiq.dvt.ui.search.SearchResultUpdater;
import ro.amiq.dvt.ui.search.ui.SearchMessages;
import ro.amiq.dvt.utils.DVTStringUtil;

public abstract class BaseTextSearchQuery
extends BaseSearchQuery {
    private BaseFileSearchResult fResult;
    protected final FileTextSearchScope fScope;
    private String fSearchLabel;
    private boolean fAccumulateResults;
    private Set<ParserPath> fUnsynchedFiles;

    public Set<ParserPath> getUnsynchedFiles() {
        return this.fUnsynchedFiles;
    }

    public void setUnsynchedMatches(Set<ParserPath> unsynchedFiles) {
        this.fUnsynchedFiles = unsynchedFiles;
    }

    protected BaseTextSearchQuery(FileTextSearchScope scope, String searchLabel) {
        this.fSearchLabel = searchLabel;
        this.fScope = scope;
    }

    public void setAccumulateResults(boolean isAccumulateResults) {
        this.fAccumulateResults = isAccumulateResults;
    }

    public boolean isAccumulateResults() {
        return this.fAccumulateResults;
    }

    public ISearchResult getSearchResult() {
        if (this.fResult == null) {
            this.fResult = this.makeFileSearchResult(this);
            new SearchResultUpdater(this.fResult);
        }
        return this.fResult;
    }

    public void setSearchResult(BaseFileSearchResult searchResult) {
        this.fResult = searchResult;
    }

    public FileTextSearchScope getSearchScope() {
        return this.fScope;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public FileTextSearchScope getScope() {
        return this.fScope;
    }

    public String getLabel() {
        return SearchMessages.FileSearchQuery_label;
    }

    public String getResultLabel(int nMatches) {
        String searchString = this.getSearchLabel();
        String searchType = this.getSearchType();
        if (searchString.length() > 0) {
            String description = DVTStringUtil.removeTicks(this.getScope().getDescription());
            if (this.isScopeAllFileTypes()) {
                if (nMatches == 1) {
                    Object[] args = new Object[]{searchType, searchString, description};
                    return MessageFormat.format(SearchMessages.FileSearchQuery_singularLabel, args);
                }
                Object[] args = new Object[]{searchType, searchString, nMatches, description};
                return MessageFormat.format(SearchMessages.FileSearchQuery_pluralPattern, args);
            }
            if (nMatches == 1) {
                Object[] args = new Object[]{searchType, searchString, description, this.getScope().getFilterDescription()};
                return MessageFormat.format(SearchMessages.FileSearchQuery_singularPatternWithFileExt, args);
            }
            Object[] args = new Object[]{searchType, searchString, nMatches, description, this.getScope().getFilterDescription()};
            return MessageFormat.format(SearchMessages.FileSearchQuery_pluralPatternWithFileExt, args);
        }
        return "";
    }

    public String getSearchLabel() {
        return this.fSearchLabel;
    }

    public boolean isScopeAllFileTypes() {
        String[] fileNamePatterns = this.getScope().getFileNamePatterns();
        if (fileNamePatterns == null) {
            return false;
        }
        int i = 0;
        while (i < fileNamePatterns.length) {
            if ("*".equals(fileNamePatterns[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public abstract String getSearchType();

    protected abstract BaseFileSearchResult makeFileSearchResult(BaseTextSearchQuery var1);

    public IProject getProject() {
        return null;
    }
}

