/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.search;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;

public class DocumentCharSequence
implements CharSequence {
    private final IDocument fDocument;
    private boolean fRemoveComments;

    public DocumentCharSequence(IDocument document, boolean removeComments) {
        this.fDocument = document;
        this.fRemoveComments = removeComments;
    }

    @Override
    public int length() {
        return this.fDocument.getLength();
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    @Override
    public char charAt(int index) {
        try {
            return this.fDocument.getChar(index);
        }
        catch (BadLocationException badLocationException) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        try {
            return this.fDocument.get(start, end - start);
        }
        catch (Exception exception) {
            throw new IndexOutOfBoundsException();
        }
    }

    public boolean notInComment(int index) {
        block11: {
            IDocumentExtension3 document;
            block15: {
                block14: {
                    block13: {
                        block12: {
                            if (!this.fRemoveComments) break block11;
                            document = (IDocumentExtension3)this.fDocument;
                            if (document.getDocumentPartitioner("__vlog_partitioning") == null) break block12;
                            String contentType = document.getContentType("__vlog_partitioning", index, false);
                            if (contentType.equals("__vlog_ml_comment") || contentType.equals("__vlog_sl_comment")) {
                                return false;
                            }
                            break block11;
                        }
                        if (document.getDocumentPartitioner("__vhdl_partitioning") == null) break block13;
                        String contentType = document.getContentType("__vhdl_partitioning", index, false);
                        if (contentType.equals("__vhdl_ml_comment") || contentType.equals("__vhdl_sl_comment")) {
                            return false;
                        }
                        break block11;
                    }
                    if (document.getDocumentPartitioner("__e_partitioning") == null) break block14;
                    String contentType = document.getContentType("__e_partitioning", index, false);
                    if (contentType.equals("__e_ml_comment") || contentType.equals("__e_sl_comment") || contentType.equals("__e_sv_ml_comment") || contentType.equals("__e_sl_comment_in_expansion")) {
                        return false;
                    }
                    break block11;
                }
                if (document.getDocumentPartitioner("__pss_partitioning") == null) break block15;
                String contentType = document.getContentType("__pss_partitioning", index, false);
                if (contentType.equals("__pss_ml_comment") || contentType.equals("__pss_sl_comment")) {
                    return false;
                }
                break block11;
            }
            try {
                String contentType;
                if (document.getDocumentPartitioner("__msdl_partitioning") == null || !(contentType = document.getContentType("__msdl_partitioning", index, false)).equals("__msdl_ml_comment") && !contentType.equals("__msdl_sl_comment")) break block11;
                return false;
            }
            catch (BadLocationException badLocationException) {
                return true;
            }
            catch (BadPartitioningException badPartitioningException) {
                return true;
            }
        }
        return true;
    }

    public boolean isInString(int index) {
        block12: {
            IDocumentExtension3 document;
            block15: {
                block14: {
                    block13: {
                        block11: {
                            document = (IDocumentExtension3)this.fDocument;
                            if (document.getDocumentPartitioner("__vlog_partitioning") == null) break block11;
                            String contentType = document.getContentType("__vlog_partitioning", index, false);
                            if (contentType.equals("__vlog_literal")) {
                                return true;
                            }
                            break block12;
                        }
                        if (document.getDocumentPartitioner("__vhdl_partitioning") == null) break block13;
                        String contentType = document.getContentType("__vhdl_partitioning", index, false);
                        if (contentType.equals("__vhdl_literal")) {
                            return true;
                        }
                        break block12;
                    }
                    if (document.getDocumentPartitioner("__e_partitioning") == null) break block14;
                    String contentType = document.getContentType("__e_partitioning", index, false);
                    if (contentType.equals("__e_string") || contentType.equals("__e_string_in_code_replacement_in_expansion") || contentType.equals("__e_string_in_code_section_in_expansion")) {
                        return true;
                    }
                    break block12;
                }
                if (document.getDocumentPartitioner("__pss_partitioning") == null) break block15;
                String contentType = document.getContentType("__pss_partitioning", index, false);
                if (contentType.equals("__pss_literal")) {
                    return true;
                }
                break block12;
            }
            try {
                String contentType;
                if (document.getDocumentPartitioner("__msdl_partitioning") == null || !(contentType = document.getContentType("__msdl_partitioning", index, false)).equals("__msdl_literal")) break block12;
                return true;
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
            catch (BadPartitioningException badPartitioningException) {
                return false;
            }
        }
        return false;
    }
}

