/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.LRUCache;
import ro.amiq.dvt.utils.TextFileBufferInfo;

public class DocumentManager {
    private boolean fActive;
    private Collection<IPath> fToDisconnect = new ArrayList<IPath>();
    private Map<ParserPath, IDocument> fCache = Collections.synchronizedMap(new LRUCache(10000));

    public DocumentManager(boolean active) {
        this.fActive = active;
    }

    public DocumentManager() {
        this(false);
    }

    public void activate() {
        if (this.fActive) {
            throw new IllegalStateException("DocumentManager already activate!");
        }
        this.fActive = true;
    }

    public void deactivate() {
        try {
            this.fCache.clear();
            if (!this.fActive) {
                throw new IllegalStateException("DocumentManager already not active!");
            }
            this.fActive = false;
            ITextFileBufferManager textFileBufferManager = FileBuffers.getTextFileBufferManager();
            if (textFileBufferManager == null) {
                throw new IllegalStateException("FileBuffers plugin not active!");
            }
            for (IPath path : this.fToDisconnect) {
                textFileBufferManager.disconnect(path, LocationKind.NORMALIZE, null);
            }
            this.fToDisconnect.clear();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private IDocument getOpenDocument(ParserPath file) {
        Map<ParserPath, IDocument> documentsInEditors = DVTFileUtils.getInstance().evalNonFileBufferParserPathDocuments();
        if (documentsInEditors == null) {
            return null;
        }
        return documentsInEditors.get(file);
    }

    public IDocument getDocument(ParserPath file, IProject project) {
        return this.getDocument(file, true, project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDocument getDocument(ParserPath file, boolean installPartitioner, IProject project) {
        IDocument result = this.fCache.get(file);
        if (result == null) {
            DocumentManager documentManager = this;
            synchronized (documentManager) {
                result = this.computeDocument(file, project);
            }
            if (result != null) {
                this.fCache.put(file, result);
                if (installPartitioner) {
                    RfSearchUtils.installPartitionerForFile(project, result, file);
                }
            }
        }
        return result;
    }

    private IDocument computeDocument(ParserPath file, IProject project) {
        ITextFileBuffer textFileBuffer;
        block5: {
            if (!this.fActive) {
                throw new IllegalStateException("No active DocManager session!");
            }
            try {
                LocationKind locationKind;
                TextFileBufferInfo textFileBufferInfo;
                IPath fromOSString;
                IDocument document = this.getOpenDocument(file);
                if (document != null) {
                    return document;
                }
                ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
                textFileBuffer = bufferManager.getTextFileBuffer(fromOSString = (textFileBufferInfo = DVTFileUtils.getInstance().getTextFileBufferInfo(file, project)).getPath(), locationKind = textFileBufferInfo.getLocationKind());
                if (textFileBuffer != null) break block5;
                bufferManager.connect(fromOSString, locationKind, null);
                this.fToDisconnect.add(fromOSString);
                textFileBuffer = bufferManager.getTextFileBuffer(fromOSString, locationKind);
                if (textFileBuffer != null) break block5;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        return textFileBuffer.getDocument();
    }
}

