/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.search;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTFileUtils;

public class FileSynchedAndAvailableManager {
    private Set<ParserPath> filesToSearchIn;
    private Set<ParserPath> synchedFilesCache;
    private Set<ParserPath> unsynchedFilesCache;
    private IProgressMonitor monitor;
    private boolean syncOnDemand;

    public FileSynchedAndAvailableManager(Set<ParserPath> filesToSearchIn, IProgressMonitor monitor, boolean syncOnDemand) {
        this.filesToSearchIn = filesToSearchIn;
        this.monitor = monitor;
        this.synchedFilesCache = new HashSet<ParserPath>();
        this.unsynchedFilesCache = new HashSet<ParserPath>();
        this.syncOnDemand = syncOnDemand;
    }

    public FileSynchedAndAvailableManager(Set<ParserPath> filesToSearchIn, IProgressMonitor monitor) {
        this(filesToSearchIn, monitor, true);
    }

    public boolean isSynchedFile(ParserPath parserPath, IProject project) {
        if (parserPath == null || project == null) {
            return false;
        }
        if (this.filesToSearchIn != null && !this.filesToSearchIn.isEmpty() && !this.filesToSearchIn.contains(parserPath)) {
            return false;
        }
        if (!this.synchedFilesCache.contains(parserPath)) {
            IFile file;
            block11: {
                block10: {
                    if (this.unsynchedFilesCache.contains(parserPath)) {
                        return false;
                    }
                    try {
                        file = DVTFileUtils.getInstance().findProjectFile(project, parserPath.path);
                        if (file != null) break block10;
                        return false;
                    }
                    catch (CoreException e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        return false;
                    }
                }
                if (!this.syncOnDemand) break block11;
                if (!DVTFileUtils.getInstance().ensureFileInSyncWithUserAccept((IResource)file, this.monitor)) {
                    this.unsynchedFilesCache.add(parserPath);
                    return false;
                }
            }
            if (!file.isSynchronized(0)) {
                this.unsynchedFilesCache.add(parserPath);
                return false;
            }
            this.synchedFilesCache.add(parserPath);
        }
        return true;
    }

    public Set<ParserPath> getUnsynchedFiles() {
        return this.unsynchedFilesCache;
    }
}

