/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.search;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.search.core.text.TextSearchScope;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTFileUtils;

public class FilesAndProjectsOfScopeCalculator
implements IResourceProxyVisitor {
    private final TextSearchScope fScope;
    private Map<IProject, Set<ParserPath>> fFilesMap;

    public FilesAndProjectsOfScopeCalculator(TextSearchScope scope) {
        this.fScope = scope;
    }

    public FilesAndProjectsOfScopeCalculator() {
        this(null);
    }

    public boolean visit(IResourceProxy proxy) {
        boolean inScope = this.fScope.contains(proxy);
        if (inScope && proxy.getType() == 1) {
            IResource file = proxy.requestResource();
            if (!(file instanceof IFile)) {
                return true;
            }
            ParserPath parserPath = DVTFileUtils.getInstance().resource2parser(file);
            IProject project = file.getProject();
            Set<ParserPath> parserPaths = this.fFilesMap.get(project);
            if (parserPaths == null) {
                parserPaths = new HashSet<ParserPath>();
                this.fFilesMap.put(project, parserPaths);
            }
            parserPaths.add(parserPath);
        }
        return inScope;
    }

    public void process() throws CoreException {
        this.fFilesMap = new HashMap<IProject, Set<ParserPath>>();
        if (this.fScope == null) {
            return;
        }
        IResource[] roots = this.fScope.getRoots();
        int i = 0;
        while (i < roots.length) {
            IResource resource = roots[i];
            if (resource.isAccessible()) {
                resource.accept((IResourceProxyVisitor)this, 0);
            }
            ++i;
        }
    }

    public Map<IProject, Set<ParserPath>> getFilesMap() {
        if (this.fFilesMap == null) {
            try {
                this.process();
            }
            catch (CoreException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        return this.fFilesMap;
    }

    public Set<IProject> getProjects() {
        if (this.fFilesMap == null) {
            try {
                this.process();
            }
            catch (CoreException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        return this.fFilesMap.keySet();
    }
}

